/*
 * Decompiled with CFR 0.152.
 */
package scribe.output.format;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scribe.ANSI;
import scribe.ANSI$bg$;
import scribe.ANSI$ctrl$;
import scribe.ANSI$fg$;
import scribe.ANSI$fx$;
import scribe.output.BackgroundColoredOutput;
import scribe.output.BoldOutput;
import scribe.output.Color;
import scribe.output.Color$Black$;
import scribe.output.Color$Blue$;
import scribe.output.Color$BrightBlue$;
import scribe.output.Color$BrightCyan$;
import scribe.output.Color$BrightGreen$;
import scribe.output.Color$BrightMagenta$;
import scribe.output.Color$BrightRed$;
import scribe.output.Color$BrightWhite$;
import scribe.output.Color$BrightYellow$;
import scribe.output.Color$Cyan$;
import scribe.output.Color$Gray$;
import scribe.output.Color$Green$;
import scribe.output.Color$Magenta$;
import scribe.output.Color$Red$;
import scribe.output.Color$White$;
import scribe.output.Color$Yellow$;
import scribe.output.ColoredOutput;
import scribe.output.CompositeOutput;
import scribe.output.EmptyOutput$;
import scribe.output.ItalicOutput;
import scribe.output.LogOutput;
import scribe.output.StrikethroughOutput;
import scribe.output.TextOutput;
import scribe.output.URLOutput;
import scribe.output.UnderlineOutput;
import scribe.output.format.OutputFormat;

public final class ANSIOutputFormat$
implements OutputFormat,
Serializable {
    private static Option<ANSI> fg;
    private static Option<ANSI> bg;
    private static boolean bold;
    private static boolean italic;
    private static boolean underline;
    private static boolean strikethrough;
    public static final ANSIOutputFormat$ MODULE$;

    private ANSIOutputFormat$() {
    }

    static {
        MODULE$ = new ANSIOutputFormat$();
        fg = None$.MODULE$;
        bg = None$.MODULE$;
        bold = false;
        italic = false;
        underline = false;
        strikethrough = false;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ANSIOutputFormat$.class);
    }

    @Override
    public void begin(Function1<String, BoxedUnit> stream) {
    }

    @Override
    public void end(Function1<String, BoxedUnit> stream) {
        stream.apply((Object)ANSI$ctrl$.MODULE$.Reset());
    }

    @Override
    public void apply(LogOutput output, Function1<String, BoxedUnit> stream) {
        ANSIOutputFormat$ aNSIOutputFormat$ = this;
        synchronized (aNSIOutputFormat$) {
            LogOutput logOutput = output;
            if (logOutput instanceof TextOutput) {
                String o = logOutput == null ? null : ((TextOutput)logOutput).plainText();
                stream.apply((Object)o);
            } else if (logOutput instanceof CompositeOutput) {
                CompositeOutput o = (CompositeOutput)logOutput;
                o.entries().foreach((Function1)(JProcedure1 & Serializable)_$3 -> this.apply((LogOutput)_$3, stream));
            } else if (logOutput instanceof ColoredOutput) {
                ColoredOutput o = (ColoredOutput)logOutput;
                ANSI color = this.color2fg(o.color());
                stream.apply((Object)color.ansi());
                Option<ANSI> previous = fg;
                fg = Some$.MODULE$.apply((Object)color);
                try {
                    this.apply(o.output(), stream);
                }
                finally {
                    fg = previous;
                    this.reset$1(stream);
                }
            } else if (logOutput instanceof BackgroundColoredOutput) {
                BackgroundColoredOutput o = (BackgroundColoredOutput)logOutput;
                ANSI color = this.color2bg(o.color());
                stream.apply((Object)color.ansi());
                Option<ANSI> previous = bg;
                bg = Some$.MODULE$.apply((Object)color);
                try {
                    this.apply(o.output(), stream);
                }
                finally {
                    bg = previous;
                    this.reset$1(stream);
                }
            } else if (logOutput instanceof URLOutput) {
                URLOutput o = (URLOutput)logOutput;
                stream.apply((Object)"\u001b]8;;");
                stream.apply((Object)o.url());
                stream.apply((Object)"\u001b\\");
                LogOutput logOutput2 = o.output();
                EmptyOutput$ emptyOutput$ = EmptyOutput$.MODULE$;
                if (!(logOutput2 != null ? !logOutput2.equals(emptyOutput$) : emptyOutput$ != null)) {
                    stream.apply((Object)o.url());
                } else {
                    this.apply(o.output(), stream);
                }
                stream.apply((Object)"\u001b]8;;\u001b\\");
            } else if (logOutput instanceof BoldOutput) {
                LogOutput o = logOutput == null ? null : ((BoldOutput)logOutput).output();
                boolean previous = bold;
                bold = true;
                try {
                    stream.apply((Object)ANSI$fx$.MODULE$.Bold().ansi());
                    this.apply(o, stream);
                }
                finally {
                    bold = previous;
                    this.reset$1(stream);
                }
            } else if (logOutput instanceof ItalicOutput) {
                LogOutput o = logOutput == null ? null : ((ItalicOutput)logOutput).output();
                boolean previous = italic;
                italic = true;
                try {
                    stream.apply((Object)ANSI$fx$.MODULE$.Italic().ansi());
                    this.apply(o, stream);
                }
                finally {
                    italic = previous;
                    this.reset$1(stream);
                }
            } else if (logOutput instanceof UnderlineOutput) {
                LogOutput o = logOutput == null ? null : ((UnderlineOutput)logOutput).output();
                boolean previous = underline;
                underline = true;
                try {
                    stream.apply((Object)ANSI$fx$.MODULE$.Underline().ansi());
                    this.apply(o, stream);
                }
                finally {
                    underline = previous;
                    this.reset$1(stream);
                }
            } else if (logOutput instanceof StrikethroughOutput) {
                LogOutput o = logOutput == null ? null : ((StrikethroughOutput)logOutput).output();
                boolean previous = strikethrough;
                strikethrough = true;
                try {
                    stream.apply((Object)ANSI$fx$.MODULE$.Strikethrough().ansi());
                    this.apply(o, stream);
                }
                finally {
                    strikethrough = previous;
                    this.reset$1(stream);
                }
            } else if (!EmptyOutput$.MODULE$.equals(logOutput)) {
                throw new MatchError((Object)logOutput);
            }
        }
    }

    private ANSI color2fg(Color color) {
        Color color2 = color;
        if (Color$Black$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.Black();
        }
        if (Color$Blue$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.Blue();
        }
        if (Color$Cyan$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.Cyan();
        }
        if (Color$Green$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.Green();
        }
        if (Color$Magenta$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.Magenta();
        }
        if (Color$Red$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.Red();
        }
        if (Color$White$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.White();
        }
        if (Color$Yellow$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.Yellow();
        }
        if (Color$Gray$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.Gray();
        }
        if (Color$BrightBlue$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.BrightBlue();
        }
        if (Color$BrightCyan$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.BrightCyan();
        }
        if (Color$BrightGreen$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.BrightGreen();
        }
        if (Color$BrightMagenta$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.BrightMagenta();
        }
        if (Color$BrightRed$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.BrightRed();
        }
        if (Color$BrightWhite$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.BrightWhite();
        }
        if (Color$BrightYellow$.MODULE$.equals(color2)) {
            return ANSI$fg$.MODULE$.BrightYellow();
        }
        throw new MatchError((Object)color2);
    }

    private ANSI color2bg(Color color) {
        Color color2 = color;
        if (Color$Black$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.Black();
        }
        if (Color$Blue$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.Blue();
        }
        if (Color$Cyan$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.Cyan();
        }
        if (Color$Green$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.Green();
        }
        if (Color$Magenta$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.Magenta();
        }
        if (Color$Red$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.Red();
        }
        if (Color$White$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.White();
        }
        if (Color$Yellow$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.Yellow();
        }
        if (Color$Gray$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.Gray();
        }
        if (Color$BrightBlue$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.BrightBlue();
        }
        if (Color$BrightCyan$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.BrightCyan();
        }
        if (Color$BrightGreen$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.BrightGreen();
        }
        if (Color$BrightMagenta$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.BrightMagenta();
        }
        if (Color$BrightRed$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.BrightRed();
        }
        if (Color$BrightWhite$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.BrightWhite();
        }
        if (Color$BrightYellow$.MODULE$.equals(color2)) {
            return ANSI$bg$.MODULE$.BrightYellow();
        }
        throw new MatchError((Object)color2);
    }

    private final void reset$1(Function1 stream) {
        stream.apply((Object)ANSI$ctrl$.MODULE$.Reset());
        fg.map((Function1 & Serializable)_$1 -> _$1.ansi()).foreach(stream);
        bg.map((Function1 & Serializable)_$2 -> _$2.ansi()).foreach(stream);
        if (bold) {
            stream.apply((Object)ANSI$fx$.MODULE$.Bold().ansi());
        }
        if (italic) {
            stream.apply((Object)ANSI$fx$.MODULE$.Italic().ansi());
        }
        if (underline) {
            stream.apply((Object)ANSI$fx$.MODULE$.Underline().ansi());
        }
        if (strikethrough) {
            stream.apply((Object)ANSI$fx$.MODULE$.Strikethrough().ansi());
            return;
        }
    }
}

