/*
 * Decompiled with CFR 0.152.
 */
package scribe;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scribe.Level;
import scribe.LogFeature;
import scribe.LogRecord;
import scribe.LogRecord$;
import scribe.Logger$;
import scribe.LoggerId;
import scribe.LoggerSupport;
import scribe.MinimumLevel;
import scribe.Priority$;
import scribe.format.Formatter;
import scribe.format.Formatter$;
import scribe.handler.LogHandle;
import scribe.handler.LogHandler;
import scribe.handler.LogHandler$;
import scribe.handler.SynchronousLogHandle$;
import scribe.mdc.MDC;
import scribe.message.LoggableMessage;
import scribe.modify.LevelFilter$;
import scribe.modify.LogBooster;
import scribe.modify.LogBooster$;
import scribe.modify.LogModifier;
import scribe.modify.LogModifier$;
import scribe.output.format.OutputFormat;
import scribe.output.format.OutputFormat$;
import scribe.util.Time$;
import scribe.writer.ConsoleWriter$;
import scribe.writer.Writer;
import sourcecode.FileName;
import sourcecode.Line;
import sourcecode.Name;
import sourcecode.Pkg;

public class Logger
implements LoggerSupport<BoxedUnit>,
Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Logger.class.getDeclaredField("isEmpty$lzy1"));
    private final Option parentId;
    private final List modifiers;
    private final List handlers;
    private final Option overrideClassName;
    private final Map data;
    private final long id;
    private long lastUpdate;
    private Map<Level, Object> includeStatus;
    private volatile Object isEmpty$lzy1;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Logger$.class.getDeclaredField("DefaultRootMinimumLevel$lzy1"));

    public static Level DefaultRootMinimumLevel() {
        return Logger$.MODULE$.DefaultRootMinimumLevel();
    }

    public static long RootId() {
        return Logger$.MODULE$.RootId();
    }

    public static Logger empty() {
        return Logger$.MODULE$.empty();
    }

    public static Logger fromProduct(Product product) {
        return Logger$.MODULE$.fromProduct(product);
    }

    public static Map<String, Logger> loggersByName() {
        return Logger$.MODULE$.loggersByName();
    }

    public static void minimumLevels(Seq<MinimumLevel> seq) {
        Logger$.MODULE$.minimumLevels(seq);
    }

    public static Set<String> namesFor(long l) {
        return Logger$.MODULE$.namesFor(l);
    }

    public static Logger replaceByName(String string, Logger logger) {
        return Logger$.MODULE$.replaceByName(string, logger);
    }

    public static void resetRoot() {
        Logger$.MODULE$.resetRoot();
    }

    public static Logger root() {
        return Logger$.MODULE$.root();
    }

    public static Logger unapply(Logger logger) {
        return Logger$.MODULE$.unapply(logger);
    }

    public static Option<LoggerId> $lessinit$greater$default$1() {
        return Logger$.MODULE$.$lessinit$greater$default$1();
    }

    public static List<LogModifier> $lessinit$greater$default$2() {
        return Logger$.MODULE$.$lessinit$greater$default$2();
    }

    public static List<LogHandler> $lessinit$greater$default$3() {
        return Logger$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<String> $lessinit$greater$default$4() {
        return Logger$.MODULE$.$lessinit$greater$default$4();
    }

    public static Map<String, Function0<Object>> $lessinit$greater$default$5() {
        return Logger$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$6() {
        return Logger$.MODULE$.$lessinit$greater$default$6();
    }

    public Logger(Option<LoggerId> parentId, List<LogModifier> modifiers, List<LogHandler> handlers, Option<String> overrideClassName, Map<String, Function0<Object>> data, long id) {
        this.parentId = parentId;
        this.modifiers = modifiers;
        this.handlers = handlers;
        this.overrideClassName = overrideClassName;
        this.data = data;
        this.id = id;
        this.lastUpdate = Logger$.scribe$Logger$$$lastChange;
        this.includeStatus = Predef$.MODULE$.Map().empty();
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Logger)) return false;
        Logger logger = (Logger)object;
        Option<LoggerId> option = this.parentId();
        Option<LoggerId> option2 = logger.parentId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        List<LogModifier> list = this.modifiers();
        List<LogModifier> list2 = logger.modifiers();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        List<LogHandler> list3 = this.handlers();
        List<LogHandler> list4 = logger.handlers();
        if (list3 == null) {
            if (list4 != null) {
                return false;
            }
        } else if (!list3.equals(list4)) return false;
        Option<String> option3 = this.overrideClassName();
        Option<String> option4 = logger.overrideClassName();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Map<String, Function0<Object>> map = this.data();
        Map<String, Function0<Object>> map2 = logger.data();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        if (this.id() != logger.id()) return false;
        if (!logger.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof Logger;
    }

    public int productArity() {
        return 6;
    }

    public String productPrefix() {
        return "Logger";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return new LoggerId(this._6());
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "parentId";
            }
            case 1: {
                return "modifiers";
            }
            case 2: {
                return "handlers";
            }
            case 3: {
                return "overrideClassName";
            }
            case 4: {
                return "data";
            }
            case 5: {
                return "id";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public Option<LoggerId> parentId() {
        return this.parentId;
    }

    public List<LogModifier> modifiers() {
        return this.modifiers;
    }

    public List<LogHandler> handlers() {
        return this.handlers;
    }

    public Option<String> overrideClassName() {
        return this.overrideClassName;
    }

    public Map<String, Function0<Object>> data() {
        return this.data;
    }

    public long id() {
        return this.id;
    }

    public boolean isEmpty() {
        Object object = this.isEmpty$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.isEmpty$lzyINIT1());
    }

    private Object isEmpty$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.isEmpty$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((this.modifiers().isEmpty() && this.handlers().isEmpty() ? 1 : 0) != 0);
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.isEmpty$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Logger reset() {
        return this.copy((Option<LoggerId>)Some$.MODULE$.apply((Object)new LoggerId(Logger$.MODULE$.RootId())), (List<LogModifier>)package$.MODULE$.Nil(), (List<LogHandler>)package$.MODULE$.Nil(), (Option<String>)None$.MODULE$, this.copy$default$5(), this.copy$default$6());
    }

    public Logger orphan() {
        return this.copy((Option<LoggerId>)None$.MODULE$, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public Logger withParent(String name) {
        return this.copy((Option<LoggerId>)Some$.MODULE$.apply((Object)new LoggerId(Logger$.MODULE$.apply(name).id())), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public Logger withParent(Logger logger) {
        return this.copy((Option<LoggerId>)Some$.MODULE$.apply((Object)new LoggerId(logger.id())), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public Logger withParent(long id) {
        return this.copy((Option<LoggerId>)Some$.MODULE$.apply((Object)new LoggerId(id)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public Logger withHandler(LogHandler handler) {
        List list = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogHandler[]{handler}))).$colon$colon$colon(this.handlers());
        Option<LoggerId> option = this.copy$default$1();
        List<LogModifier> list2 = this.copy$default$2();
        Option<String> option2 = this.copy$default$4();
        Map<String, Function0<Object>> map = this.copy$default$5();
        long l = this.copy$default$6();
        return this.copy(option, list2, (List<LogHandler>)list, option2, map, l);
    }

    public Logger withHandler(Formatter formatter, Writer writer, Option<Level> minimumLevel, List<LogModifier> modifiers, OutputFormat outputFormat, LogHandle handle) {
        return this.withHandler(LogHandler$.MODULE$.apply(formatter, writer, minimumLevel, modifiers, outputFormat, handle));
    }

    public Formatter withHandler$default$1() {
        return Formatter$.MODULE$.default();
    }

    public Writer withHandler$default$2() {
        return ConsoleWriter$.MODULE$;
    }

    public Option<Level> withHandler$default$3() {
        return None$.MODULE$;
    }

    public List<LogModifier> withHandler$default$4() {
        return package$.MODULE$.Nil();
    }

    public OutputFormat withHandler$default$5() {
        return OutputFormat$.MODULE$.default();
    }

    public LogHandle withHandler$default$6() {
        return SynchronousLogHandle$.MODULE$;
    }

    public Logger withoutHandler(LogHandler handler) {
        List list = this.handlers().filterNot((Function1 & Serializable)_$1 -> {
            LogHandler logHandler = _$1;
            LogHandler logHandler2 = handler;
            return !(logHandler != null ? !logHandler.equals(logHandler2) : logHandler2 != null);
        });
        Option<LoggerId> option = this.copy$default$1();
        List<LogModifier> list2 = this.copy$default$2();
        Option<String> option2 = this.copy$default$4();
        Map<String, Function0<Object>> map = this.copy$default$5();
        long l = this.copy$default$6();
        return this.copy(option, list2, (List<LogHandler>)list, option2, map, l);
    }

    public Logger clearHandlers() {
        return this.copy(this.copy$default$1(), this.copy$default$2(), (List<LogHandler>)package$.MODULE$.Nil(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
    }

    public Logger withClassNameOverride(String className) {
        Option option = Option$.MODULE$.apply((Object)className);
        Option<LoggerId> option2 = this.copy$default$1();
        List<LogModifier> list = this.copy$default$2();
        List<LogHandler> list2 = this.copy$default$3();
        Map<String, Function0<Object>> map = this.copy$default$5();
        long l = this.copy$default$6();
        return this.copy(option2, list, list2, (Option<String>)option, map, l);
    }

    public Logger setModifiers(List<LogModifier> modifiers) {
        List list = (List)modifiers.sorted(LogModifier$.MODULE$.LogModifierOrdering());
        Option<LoggerId> option = this.copy$default$1();
        List<LogHandler> list2 = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        Map<String, Function0<Object>> map = this.copy$default$5();
        long l = this.copy$default$6();
        return this.copy(option, (List<LogModifier>)list, list2, option2, map, l);
    }

    public Logger clearModifiers() {
        return this.setModifiers((List<LogModifier>)package$.MODULE$.Nil());
    }

    public Logger set(String key, Function0<Object> value) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
        Map map = (Map)this.data().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, value));
        Option<LoggerId> option = this.copy$default$1();
        List<LogModifier> list = this.copy$default$2();
        List<LogHandler> list2 = this.copy$default$3();
        Option<String> option2 = this.copy$default$4();
        long l = this.copy$default$6();
        return this.copy(option, list, list2, option2, (Map<String, Function0<Object>>)map, l);
    }

    public Option<Object> get(String key) {
        return this.data().get((Object)key).map((Function1 & Serializable)_$2 -> _$2.apply());
    }

    public final Logger withModifier(LogModifier modifier) {
        List list = this.modifiers().filterNot((Function1 & Serializable)m -> {
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(m.id()))) return false;
            String string = m.id();
            String string2 = modifier.id();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        });
        return this.setModifiers((List<LogModifier>)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogModifier[]{modifier}))).$colon$colon$colon(list));
    }

    public final Logger withoutModifier(LogModifier modifier) {
        return this.setModifiers((List<LogModifier>)this.modifiers().filterNot((Function1 & Serializable)m -> {
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(m.id()))) return false;
            String string = m.id();
            String string2 = modifier.id();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }));
    }

    @Override
    public void log(Level level, MDC mdc, Seq<LogFeature> features, Pkg pkg, FileName fileName, Name name, Line line) {
        if (this.includes(level)) {
            LoggerSupport.log$(this, level, mdc, features, pkg, fileName, name, line);
            return;
        }
    }

    public boolean includes(Level level) {
        Option option;
        if (this.lastUpdate != Logger$.scribe$Logger$$$lastChange) {
            this.includeStatus = Predef$.MODULE$.Map().empty();
            this.lastUpdate = Logger$.scribe$Logger$$$lastChange;
        }
        if ((option = this.includeStatus.get((Object)level)) instanceof Some) {
            boolean b = BoxesRunTime.unboxToBoolean((Object)((Some)option).value());
            return b;
        }
        if (None$.MODULE$.equals(option)) {
            boolean b = this.shouldLog(LogRecord$.MODULE$.simple("", "", "", LogRecord$.MODULE$.simple$default$4(), LogRecord$.MODULE$.simple$default$5(), LogRecord$.MODULE$.simple$default$6(), level, LogRecord$.MODULE$.simple$default$8(), LogRecord$.MODULE$.simple$default$9(), LogRecord$.MODULE$.simple$default$10()));
            Logger logger = this;
            synchronized (logger) {
                Level level2 = (Level)Predef$.MODULE$.ArrowAssoc((Object)level);
                this.includeStatus = (Map)this.includeStatus.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)level2, (Object)BoxesRunTime.boxToBoolean((boolean)b)));
            }
            return b;
        }
        throw new MatchError((Object)option);
    }

    public <M extends LogModifier> Option<M> modifierById(String id, boolean recursive) {
        return this.modifiers().find((Function1 & Serializable)m -> {
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(m.id()))) return false;
            String string = m.id();
            String string2 = id;
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }).orElse(() -> this.modifierById$$anonfun$2(id, recursive)).map((Function1 & Serializable)_$3 -> _$3);
    }

    public Logger withMinimumLevel(Level level) {
        return this.withModifier(LevelFilter$.MODULE$.$greater$eq(level));
    }

    public Logger withBoost(Function1<Object, Object> booster, double priority) {
        return this.withModifier(new LogBooster(booster, priority, LogBooster$.MODULE$.$lessinit$greater$default$3()));
    }

    public double withBoost$default$2() {
        return Priority$.MODULE$.Normal();
    }

    public Logger withBoostOneLevel() {
        return this.withBoost((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)_$4 -> _$4 + 100.0, this.withBoost$default$2());
    }

    public Logger withBoosted(Level minimumLevel, Level destinationLevel) {
        return this.withBoost((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)d -> {
            if (d >= minimumLevel.value() && d <= destinationLevel.value()) {
                return destinationLevel.value();
            }
            return d;
        }, this.withBoost$default$2());
    }

    @Override
    public final void log(LogRecord record) {
        LogRecord logRecord;
        if (this.data().nonEmpty()) {
            Map map = (Map)this.data().$plus$plus(record.data());
            Level level = record.copy$default$1();
            double d = record.copy$default$2();
            List<LoggableMessage> list = record.copy$default$3();
            String string = record.copy$default$4();
            String string2 = record.copy$default$5();
            Option<String> option = record.copy$default$6();
            Option<Object> option2 = record.copy$default$7();
            Option<Object> option3 = record.copy$default$8();
            Thread thread = record.copy$default$9();
            long l = record.copy$default$11();
            logRecord = record.copy(level, d, list, string, string2, option, option2, option3, thread, (Map<String, Function0<Object>>)map, l);
        } else {
            logRecord = record;
        }
        LogRecord r2 = logRecord;
        r2.modify(this.modifiers()).foreach((Function1)(JProcedure1 & Serializable)r -> {
            this.handlers().foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.log((LogRecord)r));
            this.parentId().map((Function1 & Serializable)id -> Logger$.MODULE$.apply(id == null ? BoxesRunTime.unboxToLong(null) : ((LoggerId)id).value())).foreach((Function1)(JProcedure1 & Serializable)_$6 -> _$6.log((LogRecord)r));
        });
    }

    public boolean shouldLog(LogRecord record) {
        Option<LogRecord> option = record.modify(this.modifiers());
        if (option instanceof Some) {
            if (this.handlers().nonEmpty()) {
                return true;
            }
            LogRecord r = (LogRecord)((Some)option).value();
            return this.parentId().map((Function1 & Serializable)id -> Logger$.MODULE$.apply(id == null ? BoxesRunTime.unboxToLong(null) : ((LoggerId)id).value())).exists((Function1 & Serializable)p -> p.shouldLog(r));
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    public Logger replace(Option<String> name) {
        Option<String> option = name;
        if (option instanceof Some) {
            String n = (String)((Some)option).value();
            return Logger$.MODULE$.replaceByName(n, this);
        }
        if (None$.MODULE$.equals(option)) {
            return Logger$.MODULE$.replace(this);
        }
        throw new MatchError(option);
    }

    public Option<String> replace$default$1() {
        return None$.MODULE$;
    }

    public void remove() {
        Logger$.MODULE$.remove(this);
    }

    public void logDirect(Level level, List<LoggableMessage> messages, String fileName, String className, Option<String> methodName, Option<Object> line, Option<Object> column, Thread thread, long timeStamp) {
        String string = (String)this.overrideClassName().getOrElse(() -> Logger.$anonfun$3(className));
        Map<String, Function0<Object>> map = LogRecord$.MODULE$.$lessinit$greater$default$10();
        this.log(LogRecord$.MODULE$.apply(level, level.value(), messages, fileName, string, methodName, line, column, thread, map, timeStamp));
    }

    public List<LoggableMessage> logDirect$default$2() {
        return package$.MODULE$.Nil();
    }

    public String logDirect$default$3() {
        return "";
    }

    public String logDirect$default$4() {
        return "";
    }

    public Option<String> logDirect$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> logDirect$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> logDirect$default$7() {
        return None$.MODULE$;
    }

    public Thread logDirect$default$8() {
        return Thread.currentThread();
    }

    public long logDirect$default$9() {
        return Time$.MODULE$.apply();
    }

    public Logger copy(Option<LoggerId> parentId, List<LogModifier> modifiers, List<LogHandler> handlers, Option<String> overrideClassName, Map<String, Function0<Object>> data, long id) {
        return new Logger(parentId, modifiers, handlers, overrideClassName, data, id);
    }

    public Option<LoggerId> copy$default$1() {
        return this.parentId();
    }

    public List<LogModifier> copy$default$2() {
        return this.modifiers();
    }

    public List<LogHandler> copy$default$3() {
        return this.handlers();
    }

    public Option<String> copy$default$4() {
        return this.overrideClassName();
    }

    public Map<String, Function0<Object>> copy$default$5() {
        return this.data();
    }

    public long copy$default$6() {
        return this.id();
    }

    public Option<LoggerId> _1() {
        return this.parentId();
    }

    public List<LogModifier> _2() {
        return this.modifiers();
    }

    public List<LogHandler> _3() {
        return this.handlers();
    }

    public Option<String> _4() {
        return this.overrideClassName();
    }

    public Map<String, Function0<Object>> _5() {
        return this.data();
    }

    public long _6() {
        return this.id();
    }

    private final Option modifierById$$anonfun$2(String id$7, boolean recursive$1) {
        Option<LoggerId> option = this.parentId();
        if (!recursive$1) {
            return None$.MODULE$;
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        if (option instanceof Some) {
            Object object = ((Some)option).value();
            long pId = object == null ? BoxesRunTime.unboxToLong(null) : ((LoggerId)object).value();
            return Logger$.MODULE$.apply(pId).modifierById(id$7, recursive$1);
        }
        throw new MatchError(option);
    }

    private static final String $anonfun$3(String className$3) {
        return className$3;
    }
}

