/*
 * Decompiled with CFR 0.152.
 */
package scribe.format;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scribe.LogRecord;
import scribe.format.AbbreviateBlock;
import scribe.format.FormatBlock$;
import scribe.format.FormatBlock$MDCReference$;
import scribe.format.FormatBlock$Mapped$;
import scribe.format.FormatBlock$MappedPlain$;
import scribe.format.FormatBlock$MultiLine$;
import scribe.format.FormatBlock$NewLine$;
import scribe.format.FormatBlock$RawString$;
import scribe.format.RightPaddingBlock;
import scribe.mdc.MDC$;
import scribe.output.CompositeOutput;
import scribe.output.LogOutput;
import scribe.output.TextOutput;

public interface FormatBlock {
    public static FormatBlock apply(Function1<LogRecord, LogOutput> function1) {
        return FormatBlock$.MODULE$.apply(function1);
    }

    public LogOutput format(LogRecord var1);

    public static FormatBlock abbreviate$(FormatBlock $this, int maxLength, boolean padded, char separator, boolean removeEntries, boolean abbreviateName) {
        return $this.abbreviate(maxLength, padded, separator, removeEntries, abbreviateName);
    }

    default public FormatBlock abbreviate(int maxLength, boolean padded, char separator, boolean removeEntries, boolean abbreviateName) {
        AbbreviateBlock block = new AbbreviateBlock(this, maxLength, separator, removeEntries, abbreviateName);
        if (padded) {
            return new RightPaddingBlock(block, maxLength, ' ');
        }
        return block;
    }

    public static boolean abbreviate$default$2$(FormatBlock $this) {
        return $this.abbreviate$default$2();
    }

    default public boolean abbreviate$default$2() {
        return false;
    }

    public static char abbreviate$default$3$(FormatBlock $this) {
        return $this.abbreviate$default$3();
    }

    default public char abbreviate$default$3() {
        return '.';
    }

    public static boolean abbreviate$default$4$(FormatBlock $this) {
        return $this.abbreviate$default$4();
    }

    default public boolean abbreviate$default$4() {
        return true;
    }

    public static boolean abbreviate$default$5$(FormatBlock $this) {
        return $this.abbreviate$default$5();
    }

    default public boolean abbreviate$default$5() {
        return false;
    }

    public static FormatBlock map$(FormatBlock $this, Function1 f) {
        return $this.map((Function1<LogOutput, LogOutput>)f);
    }

    default public FormatBlock map(Function1<LogOutput, LogOutput> f) {
        return FormatBlock$Mapped$.MODULE$.apply(this, f);
    }

    public static FormatBlock mapPlain$(FormatBlock $this, Function1 f) {
        return $this.mapPlain((Function1<String, String>)f);
    }

    default public FormatBlock mapPlain(Function1<String, String> f) {
        return FormatBlock$MappedPlain$.MODULE$.apply(this, f);
    }

    public static FormatBlock padRight$(FormatBlock $this, int length, char padding) {
        return $this.padRight(length, padding);
    }

    default public FormatBlock padRight(int length, char padding) {
        return new RightPaddingBlock(this, length, padding);
    }

    public static char padRight$default$2$(FormatBlock $this) {
        return $this.padRight$default$2();
    }

    default public char padRight$default$2() {
        return ' ';
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class MDCReference
    implements FormatBlock,
    Product,
    Serializable {
        private final String key;
        private final Function0 default;
        private final Option prefix;
        private final Option postfix;

        public static MDCReference apply(String string, Function0<Object> function0, Option<FormatBlock> option, Option<FormatBlock> option2) {
            return FormatBlock$MDCReference$.MODULE$.apply(string, function0, option, option2);
        }

        public static MDCReference fromProduct(Product product) {
            return FormatBlock$MDCReference$.MODULE$.fromProduct(product);
        }

        public static MDCReference unapply(MDCReference mDCReference) {
            return FormatBlock$MDCReference$.MODULE$.unapply(mDCReference);
        }

        public MDCReference(String key, Function0<Object> function0, Option<FormatBlock> prefix, Option<FormatBlock> postfix) {
            this.key = key;
            this.default = function0;
            this.prefix = prefix;
            this.postfix = postfix;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MDCReference)) return false;
            MDCReference mDCReference = (MDCReference)object;
            String string = this.key();
            String string2 = mDCReference.key();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Function0<Object> function0 = this.default();
            Function0<Object> function02 = mDCReference.default();
            if (function0 == null) {
                if (function02 != null) {
                    return false;
                }
            } else if (!function0.equals(function02)) return false;
            Option<FormatBlock> option = this.prefix();
            Option<FormatBlock> option2 = mDCReference.prefix();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<FormatBlock> option3 = this.postfix();
            Option<FormatBlock> option4 = mDCReference.postfix();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!mDCReference.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MDCReference;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "MDCReference";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "default";
                }
                case 2: {
                    return "prefix";
                }
                case 3: {
                    return "postfix";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String key() {
            return this.key;
        }

        public Function0<Object> default() {
            return this.default;
        }

        public Option<FormatBlock> prefix() {
            return this.prefix;
        }

        public Option<FormatBlock> postfix() {
            return this.postfix;
        }

        @Override
        public LogOutput format(LogRecord record) {
            LogOutput logOutput;
            Option<Object> option = MDC$.MODULE$.get(this.key());
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                String text = value.toString();
                logOutput = this.prefix().nonEmpty() || this.postfix().nonEmpty() ? new CompositeOutput((List<LogOutput>)((List)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.prefix().map((Function1 & Serializable)_$3 -> _$3.format(record)), Option$.MODULE$.apply((Object)new TextOutput(text)), this.postfix().map((Function1 & Serializable)_$4 -> _$4.format(record))}))).flatten(Predef$.MODULE$.$conforms()))) : new TextOutput(text);
            } else if (None$.MODULE$.equals(option)) {
                logOutput = new TextOutput(this.default().apply().toString());
            } else {
                throw new MatchError(option);
            }
            return logOutput;
        }

        public MDCReference copy(String key, Function0<Object> function0, Option<FormatBlock> prefix, Option<FormatBlock> postfix) {
            return new MDCReference(key, function0, prefix, postfix);
        }

        public String copy$default$1() {
            return this.key();
        }

        public Function0<Object> copy$default$2() {
            return this.default();
        }

        public Option<FormatBlock> copy$default$3() {
            return this.prefix();
        }

        public Option<FormatBlock> copy$default$4() {
            return this.postfix();
        }

        public String _1() {
            return this.key();
        }

        public Function0<Object> _2() {
            return this.default();
        }

        public Option<FormatBlock> _3() {
            return this.prefix();
        }

        public Option<FormatBlock> _4() {
            return this.postfix();
        }
    }

    public static class Mapped
    implements FormatBlock,
    Product,
    Serializable {
        private final FormatBlock block;
        private final Function1 f;

        public static Mapped apply(FormatBlock formatBlock, Function1<LogOutput, LogOutput> function1) {
            return FormatBlock$Mapped$.MODULE$.apply(formatBlock, function1);
        }

        public static Mapped fromProduct(Product product) {
            return FormatBlock$Mapped$.MODULE$.fromProduct(product);
        }

        public static Mapped unapply(Mapped mapped) {
            return FormatBlock$Mapped$.MODULE$.unapply(mapped);
        }

        public Mapped(FormatBlock block, Function1<LogOutput, LogOutput> f) {
            this.block = block;
            this.f = f;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Mapped)) return false;
            Mapped mapped = (Mapped)object;
            FormatBlock formatBlock = this.block();
            FormatBlock formatBlock2 = mapped.block();
            if (formatBlock == null) {
                if (formatBlock2 != null) {
                    return false;
                }
            } else if (!formatBlock.equals(formatBlock2)) return false;
            Function1<LogOutput, LogOutput> function1 = this.f();
            Function1<LogOutput, LogOutput> function12 = mapped.f();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!mapped.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Mapped;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Mapped";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "block";
            }
            if (1 == n2) {
                return "f";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public FormatBlock block() {
            return this.block;
        }

        public Function1<LogOutput, LogOutput> f() {
            return this.f;
        }

        @Override
        public LogOutput format(LogRecord record) {
            return (LogOutput)this.f().apply((Object)this.block().format(record));
        }

        public Mapped copy(FormatBlock block, Function1<LogOutput, LogOutput> f) {
            return new Mapped(block, f);
        }

        public FormatBlock copy$default$1() {
            return this.block();
        }

        public Function1<LogOutput, LogOutput> copy$default$2() {
            return this.f();
        }

        public FormatBlock _1() {
            return this.block();
        }

        public Function1<LogOutput, LogOutput> _2() {
            return this.f();
        }
    }

    public static class MappedPlain
    implements FormatBlock,
    Product,
    Serializable {
        private final FormatBlock block;
        private final Function1 f;

        public static MappedPlain apply(FormatBlock formatBlock, Function1<String, String> function1) {
            return FormatBlock$MappedPlain$.MODULE$.apply(formatBlock, function1);
        }

        public static MappedPlain fromProduct(Product product) {
            return FormatBlock$MappedPlain$.MODULE$.fromProduct(product);
        }

        public static MappedPlain unapply(MappedPlain mappedPlain) {
            return FormatBlock$MappedPlain$.MODULE$.unapply(mappedPlain);
        }

        public MappedPlain(FormatBlock block, Function1<String, String> f) {
            this.block = block;
            this.f = f;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MappedPlain)) return false;
            MappedPlain mappedPlain = (MappedPlain)object;
            FormatBlock formatBlock = this.block();
            FormatBlock formatBlock2 = mappedPlain.block();
            if (formatBlock == null) {
                if (formatBlock2 != null) {
                    return false;
                }
            } else if (!formatBlock.equals(formatBlock2)) return false;
            Function1<String, String> function1 = this.f();
            Function1<String, String> function12 = mappedPlain.f();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!mappedPlain.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MappedPlain;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MappedPlain";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "block";
            }
            if (1 == n2) {
                return "f";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public FormatBlock block() {
            return this.block;
        }

        public Function1<String, String> f() {
            return this.f;
        }

        @Override
        public LogOutput format(LogRecord record) {
            return this.block().format(record).map(this.f());
        }

        public MappedPlain copy(FormatBlock block, Function1<String, String> f) {
            return new MappedPlain(block, f);
        }

        public FormatBlock copy$default$1() {
            return this.block();
        }

        public Function1<String, String> copy$default$2() {
            return this.f();
        }

        public FormatBlock _1() {
            return this.block();
        }

        public Function1<String, String> _2() {
            return this.f();
        }
    }

    public static class MultiLine
    implements FormatBlock,
    Product,
    Serializable {
        private final Function0 maxChars;
        private final String prefix;
        private final List blocks;

        public static int DefaultMaxChars() {
            return FormatBlock$MultiLine$.MODULE$.DefaultMaxChars();
        }

        public static Function0<Object> PlatformColumns() {
            return FormatBlock$MultiLine$.MODULE$.PlatformColumns();
        }

        public static MultiLine apply(Function0<Object> function0, String string, List<FormatBlock> list) {
            return FormatBlock$MultiLine$.MODULE$.apply(function0, string, list);
        }

        public static MultiLine fromProduct(Product product) {
            return FormatBlock$MultiLine$.MODULE$.fromProduct(product);
        }

        public static List<LogOutput> splitNewLines(List<LogOutput> list) {
            return FormatBlock$MultiLine$.MODULE$.splitNewLines(list);
        }

        public static MultiLine unapply(MultiLine multiLine) {
            return FormatBlock$MultiLine$.MODULE$.unapply(multiLine);
        }

        public static Function0<Object> $lessinit$greater$default$1() {
            return FormatBlock$MultiLine$.MODULE$.$lessinit$greater$default$1();
        }

        public static String $lessinit$greater$default$2() {
            return FormatBlock$MultiLine$.MODULE$.$lessinit$greater$default$2();
        }

        public MultiLine(Function0<Object> maxChars, String prefix, List<FormatBlock> blocks) {
            this.maxChars = maxChars;
            this.prefix = prefix;
            this.blocks = blocks;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MultiLine)) return false;
            MultiLine multiLine = (MultiLine)object;
            Function0<Object> function0 = this.maxChars();
            Function0<Object> function02 = multiLine.maxChars();
            if (function0 == null) {
                if (function02 != null) {
                    return false;
                }
            } else if (!function0.equals(function02)) return false;
            String string = this.prefix();
            String string2 = multiLine.prefix();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            List<FormatBlock> list = this.blocks();
            List<FormatBlock> list2 = multiLine.blocks();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            if (!multiLine.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MultiLine;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "MultiLine";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "maxChars";
                }
                case 1: {
                    return "prefix";
                }
                case 2: {
                    return "blocks";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function0<Object> maxChars() {
            return this.maxChars;
        }

        public String prefix() {
            return this.prefix;
        }

        public List<FormatBlock> blocks() {
            return this.blocks;
        }

        @Override
        public LogOutput format(LogRecord record) {
            String pre = this.prefix();
            int max = this.maxChars().apply$mcI$sp() - this.prefix().length();
            LogOutput newLine = FormatBlock$NewLine$.MODULE$.format(record);
            List<LogOutput> outputs = FormatBlock$MultiLine$.MODULE$.splitNewLines((List<LogOutput>)this.blocks().map((Function1 & Serializable)_$5 -> _$5.format(record)));
            List list = outputs.flatMap((Function1 & Serializable)output -> {
                LogOutput current = output;
                List list = package$.MODULE$.List().empty();
                while (current.length() > max) {
                    Tuple2<LogOutput, LogOutput> tuple2 = current.splitAt(max);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    LogOutput left = (LogOutput)tuple2._1();
                    LogOutput right = (LogOutput)tuple2._2();
                    Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)left, (Object)right);
                    LogOutput left2 = (LogOutput)tuple22._1();
                    LogOutput right2 = (LogOutput)tuple22._2();
                    List list2 = list;
                    list = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new LogOutput[]{new TextOutput(pre), left2, newLine}))).$colon$colon$colon(list2);
                    current = right2;
                }
                List list3 = list;
                list = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new LogOutput[]{new TextOutput(pre), current}))).$colon$colon$colon(list3);
                return list;
            });
            return new CompositeOutput((List<LogOutput>)list);
        }

        public MultiLine copy(Function0<Object> maxChars, String prefix, List<FormatBlock> blocks) {
            return new MultiLine(maxChars, prefix, blocks);
        }

        public Function0<Object> copy$default$1() {
            return this.maxChars();
        }

        public String copy$default$2() {
            return this.prefix();
        }

        public List<FormatBlock> copy$default$3() {
            return this.blocks();
        }

        public Function0<Object> _1() {
            return this.maxChars();
        }

        public String _2() {
            return this.prefix();
        }

        public List<FormatBlock> _3() {
            return this.blocks();
        }
    }

    public static class RawString
    implements FormatBlock,
    Product,
    Serializable {
        private final String s;

        public static RawString apply(String string) {
            return FormatBlock$RawString$.MODULE$.apply(string);
        }

        public static RawString fromProduct(Product product) {
            return FormatBlock$RawString$.MODULE$.fromProduct(product);
        }

        public static RawString unapply(RawString rawString) {
            return FormatBlock$RawString$.MODULE$.unapply(rawString);
        }

        public RawString(String s) {
            this.s = s;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RawString)) return false;
            RawString rawString = (RawString)object;
            String string = this.s();
            String string2 = rawString.s();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!rawString.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RawString;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RawString";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "s";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String s() {
            return this.s;
        }

        @Override
        public LogOutput format(LogRecord record) {
            return new TextOutput(this.s());
        }

        public RawString copy(String s) {
            return new RawString(s);
        }

        public String copy$default$1() {
            return this.s();
        }

        public String _1() {
            return this.s();
        }
    }
}

