/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session;

import com.ovea.jetty.session.SessionManagerSkeleton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.AbstractSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class SessionIdManagerSkeleton
extends AbstractSessionIdManager {
    static final Logger LOG = Log.getLogger((String)"com.ovea.jetty.session");
    private final ConcurrentMap<String, Object> sessions = new ConcurrentHashMap<String, Object>();
    private final Server server;
    private long scavengerInterval = 60000L;
    private ScheduledFuture<?> scavenger;
    private ScheduledExecutorService executorService;

    protected SessionIdManagerSkeleton(Server server) {
        this.server = server;
    }

    public final void setScavengerInterval(long scavengerInterval) {
        this.scavengerInterval = scavengerInterval;
    }

    protected final void doStart() throws Exception {
        this.sessions.clear();
        if (this.scavenger != null) {
            this.scavenger.cancel(true);
            this.scavenger = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        if (this.scavengerInterval > 0L) {
            this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setName("RedisSessionIdManager-ScavengerThread");
                    return t;
                }
            });
            this.scavenger = this.executorService.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    if (!SessionIdManagerSkeleton.this.sessions.isEmpty()) {
                        try {
                            final List<String> expired = SessionIdManagerSkeleton.this.scavenge(new ArrayList<String>(SessionIdManagerSkeleton.this.sessions.keySet()));
                            for (String clusterId : expired) {
                                SessionIdManagerSkeleton.this.sessions.remove(clusterId);
                            }
                            SessionIdManagerSkeleton.this.forEachSessionManager(new SessionManagerCallback(){

                                @Override
                                public void execute(SessionManagerSkeleton sessionManager) {
                                    sessionManager.expire(expired);
                                }
                            });
                        }
                        catch (Exception e) {
                            LOG.warn("Scavenger thread failure: " + e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }, this.scavengerInterval, this.scavengerInterval, TimeUnit.MILLISECONDS);
        }
        super.doStart();
    }

    protected final void doStop() throws Exception {
        this.sessions.clear();
        if (this.scavenger != null) {
            this.scavenger.cancel(true);
            this.scavenger = null;
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
        super.doStop();
    }

    public final String getClusterId(String nodeId) {
        int dot = nodeId.lastIndexOf(46);
        return dot > 0 ? nodeId.substring(0, dot) : nodeId;
    }

    public final String getNodeId(String clusterId, HttpServletRequest request) {
        if (this._workerName != null) {
            return clusterId + '.' + this._workerName;
        }
        return clusterId;
    }

    public final boolean idInUse(String id) {
        String cid = this.getClusterId(id);
        return id != null && (this.sessions.containsKey(cid) || this.hasClusterId(cid));
    }

    public final void addSession(HttpSession session) {
        String clusterId = this.getClusterId(session.getId());
        this.storeClusterId(clusterId);
        this.sessions.putIfAbsent(clusterId, Void.class);
    }

    public final void removeSession(HttpSession session) {
        String clusterId = this.getClusterId(session.getId());
        if (this.sessions.containsKey(clusterId)) {
            this.sessions.remove(clusterId);
            this.deleteClusterId(clusterId);
        }
    }

    public final void invalidateAll(final String clusterId) {
        if (this.sessions.containsKey(clusterId)) {
            this.sessions.remove(clusterId);
            this.deleteClusterId(clusterId);
            this.forEachSessionManager(new SessionManagerCallback(){

                @Override
                public void execute(SessionManagerSkeleton sessionManager) {
                    sessionManager.invalidateSession(clusterId);
                }
            });
        }
    }

    protected abstract void deleteClusterId(String var1);

    protected abstract void storeClusterId(String var1);

    protected abstract boolean hasClusterId(String var1);

    protected abstract List<String> scavenge(List<String> var1);

    private void forEachSessionManager(SessionManagerCallback callback) {
        Handler[] contexts = this.server.getChildHandlersByClass(ContextHandler.class);
        for (int i = 0; contexts != null && i < contexts.length; ++i) {
            SessionManager manager;
            SessionHandler sessionHandler = (SessionHandler)((ContextHandler)contexts[i]).getChildHandlerByClass(SessionHandler.class);
            if (sessionHandler == null || (manager = sessionHandler.getSessionManager()) == null || !(manager instanceof SessionManagerSkeleton)) continue;
            callback.execute((SessionManagerSkeleton)manager);
        }
    }

    private static interface SessionManagerCallback {
        public void execute(SessionManagerSkeleton var1);
    }
}

