/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer;

import com.ovea.jetty.session.SerializerException;
import com.ovea.jetty.session.serializer.SerializerSkeleton;
import java.io.IOException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.VisibilityChecker;

public final class JsonSerializer
extends SerializerSkeleton {
    private ObjectMapper mapper;

    @Override
    public void start() {
        this.mapper = new ObjectMapper();
        this.mapper.configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, false);
        this.mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, false);
        this.mapper.configure(SerializationConfig.Feature.AUTO_DETECT_GETTERS, false);
        this.mapper.configure(SerializationConfig.Feature.AUTO_DETECT_IS_GETTERS, false);
        this.mapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        this.mapper.configure(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        this.mapper.configure(SerializationConfig.Feature.USE_STATIC_TYPING, false);
        this.mapper.configure(SerializationConfig.Feature.WRITE_ENUMS_USING_TO_STRING, false);
        this.mapper.configure(SerializationConfig.Feature.SORT_PROPERTIES_ALPHABETICALLY, true);
        this.mapper.configure(SerializationConfig.Feature.USE_ANNOTATIONS, true);
        this.mapper.configure(DeserializationConfig.Feature.USE_ANNOTATIONS, true);
        this.mapper.configure(DeserializationConfig.Feature.AUTO_DETECT_SETTERS, false);
        this.mapper.configure(DeserializationConfig.Feature.AUTO_DETECT_CREATORS, true);
        this.mapper.configure(DeserializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        this.mapper.configure(DeserializationConfig.Feature.USE_GETTERS_AS_SETTERS, false);
        this.mapper.configure(DeserializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS, true);
        this.mapper.configure(DeserializationConfig.Feature.READ_ENUMS_USING_TO_STRING, true);
        this.mapper.setVisibilityChecker((VisibilityChecker)new VisibilityChecker.Std(JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY, JsonAutoDetect.Visibility.ANY));
        super.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.mapper = null;
    }

    @Override
    public String serialize(Object o) throws SerializerException {
        try {
            return this.mapper.writeValueAsString(o);
        }
        catch (IOException e) {
            throw new SerializerException(e);
        }
    }

    @Override
    public <T> T deserialize(String o, Class<T> targetType) throws SerializerException {
        try {
            return (T)this.mapper.readValue(o, targetType);
        }
        catch (IOException e) {
            throw new SerializerException(e);
        }
    }
}

