/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer.jboss.serial.classmetamodel;

import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassMetaDataSlot;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ConstructorManager;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.DefaultConstructorManager;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.SunConstructorManager;
import com.ovea.jetty.session.serializer.jboss.serial.exception.SerializationException;
import com.ovea.jetty.session.serializer.jboss.serial.io.Immutable;
import com.ovea.jetty.session.serializer.jboss.serial.references.MethodPersistentReference;
import com.ovea.jetty.session.serializer.jboss.serial.references.PersistentReference;
import com.ovea.jetty.session.serializer.jboss.serial.util.ClassMetaConsts;
import com.ovea.jetty.session.serializer.jboss.serial.util.HashStringUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;

public class ClassMetaData
implements ClassMetaConsts {
    static ConstructorManager[] constructorManagers = new ConstructorManager[]{new SunConstructorManager(), new DefaultConstructorManager()};
    PersistentReference constructor = emptyReference;
    WeakReference clazz;
    WeakReference arrayRep;
    String className;
    boolean isArray;
    int arrayDepth;
    boolean isProxy;
    boolean isExternalizable;
    boolean isSerializable;
    boolean isImmutable;
    long shaHash;
    PersistentReference readResolveMethod = emptyReference;
    PersistentReference writeReplaceMethod = emptyReference;
    ClassMetaDataSlot[] slots;

    private Method lookupMethodOnHierarchy(Class clazz, String methodName, Class[] reflectionArguments) {
        for (Class currentClass = clazz; currentClass != Object.class && currentClass != null; currentClass = currentClass.getSuperclass()) {
            try {
                Method method = currentClass.getDeclaredMethod(methodName, reflectionArguments);
                if (method.getReturnType() != Object.class) continue;
                return method;
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        return null;
    }

    public ClassMetaData(Class clazz) {
        this.setClassName(clazz.getName());
        this.setClazz(clazz);
        this.setShaHash(HashStringUtil.hashName(clazz.getName()));
        this.setProxy(Proxy.isProxyClass(clazz));
        this.lookupInternalMethods(clazz);
        try {
            this.setConstructor(ClassMetaData.findConstructor(clazz));
        }
        catch (NoSuchMethodException e) {
            this.setConstructor(null);
        }
        this.setExternalizable(Externalizable.class.isAssignableFrom(clazz));
        this.setSerializable(Serializable.class.isAssignableFrom(clazz));
        this.setImmutable(Immutable.class.isAssignableFrom(clazz));
        this.exploreSlots(clazz);
    }

    public ClassMetaDataSlot[] getSlots() {
        return this.slots;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    private void calculateDepthAndName(Class clazz) {
        this.arrayDepth = 0;
        while (clazz.isArray()) {
            ++this.arrayDepth;
            clazz = clazz.getComponentType();
        }
        this.clazz = new WeakReference<Class>(clazz);
    }

    public Class getClazz() {
        if (this.clazz == null) {
            return null;
        }
        return (Class)this.clazz.get();
    }

    public Class getArrayRepresentation() {
        if (this.arrayRep == null) {
            return null;
        }
        return (Class)this.arrayRep.get();
    }

    private void constructArrayRepresentationClass(Class clazz) {
        this.arrayRep = new WeakReference<Class>(clazz);
    }

    public void setClazz(Class clazz) {
        if (clazz == null) {
            this.clazz = null;
        } else {
            this.clazz = new WeakReference<Class>(clazz);
            if (clazz.isArray()) {
                this.setArray(true);
                this.calculateDepthAndName(clazz);
                this.constructArrayRepresentationClass(clazz);
            }
        }
    }

    public Constructor getConstructor() {
        return (Constructor)this.constructor.get();
    }

    public void setConstructor(Constructor constructor) {
        if (constructor != null) {
            constructor.setAccessible(true);
        }
        this.constructor = new GhostConstructorPersistentReference(this.getClazz(), constructor);
    }

    public boolean isExternalizable() {
        return this.isExternalizable;
    }

    public void setExternalizable(boolean isExternalizable) {
        this.isExternalizable = isExternalizable;
    }

    public boolean isSerializable() {
        return this.isSerializable;
    }

    public void setSerializable(boolean isSerializable) {
        this.isSerializable = isSerializable;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public void setImmutable(boolean isImmutable) {
        this.isImmutable = isImmutable;
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public boolean equals(Object obj) {
        return this.className.equals(((ClassMetaData)obj).className);
    }

    public boolean isArray() {
        return this.isArray;
    }

    public void setArray(boolean isArray) {
        this.isArray = isArray;
    }

    public int getArrayDepth() {
        return this.arrayDepth;
    }

    public Object newInstance() throws IOException {
        Constructor localConstructor = this.getConstructor();
        try {
            if (localConstructor == null) {
                return this.getClazz().newInstance();
            }
            return localConstructor.newInstance(EMPTY_OBJECT_ARRAY);
        }
        catch (InstantiationException e) {
            throw new SerializationException("Could not create instance of " + this.className + " - " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException("Could not create instance of " + this.className + " - " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException("Could not create instance of " + this.className + " - " + e.getMessage(), e);
        }
    }

    public Method getReadResolveMethod() {
        return (Method)this.readResolveMethod.get();
    }

    public void setReadResolveMethod(Method readResolveMethod) {
        this.readResolveMethod = new MethodPersistentReference(readResolveMethod, 2);
    }

    public boolean isProxy() {
        return this.isProxy;
    }

    public void setProxy(boolean proxy) {
        this.isProxy = proxy;
    }

    public Method getWriteReplaceMethod() {
        return (Method)this.writeReplaceMethod.get();
    }

    public void setWriteReplaceMethod(Method writeReplaceMethod) {
        this.writeReplaceMethod = new MethodPersistentReference(writeReplaceMethod, 2);
    }

    public long getShaHash() {
        return this.shaHash;
    }

    public void setShaHash(long shaHash) {
        this.shaHash = shaHash;
    }

    private static Constructor findConstructor(Class clazz) throws NoSuchMethodException {
        if (clazz.isInterface()) {
            return null;
        }
        for (int i = 0; i < constructorManagers.length; ++i) {
            if (!constructorManagers[i].isSupported()) continue;
            return constructorManagers[i].getConstructor(clazz);
        }
        throw new NoSuchMethodException("Constructor not found as having difficulties in reflection");
    }

    private void exploreSlots(Class clazz) {
        ArrayList<ClassMetaDataSlot> slots = new ArrayList<ClassMetaDataSlot>();
        if (!this.isExternalizable() && !this.isArray && this.isSerializable()) {
            for (Class classIteration = clazz; classIteration != null && Serializable.class.isAssignableFrom(classIteration); classIteration = classIteration.getSuperclass()) {
                ClassMetaDataSlot slot = new ClassMetaDataSlot(classIteration);
                slots.add(slot);
            }
        } else {
            ClassMetaDataSlot slot = new ClassMetaDataSlot(clazz);
            slots.add(slot);
        }
        Collections.reverse(slots);
        this.slots = slots.toArray(new ClassMetaDataSlot[slots.size()]);
    }

    private void lookupInternalMethods(Class clazz) {
        if (clazz.isInterface()) {
            return;
        }
        Method method = this.lookupMethodOnHierarchy(clazz, "readResolve", EMPTY_CLASS_ARRY);
        if (method != null) {
            method.setAccessible(true);
            this.setReadResolveMethod(method);
        }
        if ((method = this.lookupMethodOnHierarchy(clazz, "writeReplace", EMPTY_CLASS_ARRY)) != null) {
            method.setAccessible(true);
            this.setWriteReplaceMethod(method);
        }
    }

    static class GhostConstructorPersistentReference
    extends PersistentReference {
        GhostConstructorPersistentReference(Class clazz, Constructor constructor) {
            super(clazz, constructor, 2);
        }

        @Override
        public synchronized Object rebuildReference() throws Exception {
            Object returnValue = this.internalGet();
            if (returnValue != null) {
                return returnValue;
            }
            Constructor constructorUsed = ClassMetaData.findConstructor(this.getMappedClass());
            this.buildReference(constructorUsed);
            return constructorUsed;
        }

        public Constructor getConstructor() {
            return (Constructor)this.get();
        }
    }
}

