/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer.jboss.serial.finalcontainers;

import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.FinalContainer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;

public class DoubleContainer
extends FinalContainer {
    double value;

    public DoubleContainer(double value) {
        this.value = value;
    }

    public DoubleContainer() {
    }

    public double getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleContainer that = (DoubleContainer)o;
        return Double.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        return (int)(temp ^ temp >>> 32);
    }

    public void writeMyself(DataOutput output) throws IOException {
        output.writeDouble(this.value);
    }

    public void readMyself(DataInput input) throws IOException {
        this.value = input.readDouble();
    }

    @Override
    public void setPrimitive(Object obj, Field field) throws IllegalAccessException {
        field.setDouble(obj, this.value);
    }
}

