/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer.jboss.serial.finalcontainers;

import com.ovea.jetty.session.serializer.jboss.serial.finalcontainers.FinalContainer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;

public class FloatContainer
extends FinalContainer {
    float value;

    public FloatContainer(float value) {
        this.value = value;
    }

    public FloatContainer() {
    }

    public float getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatContainer that = (FloatContainer)o;
        return Float.compare(that.value, this.value) == 0;
    }

    public int hashCode() {
        return this.value != 0.0f ? Float.floatToIntBits(this.value) : 0;
    }

    public void writeMyself(DataOutput output) throws IOException {
        output.writeFloat(this.value);
    }

    public void readMyself(DataInput input) throws IOException {
        this.value = input.readFloat();
    }

    @Override
    public void setPrimitive(Object obj, Field field) throws IllegalAccessException {
        field.setFloat(obj, this.value);
    }
}

