/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer.jboss.serial.io;

import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassDescriptorStrategy;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.DefaultClassDescriptorStrategy;
import com.ovea.jetty.session.serializer.jboss.serial.exception.SerializationException;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.DataContainer;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.DataContainerConstants;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.DefaultObjectDescriptorStrategy;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectDescriptorStrategy;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.safecloning.SafeCloningRepository;
import com.ovea.jetty.session.serializer.jboss.serial.util.StringUtil;
import com.ovea.jetty.session.serializer.jboss.serial.util.StringUtilBuffer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.lang.reflect.Field;

public class JBossObjectOutputStream
extends ObjectOutputStream
implements DataContainerConstants {
    OutputStream output;
    DataOutputStream dataOutput;
    boolean checkSerializableClass = false;
    boolean standardReplacement = false;
    ClassDescriptorStrategy classDescriptorStrategy = new DefaultClassDescriptorStrategy();
    ObjectDescriptorStrategy objectDescriptorStrategy = new DefaultObjectDescriptorStrategy();
    static Field fieldEnableReplace;
    StringUtilBuffer buffer;

    protected ObjectSubstitutionInterface getSubstitutionInterface() throws IOException {
        try {
            if (fieldEnableReplace.getBoolean(this)) {
                return new ObjectSubstitutionInterface(){

                    @Override
                    public Object replaceObject(Object obj) throws IOException {
                        return JBossObjectOutputStream.this.replaceObject(obj);
                    }
                };
            }
            return null;
        }
        catch (IllegalAccessException ex) {
            throw new SerializationException(ex.getMessage(), ex);
        }
    }

    public JBossObjectOutputStream(OutputStream output) throws IOException {
        this(output, false);
    }

    public JBossObjectOutputStream(OutputStream output, StringUtilBuffer buffer) throws IOException {
        this(output, false, buffer);
    }

    public JBossObjectOutputStream(OutputStream output, boolean checkSerializableClass) throws IOException {
        this(output, checkSerializableClass, null);
    }

    public JBossObjectOutputStream(OutputStream output, boolean checkSerializableClass, StringUtilBuffer buffer) throws IOException {
        this.buffer = buffer;
        this.output = output;
        this.checkSerializableClass = checkSerializableClass;
        this.writeStreamHeader();
        this.dataOutput = output instanceof DataOutputStream ? (DataOutputStream)output : new DataOutputStream(output);
    }

    public void writeObjectUsingDataContainer(Object obj) throws IOException {
        DataContainer dataContainer = new DataContainer(null, this.getSubstitutionInterface(), this.checkSerializableClass, this.buffer, this.classDescriptorStrategy, this.objectDescriptorStrategy);
        this.dataOutput = this.output instanceof DataOutputStream ? (DataOutputStream)this.output : new DataOutputStream(this.output);
        ObjectOutput objectOutput = dataContainer.getOutput();
        objectOutput.writeObject(obj);
        dataContainer.saveData(this.dataOutput);
    }

    @Override
    protected void writeObjectOverride(Object obj) throws IOException {
        DataContainer dataContainer = new DataContainer(null, this.getSubstitutionInterface(), this.checkSerializableClass, this.buffer, this.classDescriptorStrategy, this.objectDescriptorStrategy);
        this.dataOutput = this.output instanceof DataOutputStream ? (DataOutputStream)this.output : new DataOutputStream(this.output);
        dataContainer.setStringBuffer(this.buffer);
        ObjectOutput objectOutput = dataContainer.getDirectOutput(this.dataOutput);
        objectOutput.writeObject(obj);
    }

    @Override
    public void writeUnshared(Object obj) throws IOException {
        this.writeObjectOverride(obj);
    }

    @Override
    public void defaultWriteObject() throws IOException {
    }

    @Override
    public void writeFields() throws IOException {
    }

    @Override
    public void reset() throws IOException {
    }

    @Override
    protected void writeStreamHeader() throws IOException {
        if (this.output != null) {
            this.output.write(openSign);
        }
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
    }

    protected ClassDescriptorStrategy getClassDescriptorStrategy() {
        return this.classDescriptorStrategy;
    }

    protected void setClassDescriptorStrategy(ClassDescriptorStrategy classDescriptorStrategy) {
        this.classDescriptorStrategy = classDescriptorStrategy;
    }

    protected ObjectDescriptorStrategy getObjectDescriptorStrategy() {
        return this.objectDescriptorStrategy;
    }

    protected void setObjectDescriptorStrategy(ObjectDescriptorStrategy objectDescriptorStrategy) {
        this.objectDescriptorStrategy = objectDescriptorStrategy;
    }

    protected boolean isStandardReplacement() {
        return this.standardReplacement;
    }

    protected void setStandardReplacement(boolean standardReplacement) {
        this.standardReplacement = standardReplacement;
    }

    @Override
    public void write(int val) throws IOException {
        this.dataOutput.write(val);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.dataOutput.write(buf);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new SerializationException("buf parameter can't be null");
        }
        this.dataOutput.write(buf, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (this.dataOutput != null) {
            this.dataOutput.flush();
        } else {
            this.output.flush();
        }
    }

    @Override
    protected void drain() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.dataOutput.close();
    }

    @Override
    public void writeBoolean(boolean val) throws IOException {
        this.dataOutput.writeBoolean(val);
    }

    @Override
    public void writeByte(int val) throws IOException {
        this.dataOutput.writeByte(val);
    }

    @Override
    public void writeShort(int val) throws IOException {
        this.dataOutput.writeShort(val);
    }

    @Override
    public void writeChar(int val) throws IOException {
        this.dataOutput.writeChar(val);
    }

    @Override
    public void writeInt(int val) throws IOException {
        this.dataOutput.writeInt(val);
    }

    @Override
    public void writeLong(long val) throws IOException {
        this.dataOutput.writeLong(val);
    }

    @Override
    public void writeFloat(float val) throws IOException {
        this.dataOutput.writeFloat(val);
    }

    @Override
    public void writeDouble(double val) throws IOException {
        this.dataOutput.writeDouble(val);
    }

    @Override
    public void writeBytes(String str) throws IOException {
        this.dataOutput.writeBytes(str);
    }

    @Override
    public void writeChars(String str) throws IOException {
        this.dataOutput.writeChars(str);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        StringUtil.saveString(this.dataOutput, str, this.buffer);
    }

    public Object smartClone(Object obj) throws IOException {
        return this.smartClone(obj, null, Thread.currentThread().getContextClassLoader());
    }

    public Object smartClone(Object obj, SafeCloningRepository safeToReuse) throws IOException {
        return this.smartClone(obj, safeToReuse, Thread.currentThread().getContextClassLoader());
    }

    public Object smartClone(Object obj, SafeCloningRepository safeToReuse, ClassLoader loader) throws IOException {
        DataContainer container = new DataContainer(loader, this.getSubstitutionInterface(), safeToReuse, this.checkSerializableClass, this.buffer);
        ObjectOutput output = container.getOutput();
        output.writeObject(obj);
        output.flush();
        ObjectInput input = container.getInput();
        try {
            return input.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e.getMessage(), e);
        }
    }

    static {
        try {
            fieldEnableReplace = ObjectOutputStream.class.getDeclaredField("enableReplace");
            fieldEnableReplace.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

