/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel;

import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassMetaData;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassMetamodelFactory;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.StreamingClass;
import com.ovea.jetty.session.serializer.jboss.serial.exception.SerializationException;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectDescriptorStrategy;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectsCache;
import com.ovea.jetty.session.serializer.jboss.serial.persister.ClassReferencePersister;
import com.ovea.jetty.session.serializer.jboss.serial.persister.PersistResolver;
import com.ovea.jetty.session.serializer.jboss.serial.persister.Persister;
import com.ovea.jetty.session.serializer.jboss.serial.util.ClassMetaConsts;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class DefaultObjectDescriptorStrategy
implements ObjectDescriptorStrategy,
ClassMetaConsts {
    @Override
    public boolean writeObjectSpecialCase(ObjectsCache.JBossSeralizationOutputInterface output, ObjectsCache cache, Object obj) throws IOException {
        if (obj == null) {
            output.writeByte(99);
            return true;
        }
        if (obj != null && ClassMetamodelFactory.isImmutable(obj.getClass())) {
            output.saveImmutable(cache, obj);
            return true;
        }
        return false;
    }

    @Override
    public boolean writeDuplicateObject(ObjectsCache.JBossSeralizationOutputInterface output, ObjectsCache cache, Object obj, ClassMetaData metaData) throws IOException {
        int description = cache.findIdInCacheWrite(obj, metaData.isImmutable());
        if (description != 0) {
            output.writeByte(3);
            cache.getOutput().addObjectReference(description);
            return true;
        }
        return false;
    }

    @Override
    public Object replaceObjectByClass(ObjectsCache cache, Object obj, ClassMetaData metaData) throws IOException {
        if (obj instanceof Class) {
            return obj;
        }
        if (metaData.getWriteReplaceMethod() != null) {
            try {
                return metaData.getWriteReplaceMethod().invoke(obj, EMPTY_OBJECT_ARRAY);
            }
            catch (Exception e) {
                IOException io = new IOException("Metadata Serialization Error");
                io.initCause(e);
                throw io;
            }
        }
        return obj;
    }

    @Override
    public Object replaceObjectByStream(ObjectsCache cache, Object obj, ClassMetaData metaData) throws IOException {
        if (cache.getSubstitution() != null) {
            return cache.getSubstitution().replaceObject(obj);
        }
        return obj;
    }

    @Override
    public boolean doneReplacing(ObjectsCache cache, Object newObject, Object oldObject, ClassMetaData oldMetaData) throws IOException {
        return newObject == null || newObject == oldObject || newObject.getClass() == oldMetaData.getClazz();
    }

    @Override
    public void writeObject(ObjectsCache.JBossSeralizationOutputInterface output, ObjectsCache cache, ClassMetaData metadata, Object obj) throws IOException {
        Persister persister = PersistResolver.resolvePersister(obj, metadata);
        output.writeByte(persister.getId());
        persister.writeData(metadata, cache.getOutput(), obj, cache.getSubstitution());
    }

    @Override
    public Object readObjectSpecialCase(ObjectsCache.JBossSeralizationInputInterface input, ObjectsCache cache, byte byteIdentify) throws IOException {
        return input.readImmutable(byteIdentify, cache);
    }

    @Override
    public Object readObject(ObjectsCache.JBossSeralizationInputInterface input, ObjectsCache cache, StreamingClass streamingClass, int reference) throws IOException {
        ClassMetaData metaData = streamingClass.getMetadata();
        byte persisterId = input.readByte();
        Persister persister = PersistResolver.resolvePersister(persisterId);
        Object value = persister.readData(cache.getLoader(), streamingClass, metaData, reference, cache, cache.getInput(), cache.getSubstitution());
        if (!(persister instanceof ClassReferencePersister)) {
            if (cache.getSubstitution() != null) {
                value = cache.getSubstitution().replaceObject(value);
            }
            try {
                if (metaData.getReadResolveMethod() != null) {
                    value = metaData.getReadResolveMethod().invoke(value, new Object[0]);
                    cache.reassignObjectInCacheRead(reference, value);
                }
            }
            catch (IllegalAccessException e) {
                throw new SerializationException(e);
            }
            catch (InvocationTargetException e) {
                throw new SerializationException(e);
            }
        }
        return value;
    }
}

