/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel;

import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassMetaData;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassMetamodelFactory;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.StreamingClass;
import com.ovea.jetty.session.serializer.jboss.serial.exception.SerializationException;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectDescriptorStrategy;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectsCache;
import com.ovea.jetty.session.serializer.jboss.serial.util.ClassMetaConsts;
import java.io.IOException;

public class ObjectDescriptorFactory
implements ClassMetaConsts {
    static Object objectFromDescription(ObjectsCache cache, ObjectsCache.JBossSeralizationInputInterface input) throws IOException {
        if (cache.getSubstitution() != null) {
            return cache.getSubstitution().replaceObject(ObjectDescriptorFactory.objectFromDescriptionInternal(cache, input));
        }
        return ObjectDescriptorFactory.objectFromDescriptionInternal(cache, input);
    }

    private static Object objectFromDescriptionInternal(ObjectsCache cache, ObjectsCache.JBossSeralizationInputInterface input) throws IOException {
        Object description = null;
        byte byteIdentify = cache.getInput().readByte();
        if (byteIdentify == 60) {
            cache.reset();
            return ObjectDescriptorFactory.objectFromDescription(cache, input);
        }
        if (byteIdentify == 99) {
            return null;
        }
        if (byteIdentify == 51) {
            return ObjectDescriptorFactory.readObjectDescriptionFromStreaming(cache, input);
        }
        if (byteIdentify == 50) {
            int reference = input.readObjectReference();
            if (cache.getSafeToReuse() == null) {
                throw new IOException("SafeClone repository mismatch");
            }
            description = cache.getSafeToReuse().findReference(reference);
            if (description == null) {
                throw new IOException("SafeClone repository mismatch - didn't find reference " + reference);
            }
            return description;
        }
        if (byteIdentify == 3) {
            int reference = input.readObjectReference();
            if (description == null) {
                description = cache.findObjectInCacheRead(reference);
            }
            if (description == null) {
                throw new SerializationException("Object reference " + reference + " was not found");
            }
            return description;
        }
        return cache.getObjectDescriptorStrategy().readObjectSpecialCase(input, cache, byteIdentify);
    }

    static void describeObject(ObjectsCache cache, Object obj) throws IOException {
        ObjectsCache.JBossSeralizationOutputInterface outputParent = cache.getOutput();
        ObjectDescriptorStrategy objectDescriptorStrategy = cache.getObjectDescriptorStrategy();
        if (objectDescriptorStrategy.writeObjectSpecialCase(outputParent, cache, obj)) {
            return;
        }
        ClassMetaData metaData = ObjectDescriptorFactory.getMetaData(obj, cache);
        if (objectDescriptorStrategy.writeDuplicateObject(outputParent, cache, obj, metaData)) {
            return;
        }
        Object originalObject = obj;
        Object newObject = obj;
        do {
            if (!objectDescriptorStrategy.writeObjectSpecialCase(outputParent, cache, newObject = objectDescriptorStrategy.replaceObjectByClass(cache, obj = newObject, metaData = ObjectDescriptorFactory.getMetaData(obj, cache)))) continue;
            return;
        } while (!objectDescriptorStrategy.doneReplacing(cache, newObject, obj, metaData));
        obj = newObject;
        metaData = ObjectDescriptorFactory.getMetaData(obj, cache);
        if (cache.getSubstitution() != null) {
            Object orig = obj;
            obj = cache.getSubstitution().replaceObject(obj);
            if (obj != orig) {
                if (objectDescriptorStrategy.writeObjectSpecialCase(outputParent, cache, obj)) {
                    return;
                }
                metaData = ObjectDescriptorFactory.getMetaData(obj, cache);
            }
        }
        int description = 0;
        if (cache.getSafeToReuse() != null && (description = cache.getSafeToReuse().storeSafe(obj)) != 0) {
            outputParent.writeByte(50);
            cache.getOutput().addObjectReference(description);
            return;
        }
        description = cache.findIdInCacheWrite(obj, metaData.isImmutable());
        if (description != 0) {
            outputParent.writeByte(3);
            cache.getOutput().addObjectReference(description);
            return;
        }
        ClassMetaData originalMetaData = metaData;
        if (obj != originalObject) {
            originalMetaData = ObjectDescriptorFactory.getMetaData(originalObject, cache);
        }
        description = cache.putObjectInCacheWrite(originalObject, originalMetaData.isImmutable());
        outputParent.writeByte(51);
        cache.getOutput().addObjectReference(description);
        cache.getClassDescriptorStrategy().writeClassDescription(obj, metaData, cache, description);
        cache.getObjectDescriptorStrategy().writeObject(outputParent, cache, metaData, obj);
    }

    private static Object readObjectDescriptionFromStreaming(ObjectsCache cache, ObjectsCache.JBossSeralizationInputInterface input) throws IOException {
        int reference = input.readObjectReference();
        StreamingClass streamingClass = cache.getClassDescriptorStrategy().readClassDescription(cache, input, cache.getClassResolver(), null);
        return cache.getObjectDescriptorStrategy().readObject(input, cache, streamingClass, reference);
    }

    private static ClassMetaData getMetaData(Object obj, ObjectsCache cache) throws IOException {
        if (obj instanceof Class) {
            return ClassMetamodelFactory.getClassMetaData((Class)obj, false);
        }
        return ClassMetamodelFactory.getClassMetaData(obj.getClass(), cache.isCheckSerializableClass());
    }
}

