/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer.jboss.serial.persister;

import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.ClassMetaData;
import com.ovea.jetty.session.serializer.jboss.serial.classmetamodel.StreamingClass;
import com.ovea.jetty.session.serializer.jboss.serial.exception.SerializationException;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectSubstitutionInterface;
import com.ovea.jetty.session.serializer.jboss.serial.objectmetamodel.ObjectsCache;
import com.ovea.jetty.session.serializer.jboss.serial.persister.Persister;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;

public class ProxyPersister
implements Persister {
    private byte id;

    @Override
    public byte getId() {
        return this.id;
    }

    @Override
    public void setId(byte id) {
        this.id = id;
    }

    @Override
    public void writeData(ClassMetaData metaData, ObjectOutput output, Object obj, ObjectSubstitutionInterface substitution) throws IOException {
        InvocationHandler handler = Proxy.getInvocationHandler(obj);
        output.writeObject(handler);
        output.writeObject(obj.getClass());
    }

    @Override
    public Object readData(ClassLoader loader, StreamingClass streaming, ClassMetaData metaData, int referenceId, ObjectsCache cache, ObjectInput input, ObjectSubstitutionInterface substitution) throws IOException {
        try {
            Object handler = input.readObject();
            Class proxy = (Class)input.readObject();
            Constructor constructor = proxy.getConstructor(InvocationHandler.class);
            Object obj = constructor.newInstance(handler);
            cache.putObjectInCacheRead(referenceId, obj);
            return obj;
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new SerializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new SerializationException(e);
        }
        catch (InstantiationException e) {
            throw new SerializationException(e);
        }
        catch (InvocationTargetException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public boolean canPersist(Object obj) {
        return false;
    }
}

