/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.jetty.session.serializer.jboss.serial.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class PartitionedWeakHashMap
extends AbstractMap {
    boolean issynchronized;
    Map[] partitionMaps;
    private static final int PARTITION_SIZE = 10;

    public PartitionedWeakHashMap() {
        this(false);
    }

    public PartitionedWeakHashMap(boolean issynchronized) {
        this.issynchronized = issynchronized;
        this.partitionMaps = new Map[10];
        for (int i = 0; i < 10; ++i) {
            this.partitionMaps[i] = issynchronized ? Collections.synchronizedMap(new WeakHashMap()) : new WeakHashMap();
        }
    }

    public Map getMap(Object obj) {
        int hash = obj.hashCode();
        if (hash < 0) {
            hash *= -1;
        }
        return this.partitionMaps[hash %= 10];
    }

    @Override
    public Set entrySet() {
        throw new RuntimeException("method not supported");
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.partitionMaps.length; ++i) {
            this.partitionMaps[i].clear();
        }
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        throw new RuntimeException("Clone not supported");
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getMap(key).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("method not supported");
    }

    @Override
    public boolean equals(Object o) {
        throw new RuntimeException("method not supported");
    }

    @Override
    public Object get(Object key) {
        return this.getMap(key).get(key);
    }

    @Override
    public boolean isEmpty() {
        throw new RuntimeException("method not supported");
    }

    @Override
    public Set keySet() {
        HashSet hashSet = new HashSet();
        for (int i = 0; i < 10; ++i) {
            hashSet.addAll(this.partitionMaps[i].keySet());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object put(Object key, Object value) {
        if (!this.issynchronized) {
            Map map;
            Map map2 = map = this.getMap(key);
            synchronized (map2) {
                return map.put(key, value);
            }
        }
        return this.getMap(key).put(key, value);
    }

    @Override
    public void putAll(Map elementsToAdd) {
        for (Map.Entry entry : elementsToAdd.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        return this.getMap(key).remove(key);
    }

    @Override
    public int size() {
        int size = 0;
        for (int i = 0; i < 10; ++i) {
            size += this.partitionMaps[i].size();
        }
        return size;
    }

    @Override
    public Collection values() {
        ArrayList values = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            values.addAll(this.partitionMaps[i].values());
        }
        return values;
    }
}

