/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.pipe;

import com.ovea.system.pipe.BrokenPipeException;
import com.ovea.system.pipe.Pipe;
import com.ovea.system.pipe.PipeListener;
import java.util.concurrent.atomic.AtomicReference;

final class OncePipeListener
implements PipeListener {
    private final AtomicReference<PipeListener> listener;

    public OncePipeListener(PipeListener listener) {
        this.listener = new AtomicReference<PipeListener>(listener);
    }

    @Override
    public void onConnect(Pipe pipe) {
        PipeListener t = this.listener.get();
        if (t != null) {
            t.onConnect(pipe);
        }
    }

    @Override
    public void onClose(Pipe pipe) {
        PipeListener tl = this.listener.getAndSet(null);
        if (tl != null) {
            tl.onClose(pipe);
        }
    }

    @Override
    public void onBroken(Pipe pipe, BrokenPipeException e) {
        PipeListener tl = this.listener.getAndSet(null);
        if (tl != null) {
            tl.onBroken(pipe, e);
        }
    }

    @Override
    public void onInterrupt(Pipe pipe) {
        PipeListener tl = this.listener.getAndSet(null);
        if (tl != null) {
            tl.onInterrupt(pipe);
        }
    }
}

