/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.pipe;

import com.ovea.system.pipe.BrokenPipeException;
import com.ovea.system.pipe.PipeSkeleton;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

final class PipeByteChannel
extends PipeSkeleton<ReadableByteChannel, WritableByteChannel> {
    private final int bufferSize;

    public PipeByteChannel(ReadableByteChannel from, WritableByteChannel to) {
        super(from, to);
        this.bufferSize = 65536;
    }

    public PipeByteChannel(String name, ReadableByteChannel from, WritableByteChannel to, int bufferSize) {
        super(name, from, to);
        this.bufferSize = bufferSize;
    }

    @Override
    protected void copy(ReadableByteChannel from, WritableByteChannel to) throws IOException, BrokenPipeException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.bufferSize);
        while (from.read(buffer) != -1) {
            buffer.flip();
            to.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            to.write(buffer);
        }
    }
}

