/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.pipe;

import com.ovea.system.pipe.BrokenPipeException;
import com.ovea.system.pipe.PipeSkeleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

final class PipeByteStream
extends PipeSkeleton<InputStream, OutputStream> {
    private final int bufferSize;

    public PipeByteStream(InputStream from, OutputStream to) {
        super(from, to);
        this.bufferSize = 8192;
    }

    public PipeByteStream(String name, InputStream from, OutputStream to, int bufferSize) {
        super(name, from, to);
        this.bufferSize = bufferSize;
    }

    @Override
    protected void copy(InputStream from, OutputStream to) throws IOException, BrokenPipeException {
        int len;
        byte[] buffer = new byte[this.bufferSize];
        while (this.canCopy() && (len = from.read(buffer)) != -1) {
            to.write(buffer, 0, len);
        }
    }
}

