/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.pipe;

import com.ovea.system.pipe.BrokenPipeException;
import com.ovea.system.pipe.PipeSkeleton;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

final class PipeCharacterStream
extends PipeSkeleton<Reader, Writer> {
    private final int bufferSize;

    public PipeCharacterStream(Reader from, Writer to) {
        super(from, to);
        this.bufferSize = 8192;
    }

    public PipeCharacterStream(String name, Reader from, Writer to, int bufferSize) {
        super(name, from, to);
        this.bufferSize = bufferSize;
    }

    @Override
    protected void copy(Reader from, Writer to) throws IOException, BrokenPipeException {
        int len;
        char[] buffer = new char[this.bufferSize];
        while (this.canCopy() && (len = from.read(buffer)) != -1) {
            to.write(buffer, 0, len);
        }
    }
}

