/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.pipe;

import com.ovea.system.pipe.BrokenPipeException;
import com.ovea.system.pipe.Pipe;
import com.ovea.system.pipe.PipeListener;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class PipeListeners
implements PipeListener {
    private final List<PipeListener> listeners = new CopyOnWriteArrayList<PipeListener>();

    public PipeListeners(PipeListener ... listeners) {
        this(Arrays.asList(listeners));
    }

    public PipeListeners(Iterable<? extends PipeListener> listeners) {
        this.add(listeners);
    }

    public void add(PipeListener listener) {
        this.listeners.add(listener);
    }

    public void add(PipeListener ... listeners) {
        this.add(Arrays.asList(listeners));
    }

    public void add(Iterable<? extends PipeListener> listeners) {
        for (PipeListener pipeListener : listeners) {
            this.listeners.add(pipeListener);
        }
    }

    @Override
    public void onClose(Pipe pipe) {
        for (PipeListener listener : this.listeners) {
            listener.onClose(pipe);
        }
    }

    @Override
    public void onConnect(Pipe pipe) {
        for (PipeListener listener : this.listeners) {
            listener.onConnect(pipe);
        }
    }

    @Override
    public void onBroken(Pipe pipe, BrokenPipeException e) {
        for (PipeListener listener : this.listeners) {
            listener.onBroken(pipe, e);
        }
    }

    @Override
    public void onInterrupt(Pipe pipe) {
        for (PipeListener listener : this.listeners) {
            listener.onInterrupt(pipe);
        }
    }
}

