/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.pipe;

import com.ovea.system.pipe.BrokenPipeException;
import com.ovea.system.pipe.OncePipeListener;
import com.ovea.system.pipe.Pipe;
import com.ovea.system.pipe.PipeConnection;
import com.ovea.system.pipe.PipeListener;
import com.ovea.system.pipe.PipeListenerAdapter;
import com.ovea.system.util.IoUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

abstract class PipeSkeleton<IN extends Closeable, OUT extends Closeable>
implements Pipe {
    private static final PipeListener EMPTY = new PipeListenerAdapter();
    private final AtomicReference<State> state = new AtomicReference<State>(State.READY);
    private final String name;
    private PipeConnection connection;
    private PipeListener listener;
    private IN from;
    private OUT to;

    protected PipeSkeleton(String name, IN from, OUT to) {
        if (from == null) {
            throw new IllegalArgumentException("Missing origin endpoint");
        }
        if (to == null) {
            throw new IllegalArgumentException("Missing destination endpoint");
        }
        if (name == null) {
            throw new IllegalArgumentException("Missing pipe name");
        }
        this.from = from;
        this.to = to;
        this.name = name;
    }

    protected PipeSkeleton(IN from, OUT to) {
        this("pipe-" + UUID.randomUUID().toString(), from, to);
    }

    @Override
    public final String name() {
        return this.name;
    }

    public final String toString() {
        return this.name;
    }

    @Override
    public final Pipe listenedBy(PipeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        this.listener = new OncePipeListener(listener);
        return this;
    }

    @Override
    public final PipeConnection connect() {
        if (this.state.compareAndSet(State.READY, State.OPENED)) {
            this.connection = new Connection(this);
        }
        return this.connection;
    }

    @Override
    public final boolean isReady() {
        return this.state.get() == State.READY;
    }

    @Override
    public final boolean isOpened() {
        return this.state.get() == State.OPENED;
    }

    @Override
    public final boolean isClosed() {
        return this.state.get() == State.CLOSED;
    }

    @Override
    public final boolean isBroken() {
        return this.state.get() == State.BROKEN;
    }

    @Override
    public final boolean isInterrupted() {
        return this.state.get() == State.INTERRUPTED;
    }

    protected final boolean canCopy() {
        return !Thread.interrupted() && this.isOpened();
    }

    protected abstract void copy(IN var1, OUT var2) throws IOException, BrokenPipeException;

    private PipeListener listener() {
        PipeListener l = this.listener;
        return l == null ? EMPTY : l;
    }

    private static final class Connection<IN extends Closeable, OUT extends Closeable>
    implements PipeConnection {
        private final PipeSkeleton<IN, OUT> pipe;
        private final FutureTask<Object> task;
        private Thread copier;

        private Connection(final PipeSkeleton<IN, OUT> pipe) {
            this.pipe = pipe;
            this.task = new FutureTask<Object>((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    pipe.listener().onConnect(pipe);
                    try {
                        pipe.copy(pipe.from, pipe.to);
                    }
                    catch (InterruptedIOException e) {
                        Connection.this.closeStreams(State.INTERRUPTED, new BrokenPipeException[0]);
                        throw new InterruptedException(e.getMessage());
                    }
                    catch (BrokenPipeException e) {
                        Connection.this.closeStreams(State.BROKEN, new BrokenPipeException[]{e});
                        throw e;
                    }
                    catch (IOException e) {
                        BrokenPipeException bpe = new BrokenPipeException(e);
                        Connection.this.closeStreams(State.BROKEN, new BrokenPipeException[]{bpe});
                        throw bpe;
                    }
                    return Boolean.TRUE;
                }
            }){

                @Override
                protected void done() {
                    if (this.isCancelled()) {
                        Connection.this.closeStreams(State.INTERRUPTED, new BrokenPipeException[0]);
                    } else {
                        Connection.this.closeStreams(State.CLOSED, new BrokenPipeException[0]);
                    }
                }
            };
            this.copier = new Thread(this.task, ((PipeSkeleton)pipe).name);
            this.copier.start();
        }

        public final String toString() {
            return this.pipe.toString();
        }

        @Override
        public final Pipe pipe() {
            return this.pipe;
        }

        @Override
        public void interrupt() {
            this.closeStreams(State.INTERRUPTED, new BrokenPipeException[0]);
        }

        @Override
        public void await(long time, TimeUnit unit) throws InterruptedException, TimeoutException, BrokenPipeException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                this.task.get(time, unit);
                this.closeStreams(State.CLOSED, new BrokenPipeException[0]);
            }
            catch (ExecutionException e) {
                Throwable t = e;
                if (e.getCause() != null) {
                    t = e.getCause();
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof BrokenPipeException) {
                    throw (BrokenPipeException)t;
                }
                if (t instanceof InterruptedException) {
                    throw (InterruptedException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                RuntimeException re = new RuntimeException(t.getMessage(), e);
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.closeStreams(State.INTERRUPTED, new BrokenPipeException[0]);
                throw e;
            }
            catch (CancellationException e) {
                this.closeStreams(State.INTERRUPTED, new BrokenPipeException[0]);
                throw new InterruptedException();
            }
        }

        @Override
        public void await() throws InterruptedException, BrokenPipeException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                this.task.get();
                this.closeStreams(State.CLOSED, new BrokenPipeException[0]);
            }
            catch (ExecutionException e) {
                Throwable t = e;
                if (e.getCause() != null) {
                    t = e.getCause();
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof BrokenPipeException) {
                    throw (BrokenPipeException)t;
                }
                if (t instanceof InterruptedException) {
                    throw (InterruptedException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                RuntimeException re = new RuntimeException(t.getMessage(), e);
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.closeStreams(State.INTERRUPTED, new BrokenPipeException[0]);
                throw e;
            }
            catch (CancellationException e) {
                this.closeStreams(State.INTERRUPTED, new BrokenPipeException[0]);
                throw new InterruptedException();
            }
        }

        private void closeStreams(State end, BrokenPipeException ... e) {
            if (((PipeSkeleton)this.pipe).state.compareAndSet(State.OPENED, end) || ((PipeSkeleton)this.pipe).state.compareAndSet(State.READY, end)) {
                if (end == State.INTERRUPTED && this.copier != Thread.currentThread()) {
                    this.task.cancel(true);
                    this.copier.interrupt();
                }
                IoUtils.close(((PipeSkeleton)this.pipe).from, ((PipeSkeleton)this.pipe).to);
                ((PipeSkeleton)this.pipe).from = null;
                ((PipeSkeleton)this.pipe).to = null;
                if (this.copier != Thread.currentThread()) {
                    try {
                        this.copier.join();
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                }
                this.copier = null;
                switch (end) {
                    case INTERRUPTED: {
                        ((PipeSkeleton)this.pipe).listener().onInterrupt(this.pipe());
                        break;
                    }
                    case CLOSED: {
                        ((PipeSkeleton)this.pipe).listener().onClose(this.pipe());
                        break;
                    }
                    case BROKEN: {
                        ((PipeSkeleton)this.pipe).listener().onBroken(this.pipe(), e[0]);
                    }
                }
            }
        }
    }

    private static enum State {
        READY,
        OPENED,
        CLOSED,
        INTERRUPTED,
        BROKEN;

    }
}

