/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.pipe;

import com.ovea.system.pipe.Pipe;
import com.ovea.system.pipe.PipeByteChannel;
import com.ovea.system.pipe.PipeByteStream;
import com.ovea.system.pipe.PipeCharacterStream;
import com.ovea.system.pipe.PipeConnection;
import com.ovea.system.proc.ProcessPipe;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.LinkedList;

public final class Pipes {
    private Pipes() {
    }

    public static Pipe create(InputStream in, OutputStream out) {
        return new PipeByteStream(in, out);
    }

    public static Pipe create(String name, InputStream in, OutputStream out) {
        return Pipes.create(name, in, out, 8192);
    }

    public static Pipe create(String name, InputStream in, OutputStream out, int bufferSize) {
        return new PipeByteStream(name, in, out, bufferSize);
    }

    public static Pipe create(Reader in, Writer out) {
        return new PipeCharacterStream(in, out);
    }

    public static Pipe create(String name, Reader in, Writer out) {
        return Pipes.create(name, in, out, 8192);
    }

    public static Pipe create(String name, Reader in, Writer out, int bufferSize) {
        return new PipeCharacterStream(name, in, out, bufferSize);
    }

    public static Pipe create(ReadableByteChannel in, WritableByteChannel out) {
        return new PipeByteChannel(in, out);
    }

    public static Pipe create(String name, ReadableByteChannel in, WritableByteChannel out) {
        return Pipes.create(name, in, out, 65536);
    }

    public static Pipe create(String name, ReadableByteChannel in, WritableByteChannel out, int bufferSize) {
        return new PipeByteChannel(name, in, out, bufferSize);
    }

    public static PipeConnection connect(InputStream in, OutputStream out) {
        return Pipes.create(in, out).connect();
    }

    public static PipeConnection connect(String name, InputStream in, OutputStream out) {
        return Pipes.create(name, in, out).connect();
    }

    public static PipeConnection connect(String name, InputStream in, OutputStream out, int bufferSize) {
        return Pipes.create(name, in, out, bufferSize).connect();
    }

    public static PipeConnection connect(Reader in, Writer out) {
        return Pipes.create(in, out).connect();
    }

    public static PipeConnection connect(String name, Reader in, Writer out) {
        return Pipes.create(name, in, out).connect();
    }

    public static PipeConnection connect(String name, Reader in, Writer out, int bufferSize) {
        return Pipes.create(name, in, out, bufferSize).connect();
    }

    public static PipeConnection connect(ReadableByteChannel in, WritableByteChannel out) {
        return Pipes.create(in, out).connect();
    }

    public static PipeConnection connect(String name, ReadableByteChannel in, WritableByteChannel out) {
        return Pipes.create(name, in, out).connect();
    }

    public static PipeConnection connect(String name, ReadableByteChannel in, WritableByteChannel out, int bufferSize) {
        return Pipes.create(name, in, out, bufferSize).connect();
    }

    public static ProcessPipe pipe(Process first, Process next, Process ... others) {
        if (first == null) {
            throw new IllegalArgumentException("Missing first process");
        }
        if (next == null) {
            throw new IllegalArgumentException("Missing second process");
        }
        LinkedList<Process> processes = new LinkedList<Process>();
        processes.add(first);
        processes.add(next);
        if (others != null && others.length > 0) {
            processes.addAll(Arrays.asList(others));
        }
        return new ProcessPipe(processes);
    }
}

