/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.proc;

import com.ovea.system.proc.FutureProcessListener;
import com.ovea.system.proc.FutureProcessListenerAdapter;
import com.ovea.system.util.ProcUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class FutureProcess
implements Future<Integer> {
    private static final FutureProcessListener EMPTY = new FutureProcessListenerAdapter();
    private final Process process;
    private final Future<Integer> exitCode;

    public FutureProcess(Process process) {
        this(process, EMPTY);
    }

    public FutureProcess(final Process process, final FutureProcessListener listener) {
        FutureTask<Integer> task = new FutureTask<Integer>((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws InterruptedException {
                return process.waitFor();
            }
        }){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    this.get();
                    listener.onComplete(FutureProcess.this);
                }
                catch (InterruptedException e) {
                    listener.onInterrupted(FutureProcess.this);
                }
                catch (CancellationException e) {
                    listener.onInterrupted(FutureProcess.this);
                }
                catch (ExecutionException e) {
                    listener.onInterrupted(FutureProcess.this);
                }
                finally {
                    try {
                        process.destroy();
                    }
                    catch (Throwable ignored) {}
                }
            }
        };
        this.process = process;
        this.exitCode = task;
        new Thread(task).start();
    }

    public Process process() {
        return this.process;
    }

    public long pid() {
        return ProcUtils.pid(this.process());
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean e = this.exitCode.cancel(mayInterruptIfRunning);
        try {
            this.process().waitFor();
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
        return e;
    }

    @Override
    public boolean isCancelled() {
        return this.exitCode.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.exitCode.isDone();
    }

    @Override
    public Integer get() throws InterruptedException, ExecutionException {
        return this.exitCode.get();
    }

    @Override
    public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.exitCode.get(timeout, unit);
    }
}

