/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.proc;

import com.ovea.system.proc.FutureProcess;
import com.ovea.system.proc.FutureProcessListener;
import java.util.concurrent.atomic.AtomicReference;

public final class OnceFutureProcessListener
implements FutureProcessListener {
    private final AtomicReference<FutureProcessListener> listener;

    public OnceFutureProcessListener(FutureProcessListener listener) {
        this.listener = new AtomicReference<FutureProcessListener>(listener);
    }

    @Override
    public void onComplete(FutureProcess futureProcess) {
        FutureProcessListener listener = this.listener.getAndSet(null);
        if (listener != null) {
            listener.onComplete(futureProcess);
        }
    }

    @Override
    public void onInterrupted(FutureProcess futureProcess) {
        FutureProcessListener listener = this.listener.getAndSet(null);
        if (listener != null) {
            listener.onInterrupted(futureProcess);
        }
    }
}

