/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.proc;

import com.ovea.system.pipe.PipeConnection;
import com.ovea.system.pipe.Pipes;
import com.ovea.system.proc.FutureProcess;
import com.ovea.system.proc.FutureProcessListener;
import com.ovea.system.util.IoUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ProcessPipe
extends Process {
    private final InputStream inputStream;
    private final InputStream errorStream;
    private final OutputStream outputStream;
    private final CountDownLatch finished;
    private final SharedErrorStream sharedErrorStream = new SharedErrorStream();
    private final AtomicReference<Integer> exitValue = new AtomicReference();
    private final Queue<FutureProcess> processes = new LinkedList<FutureProcess>();
    private final Queue<PipeConnection> pipes = new LinkedList<PipeConnection>();

    public ProcessPipe(List<? extends Process> processes) {
        processes = new ArrayList<Process>(processes);
        if (processes.size() < 2) {
            throw new IllegalArgumentException("Requires at least two processes");
        }
        this.finished = new CountDownLatch(processes.size());
        for (int i = 0; i < processes.size(); ++i) {
            Process current = processes.get(i);
            final boolean isLast = i + 1 == processes.size();
            this.processes.add(new FutureProcess(current, new FutureProcessListener(){

                @Override
                public void onComplete(FutureProcess futureProcess) {
                    if (isLast) {
                        ProcessPipe.this.exitValue.compareAndSet(null, futureProcess.process().exitValue());
                    }
                    try {
                        ProcessPipe.this.sharedErrorStream.append(futureProcess.process().getErrorStream());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    this.onInterrupted(futureProcess);
                }

                @Override
                public void onInterrupted(FutureProcess futureProcess) {
                    if (isLast) {
                        IoUtils.close(ProcessPipe.this.sharedErrorStream);
                    }
                    ProcessPipe.this.finished.countDown();
                }
            }));
            if (i <= 0) continue;
            this.pipes.add(Pipes.connect(processes.get(i - 1).getInputStream(), current.getOutputStream()));
        }
        this.outputStream = processes.get(0).getOutputStream();
        this.inputStream = processes.get(processes.size() - 1).getInputStream();
        try {
            this.errorStream = new PipedInputStream(this.sharedErrorStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public InputStream getErrorStream() {
        return this.errorStream;
    }

    @Override
    public int waitFor() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            this.finished.await();
            return this.exitValue();
        }
        catch (InterruptedException e) {
            this.destroy();
            throw e;
        }
    }

    public int waitFor(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            if (this.finished.await(time, unit)) {
                return this.exitValue();
            }
            throw new TimeoutException();
        }
        catch (InterruptedException e) {
            this.destroy();
            throw e;
        }
    }

    @Override
    public int exitValue() throws IllegalThreadStateException {
        Integer i = this.exitValue.get();
        if (i == null) {
            throw new IllegalThreadStateException("Pipe as not completed");
        }
        return i;
    }

    @Override
    public void destroy() {
        while (!this.pipes.isEmpty()) {
            this.pipes.poll().interrupt();
        }
        for (FutureProcess process : this.processes) {
            process.cancel(true);
        }
        while (!this.processes.isEmpty()) {
            try {
                this.processes.poll().get();
            }
            catch (Throwable throwable) {}
        }
    }

    private static final class SharedErrorStream
    extends PipedOutputStream {
        private final Lock lock = new ReentrantLock();

        private SharedErrorStream() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        void append(InputStream stream) throws InterruptedException {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                int c;
                this.lock.lockInterruptibly();
                while ((c = stream.read()) != -1) {
                    this.write(c);
                }
                this.lock.unlock();
            }
            catch (IOException iOException) {
                this.lock.unlock();
                IoUtils.close(stream);
                catch (Throwable throwable) {
                    this.lock.unlock();
                    IoUtils.close(stream);
                    throw throwable;
                }
            }
            IoUtils.close(stream);
        }
    }
}

