/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.test;

import com.ovea.system.proc.FutureProcess;
import com.ovea.system.trace.Trace;
import com.ovea.system.util.Platform;
import com.ovea.system.util.ProcUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Main {
    public static void main(String ... args) throws Exception {
        if (args.length == 1 && args[0].equals("-trace")) {
            Trace.main(Main.class.getName());
        } else {
            boolean win = Platform.isWindows() || Platform.isWindowsCE();
            System.out.println(" - PID = " + ProcUtils.currentPID());
            System.out.println(" - Detected OS = " + (win ? "Windows" : "Unix-like"));
            FutureProcess process = Main.launch(win ? "tasklist.exe" : "ps");
            try {
                process.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                process.cancel(true);
            }
            if (!process.isCancelled()) {
                process.get();
            }
            process = Main.launch(win ? "cmd.exe" : "sh");
            try {
                process.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                ProcUtils.terminate(process.process());
            }
            process.get();
            process = Main.launch(win ? "cmd.exe" : "sh");
            try {
                process.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                ProcUtils.terminate(process.pid());
            }
            process.get();
        }
    }

    private static FutureProcess launch(String proc) throws Exception {
        System.out.println(" - Launching " + proc + "...");
        FutureProcess process = new FutureProcess(new ProcessBuilder(proc).start());
        Thread.sleep(1000L);
        System.out.println(" - Child PID = " + process.pid());
        return process;
    }
}

