/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.tunnel;

import com.ovea.system.tunnel.BrokenTunnelException;
import com.ovea.system.tunnel.Tunnel;
import com.ovea.system.tunnel.TunnelListener;
import java.util.concurrent.atomic.AtomicReference;

public final class OnceTunnelListener
implements TunnelListener {
    private final AtomicReference<TunnelListener> listener;

    public OnceTunnelListener(TunnelListener listener) {
        this.listener = new AtomicReference<TunnelListener>(listener);
    }

    @Override
    public void onConnect(Tunnel tunnel) {
        TunnelListener t = this.listener.get();
        if (t != null) {
            t.onConnect(tunnel);
        }
    }

    @Override
    public void onClose(Tunnel tunnel) {
        TunnelListener tl = this.listener.getAndSet(null);
        if (tl != null) {
            tl.onClose(tunnel);
        }
    }

    @Override
    public void onBroken(Tunnel tunnel, BrokenTunnelException e) {
        TunnelListener tl = this.listener.getAndSet(null);
        if (tl != null) {
            tl.onBroken(tunnel, e);
        }
    }

    @Override
    public void onInterrupt(Tunnel tunnel) {
        TunnelListener tl = this.listener.getAndSet(null);
        if (tl != null) {
            tl.onInterrupt(tunnel);
        }
    }
}

