/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.tunnel;

import com.ovea.system.pipe.BrokenPipeException;
import com.ovea.system.pipe.Pipe;
import com.ovea.system.pipe.PipeConnection;
import com.ovea.system.pipe.PipeListener;
import com.ovea.system.pipe.Pipes;
import com.ovea.system.tunnel.BrokenTunnelException;
import com.ovea.system.tunnel.OnceTunnelListener;
import com.ovea.system.tunnel.TunnelListener;
import com.ovea.system.tunnel.TunnelListenerAdapter;
import com.ovea.system.tunnel.TunnelListeners;
import com.ovea.system.util.IoUtils;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public final class Tunnel {
    private static final TunnelListener EMPTY = new TunnelListenerAdapter();
    private final AtomicReference<State> state = new AtomicReference<Object>(null);
    private final CountDownLatch latch = new CountDownLatch(2);
    private final String name;
    private final TunnelListener listener;
    private PipeConnection up;
    private PipeConnection down;
    private BrokenTunnelException brokenTunnelException;

    private Tunnel(String name, Pipe up, Pipe down, TunnelListener listener) {
        this.name = name;
        this.listener = new OnceTunnelListener(listener);
        this.up = up.listenedBy(new Listener(down, listener)).connect();
        this.down = down.listenedBy(new Listener(up, listener)).connect();
    }

    public boolean isOpened() {
        return this.state.get() == State.OPENED;
    }

    public boolean isClosed() {
        return this.state.get() == State.CLOSED;
    }

    public boolean isBroken() {
        return this.state.get() == State.BROKEN;
    }

    public boolean isInterrupted() {
        return this.state.get() == State.INTERRUPTED;
    }

    public void interrupt() {
        if (this.state.compareAndSet(null, State.INTERRUPTED) || this.state.compareAndSet(State.OPENED, State.INTERRUPTED)) {
            this.up.interrupt();
            this.down.interrupt();
            this.down = null;
            this.up = null;
            this.listener.onInterrupt(this);
        }
    }

    public String toString() {
        return this.name;
    }

    public void await(long time, TimeUnit unit) throws InterruptedException, BrokenTunnelException, TimeoutException {
        block5: {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            try {
                if (this.latch.await(time, unit)) {
                    if (this.isBroken()) {
                        throw this.brokenTunnelException;
                    }
                    break block5;
                }
                throw new TimeoutException();
            }
            catch (InterruptedException e) {
                this.interrupt();
                throw e;
            }
        }
    }

    public void await() throws InterruptedException, BrokenTunnelException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            this.latch.await();
            if (this.isBroken()) {
                throw this.brokenTunnelException;
            }
        }
        catch (InterruptedException e) {
            this.interrupt();
            throw e;
        }
    }

    public static Tunnel connect(Socket left, Socket right) throws IOException {
        return Tunnel.connect(left, right, EMPTY);
    }

    public static Tunnel connect(final Socket left, final Socket right, TunnelListener listener) throws IOException {
        if (left == null) {
            throw new IllegalArgumentException("Missing left socket");
        }
        if (right == null) {
            throw new IllegalArgumentException("Missing right socket");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Missing tunnel listener");
        }
        String l = left.getInetAddress().getHostAddress() + ":" + left.getPort();
        String r = right.getInetAddress().getHostAddress() + ":" + right.getPort();
        return new Tunnel(l + "<=>" + r, Pipes.create(l + "=>" + r, left.getInputStream(), right.getOutputStream()), Pipes.create(r + "=>" + l, right.getInputStream(), left.getOutputStream()), new TunnelListeners(new TunnelListenerAdapter(){

            @Override
            public void onClose(Tunnel tunnel) {
                IoUtils.close(left, right);
            }

            @Override
            public void onBroken(Tunnel tunnel, BrokenTunnelException e) {
                this.onClose(tunnel);
            }

            @Override
            public void onInterrupt(Tunnel tunnel) {
                this.onClose(tunnel);
            }
        }, listener));
    }

    private class Listener
    implements PipeListener {
        private Pipe other;
        private TunnelListener listener;

        private Listener(Pipe other, TunnelListener listener) {
            this.other = other;
            this.listener = listener;
        }

        @Override
        public void onConnect(Pipe pipe) {
            if (Tunnel.this.state.compareAndSet(null, State.OPENED)) {
                this.listener.onConnect(Tunnel.this);
            }
        }

        @Override
        public void onClose(Pipe pipe) {
            if (Tunnel.this.state.compareAndSet(null, State.CLOSED) || Tunnel.this.state.compareAndSet(State.OPENED, State.CLOSED)) {
                this.other.connect().interrupt();
                this.listener.onClose(Tunnel.this);
                this.other = null;
                this.listener = null;
            }
            Tunnel.this.latch.countDown();
        }

        @Override
        public void onBroken(Pipe pipe, BrokenPipeException e) {
            if (Tunnel.this.state.compareAndSet(null, State.BROKEN) || Tunnel.this.state.compareAndSet(State.OPENED, State.BROKEN)) {
                this.other.connect().interrupt();
                this.listener.onBroken(Tunnel.this, Tunnel.this.brokenTunnelException = new BrokenTunnelException(e));
                this.other = null;
                this.listener = null;
            }
            Tunnel.this.latch.countDown();
        }

        @Override
        public void onInterrupt(Pipe pipe) {
            if (Tunnel.this.state.compareAndSet(null, State.INTERRUPTED) || Tunnel.this.state.compareAndSet(State.OPENED, State.INTERRUPTED)) {
                this.other.connect().interrupt();
                this.listener.onInterrupt(Tunnel.this);
                this.other = null;
                this.listener = null;
            }
            Tunnel.this.latch.countDown();
        }
    }

    private static enum State {
        OPENED,
        CLOSED,
        INTERRUPTED,
        BROKEN;

    }
}

