/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.tunnel;

import com.ovea.system.tunnel.BrokenTunnelException;
import com.ovea.system.tunnel.Tunnel;
import com.ovea.system.tunnel.TunnelListener;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class TunnelListeners
implements TunnelListener {
    private final List<TunnelListener> listeners = new CopyOnWriteArrayList<TunnelListener>();

    public TunnelListeners(TunnelListener ... listeners) {
        this(Arrays.asList(listeners));
    }

    public TunnelListeners(Iterable<? extends TunnelListener> listeners) {
        this.add(listeners);
    }

    public void add(TunnelListener listener) {
        this.listeners.add(listener);
    }

    public void add(TunnelListener ... listeners) {
        this.add(Arrays.asList(listeners));
    }

    public void add(Iterable<? extends TunnelListener> listeners) {
        for (TunnelListener tunnelListener : listeners) {
            this.listeners.add(tunnelListener);
        }
    }

    @Override
    public void onConnect(Tunnel tunnel) {
        for (TunnelListener listener : this.listeners) {
            listener.onConnect(tunnel);
        }
    }

    @Override
    public void onClose(Tunnel tunnel) {
        for (TunnelListener listener : this.listeners) {
            listener.onClose(tunnel);
        }
    }

    @Override
    public void onBroken(Tunnel tunnel, BrokenTunnelException e) {
        for (TunnelListener listener : this.listeners) {
            listener.onBroken(tunnel, e);
        }
    }

    @Override
    public void onInterrupt(Tunnel tunnel) {
        for (TunnelListener listener : this.listeners) {
            listener.onInterrupt(tunnel);
        }
    }
}

