/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Scanner;

public final class IoUtils {
    private IoUtils() {
    }

    public static void close(Closeable ... closeables) {
        if (closeables != null && closeables.length > 0) {
            for (Closeable closeable : closeables) {
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
        }
    }

    public static void close(Socket ... closeables) {
        if (closeables != null && closeables.length > 0) {
            for (Socket closeable : closeables) {
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
        }
    }

    public static void close(ServerSocket ... closeables) {
        if (closeables != null && closeables.length > 0) {
            for (ServerSocket closeable : closeables) {
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
        }
    }

    public static void close(Scanner ... closeables) {
        if (closeables != null && closeables.length > 0) {
            for (Scanner closeable : closeables) {
                if (closeable == null) continue;
                try {
                    closeable.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
    }

    public static InputStream uncloseable(final InputStream in) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                return in.read();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static OutputStream uncloseable(final OutputStream stream) {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                stream.write(b);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static Reader uncloseable(final Reader stream) {
        return new Reader(){

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return stream.read(cbuf, off, len);
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static Writer uncloseable(final Writer stream) {
        return new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                stream.write(cbuf, off, len);
            }

            @Override
            public void flush() throws IOException {
                stream.flush();
            }

            @Override
            public void close() throws IOException {
            }
        };
    }
}

