/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.util;

import com.ovea.system.util.IoUtils;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;

public final class NetUtils {
    private NetUtils() {
    }

    public static boolean canConnect(String host, int port) {
        try {
            IoUtils.close(new Socket(host, port));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isPortAvailable(int port) {
        try {
            IoUtils.close(new ServerSocket(port));
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static int findAvailablePort(int min, int max) {
        int p;
        Random r = new Random();
        max = max - min + 1;
        while (!NetUtils.isPortAvailable(p = min + r.nextInt(max))) {
        }
        return p;
    }

    public static int findAvailablePort() {
        return NetUtils.findAvailablePort(1025, 65500);
    }
}

