/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.util;

public final class Platform {
    public static final int UNSPECIFIED = -1;
    public static final int MAC = 0;
    public static final int LINUX = 1;
    public static final int WINDOWS = 2;
    public static final int SOLARIS = 3;
    public static final int FREEBSD = 4;
    public static final int OPENBSD = 5;
    public static final int WINDOWSCE = 6;
    private static final int osType;

    private Platform() {
    }

    public static int getOSType() {
        return osType;
    }

    public static boolean isMac() {
        return osType == 0;
    }

    public static boolean isLinux() {
        return osType == 1;
    }

    public static boolean isWindowsCE() {
        return osType == 6;
    }

    public static boolean isWindows() {
        return osType == 2 || osType == 6;
    }

    public static boolean isSolaris() {
        return osType == 3;
    }

    public static boolean isFreeBSD() {
        return osType == 4;
    }

    public static boolean isOpenBSD() {
        return osType == 5;
    }

    public static boolean isX11() {
        return !Platform.isWindows() && !Platform.isMac();
    }

    public static boolean deleteNativeLibraryAfterVMExit() {
        return osType == 2;
    }

    public static boolean hasRuntimeExec() {
        return !Platform.isWindowsCE() || !"J9".equals(System.getProperty("java.vm.name"));
    }

    public static boolean is64Bit() {
        String model = System.getProperty("sun.arch.data.model");
        if (model != null) {
            return "64".equals(model);
        }
        String arch = System.getProperty("os.arch").toLowerCase();
        return "x86_64".equals(arch) || "ppc64".equals(arch) || "sparcv9".equals(arch) || "amd64".equals(arch);
    }

    static {
        String osName = System.getProperty("os.name");
        osType = osName.startsWith("Linux") ? 1 : (osName.startsWith("Mac") || osName.startsWith("Darwin") ? 0 : (osName.startsWith("Windows CE") ? 6 : (osName.startsWith("Windows") ? 2 : (osName.startsWith("Solaris") || osName.startsWith("SunOS") ? 3 : (osName.startsWith("FreeBSD") ? 4 : (osName.startsWith("OpenBSD") ? 5 : -1))))));
    }
}

