/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.util;

import com.ovea.system.util.SigarLoader;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public final class ProcUtils {
    private ProcUtils() {
    }

    public static long pid(Process process) {
        String cName = process.getClass().getName();
        if (cName.equals("java.lang.UNIXProcess")) {
            try {
                Field f = process.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                return f.getInt(process);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Unable to recover PID from Unix process" + process);
            }
        }
        if (cName.equals("java.lang.ProcessImpl") || cName.equals("java.lang.Win32Process")) {
            WinNT.HANDLE handle = new WinNT.HANDLE();
            try {
                Field f = process.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long handl = f.getLong(process);
                handle.setPointer(Pointer.createConstant((long)handl));
                long l = Kernel32.INSTANCE.GetProcessId(handle);
                return l;
            }
            catch (Throwable e) {
                throw new IllegalStateException("Unable to recover PID from Windows process" + process);
            }
            finally {
                Kernel32.INSTANCE.CloseHandle(handle);
            }
        }
        throw new IllegalArgumentException("Process type not supported: " + process.getClass().getName());
    }

    public static long currentPID() {
        return RuntimePID.get();
    }

    public static void terminate(Process process) {
        long pid = ProcUtils.pid(process);
        String cName = process.getClass().getName();
        if (cName.equals("java.lang.UNIXProcess")) {
            try {
                Method destroyProcess = process.getClass().getDeclaredMethod("destroyProcess", Integer.TYPE);
                destroyProcess.setAccessible(true);
                destroyProcess.invoke(null, (int)pid);
            }
            catch (Throwable e) {
                ProcUtils.terminate(pid);
            }
        } else if (cName.equals("java.lang.ProcessImpl") || cName.equals("java.lang.Win32Process")) {
            try {
                Field f = process.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                Method destroyProcess = process.getClass().getDeclaredMethod("terminateProcess", Long.TYPE);
                destroyProcess.setAccessible(true);
                destroyProcess.invoke(null, f.getLong(process));
            }
            catch (Throwable e) {
                ProcUtils.terminate(pid);
            }
        } else {
            throw new IllegalArgumentException("Process type not supported: " + process.getClass().getName());
        }
    }

    public static boolean exist(long pid) {
        try {
            ProcState state = SigarLoader.instance().getProcState(pid);
            return state.getPpid() > 0L;
        }
        catch (SigarException e) {
            return false;
        }
    }

    public static void terminate(long pid) {
        ProcUtils.kill(pid, "SIGTERM");
    }

    public static void kill(long pid) {
        ProcUtils.kill(pid, "SIGKILL");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void kill(long pid, String signal) {
        if (Platform.isWindows() || Platform.isWindowsCE()) {
            WinNT.HANDLE handle = Kernel32.INSTANCE.OpenProcess(1, true, (int)pid);
            try {
                if (handle == null) return;
                Kernel32.INSTANCE.TerminateProcess(handle, 0);
                return;
            }
            finally {
                if (handle != null) {
                    Kernel32.INSTANCE.CloseHandle(handle);
                }
            }
        }
        Sigar sigar = SigarLoader.instance();
        int n = Sigar.getSigNum((String)signal);
        try {
            sigar.kill(pid, n);
            return;
        }
        catch (SigarException ignored) {
            // empty catch block
        }
    }

    private static final class RuntimePID {
        private static final long pid;

        private RuntimePID() {
        }

        public static long get() {
            return pid;
        }

        static {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            Matcher matcher = Pattern.compile("^([0-9]+)@.+$", 2).matcher(processName);
            if (!matcher.matches()) {
                throw new IllegalStateException("Unable to recover PID from process identifier: " + processName);
            }
            pid = Long.parseLong(matcher.group(1));
        }
    }
}

