/*
 * Decompiled with CFR 0.152.
 */
package com.ovea.system.util;

import com.ovea.system.util.IoUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.hyperic.jni.ArchNotSupportedException;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public final class SigarLoader {
    private SigarLoader() {
    }

    public static Sigar newSigar() {
        return Loader.newSigar();
    }

    public static Sigar instance() {
        return Loader.SIGAR;
    }

    private static final class Loader {
        private static final Sigar SIGAR;

        private Loader() {
        }

        static Sigar newSigar() {
            return new Sigar();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            try {
                org.hyperic.sigar.SigarLoader loader;
                File tmp;
                block24: {
                    tmp = new File(System.getProperty("java.io.tmpdir"), "ovea-system-sigar");
                    if (!tmp.exists()) {
                        tmp.mkdirs();
                    }
                    loader = new org.hyperic.sigar.SigarLoader(Sigar.class);
                    File lib = new File(tmp, loader.getLibraryName());
                    File lockFile = new File(lib + ".lock");
                    FileChannel channel = null;
                    FileLock lock = null;
                    try {
                        channel = new RandomAccessFile(lockFile, "rw").getChannel();
                        lock = channel.lock();
                        if (lib.exists()) break block24;
                        InputStream in = null;
                        BufferedOutputStream out = null;
                        try {
                            int c;
                            String name = loader.getLibName();
                            if (name == null) {
                                name = loader.getDefaultLibName();
                            }
                            name = "sigar/" + org.hyperic.sigar.SigarLoader.getLibraryPrefix() + name + org.hyperic.sigar.SigarLoader.getLibraryExtension();
                            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
                            if (in == null) {
                                throw new IllegalStateException("SIGAR library " + name + " not found in classpath");
                            }
                            in = new BufferedInputStream(in);
                            out = new BufferedOutputStream(new FileOutputStream(lib));
                            byte[] buffer = new byte[8192];
                            while ((c = in.read(buffer)) != -1) {
                                ((OutputStream)out).write(buffer, 0, c);
                            }
                        }
                        catch (Throwable throwable) {
                            IoUtils.close(out, in);
                            throw throwable;
                        }
                        IoUtils.close(out, in);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                    finally {
                        if (lock != null) {
                            try {
                                lock.release();
                            }
                            catch (IOException ignored) {}
                        }
                        if (channel != null) {
                            try {
                                channel.close();
                            }
                            catch (IOException ignored) {}
                        }
                        lockFile.delete();
                    }
                }
                System.setProperty(loader.getPackageName() + ".path", tmp.getAbsolutePath());
                Sigar.load();
                SIGAR = Loader.newSigar();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        SIGAR.close();
                    }
                });
            }
            catch (ArchNotSupportedException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (SigarException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

