/*
 * Decompiled with CFR 0.152.
 */
package com.overstock.findbugs;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class GuavaBetaDetector
extends OpcodeStackDetector {
    private static final String BETA = "Lcom/google/common/annotations/Beta;";
    private static final Set<String> IGNORE;
    private BugReporter bugReporter;

    public GuavaBetaDetector(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                JavaClass javaClass = this.getOperandLibraryClass();
                if (javaClass == null) break;
                this.checkJavaClass(javaClass);
                Method method = this.getMethod(javaClass, this.getNameConstantOperand(), this.getSigConstantOperand());
                if (method == null || !this.isBetaAnnotated((FieldOrMethod)method) || IGNORE.contains(javaClass.getClassName())) break;
                this.bugReporter.reportBug(this.bugInstance("GBU_GUAVA_BETA_METHOD_USAGE").addCalledMethod((DismantleBytecode)this));
                break;
            }
            case 178: 
            case 180: {
                JavaClass javaClass = this.getOperandLibraryClass();
                if (javaClass == null) break;
                this.checkJavaClass(javaClass);
                Field field = this.getField(javaClass, this.getNameConstantOperand());
                if (field == null || !this.isBetaAnnotated((FieldOrMethod)field) || IGNORE.contains(javaClass.getClassName())) break;
                this.bugReporter.reportBug(this.bugInstance("GBU_GUAVA_BETA_FIELD_USAGE").addReferencedField((DismantleBytecode)this));
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                JavaClass javaClass;
                Constant c = this.getConstantRefOperand();
                if (!(c instanceof ConstantClass) || (javaClass = this.getOperandLibraryClass()) == null) break;
                this.checkJavaClass(javaClass);
                break;
            }
        }
    }

    private JavaClass getOperandLibraryClass() {
        try {
            JavaClass javaClass = Repository.lookupClass((String)this.getClassConstantOperand());
            return AnalysisContext.currentAnalysisContext().isApplicationClass(javaClass) ? null : javaClass;
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
            return null;
        }
    }

    private Method getMethod(JavaClass javaClass, String name, String sig) {
        JavaClass currentClass = javaClass;
        while (currentClass != null) {
            for (Method method : currentClass.getMethods()) {
                if (!name.equals(method.getName()) || !sig.equals(method.getSignature())) continue;
                return method;
            }
            currentClass = this.getSuperclass(currentClass);
        }
        if (!javaClass.isAbstract()) {
            this.bugReporter.logError("Unable to locate method " + javaClass.getClassName() + "." + name + sig);
        }
        return null;
    }

    private JavaClass getSuperclass(JavaClass javaClass) {
        try {
            return javaClass.getSuperClass();
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
            return null;
        }
    }

    private Field getField(JavaClass javaClass, String name) {
        JavaClass currentClass = javaClass;
        while (currentClass != null) {
            for (Field field : currentClass.getFields()) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
            currentClass = this.getSuperclass(currentClass);
        }
        this.bugReporter.logError("Unable to locate field " + javaClass.getClassName() + "." + name);
        return null;
    }

    private void checkJavaClass(JavaClass javaClass) {
        if (this.isBetaAnnotated(javaClass.getAnnotationEntries()) && !IGNORE.contains(javaClass.getClassName())) {
            this.bugReporter.reportBug(this.bugInstance("GBU_GUAVA_BETA_CLASS_USAGE").addClass(javaClass));
        }
    }

    private BugInstance bugInstance(String type) {
        return new BugInstance((Detector)this, type, 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this);
    }

    private boolean isBetaAnnotated(FieldOrMethod annotated) {
        return this.isBetaAnnotated(annotated.getAnnotationEntries());
    }

    private boolean isBetaAnnotated(AnnotationEntry[] annotationEntries) {
        for (AnnotationEntry annotationEntry : annotationEntries) {
            if (!BETA.equals(annotationEntry.getAnnotationType())) continue;
            return true;
        }
        return false;
    }

    static {
        HashSet<String> ignore = new HashSet<String>();
        String property = System.getProperty("com.overstock.findbugs.ignore");
        if (property != null) {
            ignore.addAll(Arrays.asList(property.split(",")));
        }
        IGNORE = Collections.unmodifiableSet(ignore);
    }
}

