/**
 * Copyright 2012, OVH. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and limitations under the License.
 */
package com.ovh.ws.api;

/**
 * The primary interface a caller must implement to receive a response from a remote procedure call.
 */
public interface AsyncCallback<T> {

	/**
	 * Called when an asynchronous call completes successfully.
	 * 
	 * @param result
	 *            the return value of the remote produced call
	 */
	void onSuccess(T result);

	/**
	 * Called when an asynchronous call fails to complete normally.
	 * 
	 * @param caught
	 *            failure encountered while executing a remote procedure call
	 */
	void onFailure(OvhWsException caught);
}
