/*
 * Decompiled with CFR 0.152.
 */
package com.ovh.ws.api.http;

import com.ovh.ws.api.OvhWsException;
import com.ovh.ws.api.base.Hex;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSigner {
    private static final Logger LOG = LoggerFactory.getLogger(RequestSigner.class);
    private static final String ALGORITHM = "SHA-1";
    private static final char SEPARATOR = '+';
    private static final String NONCE_PARAM = "X-OVH-NONCE";
    private static final String SIGNATURE_PARAM = "X-OVH-SIGN";

    public Map<String, String> getSigningHeaders(String url, String requestParams, String token) throws OvhWsException {
        String nonce = this.generateNonce();
        String signature = this.getRequestSignature(url, requestParams, nonce, token);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(NONCE_PARAM, nonce);
        headers.put(SIGNATURE_PARAM, signature);
        return headers;
    }

    private String getRequestSignature(String url, String requestData, String nonce, String token) throws OvhWsException {
        try {
            String dataToDigest = this.getDataToDigest(url, requestData, nonce, token);
            LOG.debug("Data used to sign : {}", (Object)dataToDigest);
            String signature = this.getSignature(dataToDigest);
            LOG.debug("Resulting signature : {}", (Object)signature);
            return signature;
        }
        catch (UnsupportedEncodingException e) {
            throw new OvhWsException(OvhWsException.Type.UnrecognizedError, "Could not sign request", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OvhWsException(OvhWsException.Type.UnrecognizedError, "Could not sign request", (Throwable)e);
        }
    }

    private String getDataToDigest(String url, String requestData, String nonce, String token) {
        StringBuilder builder = new StringBuilder(url);
        builder.append('+').append(requestData);
        builder.append('+').append(nonce);
        if (token != null) {
            builder.append('+').append(token);
        }
        return builder.toString().replaceAll("\\s", "");
    }

    private String getSignature(String dataToDigest) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance(ALGORITHM);
        byte[] hash = digest.digest(dataToDigest.getBytes("UTF-8"));
        return Hex.encode(hash);
    }

    private String generateNonce() {
        return System.currentTimeMillis() + "." + Math.random();
    }
}

