/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.TransformationRuntimeException;
import com.owlike.genson.internal.asm.ClassReader;
import com.owlike.genson.internal.asm.Label;
import com.owlike.genson.internal.asm.MethodVisitor;
import com.owlike.genson.internal.asm.Type;
import com.owlike.genson.internal.asm.commons.EmptyVisitor;
import com.owlike.genson.reflect.PropertyNameResolver;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASMCreatorParameterNameResolver
implements PropertyNameResolver {
    private final boolean doThrowException;
    private final Map<Constructor<?>, String[]> constructorParameterNames = new ConcurrentHashMap();
    private final Map<Method, String[]> methodParameterNames = new ConcurrentHashMap<Method, String[]>();

    public ASMCreatorParameterNameResolver(boolean doThrowException) {
        this.doThrowException = doThrowException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(Class<?> ofClass) {
        String ofClassName = ofClass.getName();
        ofClassName = ofClassName.replace('.', '/') + ".class";
        InputStream is = ASMCreatorParameterNameResolver.class.getClassLoader().getResourceAsStream(ofClassName);
        ClassConstructorsVisitor visitor = new ClassConstructorsVisitor(ofClass, this.constructorParameterNames, this.methodParameterNames);
        try {
            ClassReader cr = new ClassReader(is);
            cr.accept(visitor, 0);
        }
        catch (IOException e) {
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public String resolve(int parameterIdx, Constructor<?> fromConstructor) {
        String[] names = this.constructorParameterNames.get(fromConstructor);
        if (names == null) {
            this.read(fromConstructor.getDeclaringClass());
            names = this.constructorParameterNames.get(fromConstructor);
        }
        if (names == null || names.length <= parameterIdx) {
            if (this.doThrowException) {
                this._throwNoDebugInfo(fromConstructor.getDeclaringClass().getName());
            }
            return null;
        }
        return names[parameterIdx];
    }

    @Override
    public String resolve(Field fromField) {
        return null;
    }

    @Override
    public String resolve(Method fromMethod) {
        return null;
    }

    @Override
    public String resolve(int parameterIdx, Method fromMethod) {
        String[] names = this.methodParameterNames.get(fromMethod);
        if (names == null) {
            this.read(fromMethod.getDeclaringClass());
            names = this.methodParameterNames.get(fromMethod);
        }
        if (names == null || names.length <= parameterIdx) {
            if (this.doThrowException) {
                this._throwNoDebugInfo(fromMethod.getDeclaringClass().getName());
            }
            return null;
        }
        return names[parameterIdx];
    }

    private void _throwNoDebugInfo(String className) {
        throw new TransformationRuntimeException("Class " + className + " has been compiled with no debug information, so we can not deduce constructor/method parameter names.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstructorVisitor
    extends BaseMethodVisitor {
        private final Map<Constructor<?>, String[]> parameterNamesMap;

        public ConstructorVisitor(Class<?> forClass, boolean ztatic, String desc, Map<Constructor<?>, String[]> parameterNamesMap) {
            super(forClass, ztatic, desc, ASMCreatorParameterNameResolver.this.methodParameterNames);
            this.parameterNamesMap = parameterNamesMap;
        }

        @Override
        public void visitEnd() {
            if (this.paramNames.size() == this.paramTypes.length) {
                Constructor constructor = null;
                Class[] javaTypes = new Class[this.paramTypes.length];
                for (int i = 0; i < this.paramTypes.length; ++i) {
                    javaTypes[i] = this.resolveClass(this.paramTypes[i]);
                }
                try {
                    constructor = this.forClass.getDeclaredConstructor(javaTypes);
                    this.parameterNamesMap.put(constructor, this.paramNames.toArray(new String[this.paramNames.size()]));
                }
                catch (SecurityException e) {
                    throw new TransformationRuntimeException("Unable to locate constructor with signature " + this.signature(), e);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }

        @Override
        public String signature() {
            StringBuilder sb = new StringBuilder(this.forClass.getSimpleName()).append("(");
            for (int i = 0; i < this.paramTypes.length; ++i) {
                String paramName = this.paramNames.isEmpty() ? "?" : (String)this.paramNames.get(i);
                sb.append(this.paramTypes[i].getClassName()).append(" " + paramName);
                if (i >= this.paramTypes.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NameMethodVisitor
    extends BaseMethodVisitor {
        private final Map<Method, String[]> parameterNamesMap;
        private String name;

        public NameMethodVisitor(String name, Class<?> forClass, boolean ztatic, String desc, Map<Method, String[]> parameterNamesMap) {
            super(forClass, ztatic, desc, parameterNamesMap);
            this.parameterNamesMap = parameterNamesMap;
            this.name = name;
        }

        @Override
        public void visitEnd() {
            if (this.paramNames.size() == this.paramTypes.length) {
                Method method = null;
                Class[] javaTypes = new Class[this.paramTypes.length];
                for (int i = 0; i < this.paramTypes.length; ++i) {
                    javaTypes[i] = this.resolveClass(this.paramTypes[i]);
                }
                try {
                    method = this.forClass.getMethod(this.name, javaTypes);
                    this.parameterNamesMap.put(method, this.paramNames.toArray(new String[this.paramNames.size()]));
                }
                catch (SecurityException e) {
                    throw new TransformationRuntimeException("Unable to locate method with signature " + this.signature(), e);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }

        @Override
        public String signature() {
            StringBuilder sb = new StringBuilder(this.name).append("(");
            for (int i = 0; i < this.paramTypes.length; ++i) {
                String paramName = this.paramNames.isEmpty() ? "?" : (String)this.paramNames.get(i);
                sb.append(this.paramTypes[i].getClassName()).append(" " + paramName);
                if (i >= this.paramTypes.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            return sb.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseMethodVisitor
    extends EmptyVisitor {
        protected Type[] paramTypes;
        protected ArrayList<String> paramNames;
        protected final Class<?> forClass;
        protected boolean ztatic;

        public BaseMethodVisitor(Class<?> forClass, boolean ztatic, String desc, Map<Method, String[]> parameterNamesMap) {
            this.forClass = forClass;
            this.ztatic = ztatic;
            this.paramTypes = Type.getArgumentTypes(desc);
            this.paramNames = new ArrayList(this.paramTypes.length);
        }

        @Override
        public void visitLocalVariable(String variableName, String desc, String sig, Label start, Label end, int index) {
            if (!this.ztatic) {
                --index;
            }
            if ((index >= 0 || this.forClass.isMemberClass() && (this.forClass.getModifiers() & 8) == 0) && this.paramNames.size() < this.paramTypes.length) {
                this.paramNames.add(variableName);
            }
        }

        protected Class<?> resolveClass(Type type) {
            switch (type.getSort()) {
                case 9: {
                    Class<?> componentClass = this.resolveClass(type.getElementType());
                    return Array.newInstance(componentClass, 0).getClass();
                }
                case 1: {
                    return Boolean.TYPE;
                }
                case 3: {
                    return Byte.TYPE;
                }
                case 2: {
                    return Character.TYPE;
                }
                case 8: {
                    return Double.TYPE;
                }
                case 6: {
                    return Float.TYPE;
                }
                case 5: {
                    return Integer.TYPE;
                }
                case 7: {
                    return Long.TYPE;
                }
                case 10: {
                    try {
                        return Class.forName(type.getClassName());
                    }
                    catch (ClassNotFoundException e) {
                        throw new TransformationRuntimeException("Could not found class " + type.getClassName() + " while searching for constructor " + this.signature() + " parameter names.", e);
                    }
                }
                case 4: {
                    return Short.TYPE;
                }
                case 0: {
                    return Void.TYPE;
                }
            }
            throw new TransformationRuntimeException("Could not find corresponding java type to asm type " + type);
        }

        public abstract String signature();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClassConstructorsVisitor
    extends EmptyVisitor {
        private static final String CONSTRUCTOR_METHOD_NAME = "<init>";
        private final Class<?> forClass;
        final Map<Constructor<?>, String[]> ctrParameterNames;
        final Map<Method, String[]> methodParameterNames;

        public ClassConstructorsVisitor(Class<?> forClass, Map<Constructor<?>, String[]> ctrParameterNames, Map<Method, String[]> methodParameterNames) {
            this.forClass = forClass;
            this.ctrParameterNames = ctrParameterNames;
            this.methodParameterNames = methodParameterNames;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            boolean ztatic;
            boolean bl = ztatic = (access & 8) > 0;
            if ((access & 0x400) == 0) {
                if (CONSTRUCTOR_METHOD_NAME.equals(name)) {
                    return new ConstructorVisitor(this.forClass, ztatic, desc, this.ctrParameterNames);
                }
                if (!"<clinit>".equals(name)) {
                    return new NameMethodVisitor(name, this.forClass, ztatic, desc, this.methodParameterNames);
                }
            }
            return null;
        }
    }
}

