/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.Converter;
import com.owlike.genson.Genson;
import com.owlike.genson.Trilean;
import com.owlike.genson.annotation.Creator;
import com.owlike.genson.reflect.AbstractBeanDescriptorProvider;
import com.owlike.genson.reflect.BeanCreator;
import com.owlike.genson.reflect.BeanMutatorAccessorResolver;
import com.owlike.genson.reflect.BeanProperty;
import com.owlike.genson.reflect.PropertyAccessor;
import com.owlike.genson.reflect.PropertyMutator;
import com.owlike.genson.reflect.PropertyNameResolver;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseBeanDescriptorProvider
extends AbstractBeanDescriptorProvider {
    private static final Comparator<BeanCreator<?>> _beanCreatorsComparator = new Comparator<BeanCreator<?>>(){

        @Override
        public int compare(BeanCreator<?> o1, BeanCreator<?> o2) {
            return o1.parameters.size() - o2.parameters.size();
        }
    };
    protected final BeanMutatorAccessorResolver mutatorAccessorResolver;
    protected final PropertyNameResolver nameResolver;
    protected final boolean useGettersAndSetters;
    protected final boolean useFields;
    protected final boolean favorEmptyCreators;

    public BaseBeanDescriptorProvider(BeanMutatorAccessorResolver mutatorAccessorResolver, PropertyNameResolver nameResolver, boolean useGettersAndSetters, boolean useFields, boolean favorEmptyCreators) {
        if (mutatorAccessorResolver == null) {
            throw new IllegalArgumentException("mutatorAccessorResolver must be not null!");
        }
        if (nameResolver == null) {
            throw new IllegalArgumentException("nameResolver must be not null!");
        }
        this.mutatorAccessorResolver = mutatorAccessorResolver;
        this.nameResolver = nameResolver;
        this.useFields = useFields;
        this.useGettersAndSetters = useGettersAndSetters;
        if (!useFields && !useGettersAndSetters) {
            throw new IllegalArgumentException("You must allow at least one mode: with fields or methods.");
        }
        this.favorEmptyCreators = favorEmptyCreators;
    }

    @Override
    public <T> List<BeanCreator<T>> provideBeanCreators(Class<?> ofClass, Genson genson) {
        ArrayList<BeanCreator<T>> creators = new ArrayList<BeanCreator<T>>();
        if (ofClass.isMemberClass() && (ofClass.getModifiers() & 8) == 0) {
            return creators;
        }
        this.provideConstructorCreators(ofClass, creators, genson);
        for (Class<?> clazz = ofClass; clazz != null && !Object.class.equals(clazz); clazz = clazz.getSuperclass()) {
            this.provideMethodCreators(clazz, creators, ofClass, genson);
        }
        return creators;
    }

    @Override
    public <T> void provideBeanPropertyAccessors(Class<?> ofClass, Map<String, LinkedList<PropertyAccessor<T, ?>>> accessorsMap, Genson genson) {
        for (Class<?> clazz = ofClass; clazz != null && !Object.class.equals(clazz); clazz = clazz.getSuperclass()) {
            if (this.useFields) {
                this.provideFieldAccessors(clazz, accessorsMap, ofClass, genson);
            }
            if (!this.useGettersAndSetters) continue;
            this.provideMethodAccessors(clazz, accessorsMap, ofClass, genson);
        }
    }

    @Override
    public <T> void provideBeanPropertyMutators(Class<?> ofClass, Map<String, LinkedList<PropertyMutator<T, ?>>> mutatorsMap, Genson genson) {
        for (Class<?> clazz = ofClass; clazz != null && !Object.class.equals(clazz); clazz = clazz.getSuperclass()) {
            if (this.useFields) {
                this.provideFieldMutators(clazz, mutatorsMap, ofClass, genson);
            }
            if (!this.useGettersAndSetters) continue;
            this.provideMethodMutators(clazz, mutatorsMap, ofClass, genson);
        }
    }

    protected <T> void provideConstructorCreators(Class<?> ofClass, List<BeanCreator<T>> creators, Genson genson) {
        Constructor<?>[] ctrs;
        for (Constructor<?> ctr : ctrs = ofClass.getDeclaredConstructors()) {
            String name;
            int idx;
            if (Trilean.TRUE != this.mutatorAccessorResolver.isCreator(ctr, ofClass)) continue;
            Type[] parameterTypes = ctr.getGenericParameterTypes();
            int paramCnt = parameterTypes.length;
            String[] parameterNames = new String[paramCnt];
            for (idx = 0; idx < paramCnt && (name = this.nameResolver.resolve(idx, ctr)) != null; ++idx) {
                parameterNames[idx] = name;
            }
            if (idx != paramCnt) continue;
            BeanCreator<?> creator = this.createCreator(ofClass, ctr, parameterNames, genson);
            creators.add(creator);
        }
    }

    protected <T> BeanCreator<T> createCreator(Class<T> ofClass, Constructor<T> ctr, String[] resolvedNames, Genson genson) {
        return new BeanCreator.ConstructorBeanCreator<T>(ofClass, ctr, resolvedNames, this.resolveConverters(ctr.getGenericParameterTypes(), genson));
    }

    protected <T> void provideMethodCreators(Class<?> ofClass, List<BeanCreator<T>> creators, Class<?> baseClass, Genson genson) {
        Method[] ctrs;
        for (Method ctr : ctrs = ofClass.getDeclaredMethods()) {
            String name;
            int idx;
            if (Trilean.TRUE != this.mutatorAccessorResolver.isCreator(ctr, baseClass)) continue;
            Type[] parameterTypes = ctr.getGenericParameterTypes();
            int paramCnt = parameterTypes.length;
            String[] parameterNames = new String[paramCnt];
            for (idx = 0; idx < paramCnt && (name = this.nameResolver.resolve(idx, ctr)) != null; ++idx) {
                parameterNames[idx] = name;
            }
            if (idx != paramCnt) continue;
            BeanCreator<T> creator = this.createCreator(baseClass, ctr, parameterNames, genson);
            creators.add(creator);
        }
    }

    protected <T> BeanCreator<T> createCreator(Class<?> ofClass, Method method, String[] resolvedNames, Genson genson) {
        return new BeanCreator.MethodBeanCreator(method, resolvedNames, this.resolveConverters(method.getGenericParameterTypes(), genson));
    }

    private Converter<?>[] resolveConverters(Type[] types, Genson genson) {
        Converter[] converters = new Converter[types.length];
        for (int i = 0; i < types.length; ++i) {
            converters[i] = genson.provideConverter(types[i]);
        }
        return converters;
    }

    protected <T> void provideFieldAccessors(Class<?> ofClass, Map<String, LinkedList<PropertyAccessor<T, ?>>> accessorsMap, Class<?> baseClass, Genson genson) {
        Field[] fields;
        for (Field field : fields = ofClass.getDeclaredFields()) {
            if (Trilean.TRUE != this.mutatorAccessorResolver.isAccessor(field, baseClass)) continue;
            String name = this.nameResolver.resolve(field);
            if (name == null) {
                throw new IllegalStateException("Field '" + field.getName() + "' from class " + ofClass.getName() + " has been discovered as accessor but its name couldn't be resolved!");
            }
            PropertyAccessor<?, ?> accessor = this.createAccessor(name, field, baseClass, genson);
            this.update(accessor, accessorsMap);
        }
    }

    protected <T> PropertyAccessor<T, ?> createAccessor(String name, Field field, Class<T> baseClass, Genson genson) {
        return new PropertyAccessor.FieldAccessor(name, field, baseClass, genson.provideConverter(field.getGenericType()));
    }

    protected <T> void provideMethodAccessors(Class<?> ofClass, Map<String, LinkedList<PropertyAccessor<T, ?>>> accessorsMap, Class<?> baseClass, Genson genson) {
        Method[] methods;
        for (Method method : methods = ofClass.getDeclaredMethods()) {
            if (Trilean.TRUE != this.mutatorAccessorResolver.isAccessor(method, baseClass)) continue;
            String name = this.nameResolver.resolve(method);
            if (name == null) {
                throw new IllegalStateException("Method '" + method.getName() + "' from class " + ofClass.getName() + " has been discovered as accessor but its name couldn't be resolved!");
            }
            PropertyAccessor<T, ?> accessor = this.createAccessor(name, method, baseClass, genson);
            this.update(accessor, accessorsMap);
        }
    }

    protected <T> PropertyAccessor<T, ?> createAccessor(String name, Method method, Class<?> baseClass, Genson genson) {
        return new PropertyAccessor.MethodAccessor(name, method, baseClass, genson.provideConverter(method.getGenericReturnType()));
    }

    protected <T> void provideFieldMutators(Class<?> ofClass, Map<String, LinkedList<PropertyMutator<T, ?>>> mutatorsMap, Class<?> baseClass, Genson genson) {
        Field[] fields;
        for (Field field : fields = ofClass.getDeclaredFields()) {
            if (Trilean.TRUE != this.mutatorAccessorResolver.isMutator(field, baseClass)) continue;
            String name = this.nameResolver.resolve(field);
            if (name == null) {
                throw new IllegalStateException("Field '" + field.getName() + "' from class " + ofClass.getName() + " has been discovered as mutator but its name couldn't be resolved!");
            }
            PropertyMutator<?, ?> mutator = this.createMutator(name, field, baseClass, genson);
            this.update(mutator, mutatorsMap);
        }
    }

    protected <T> PropertyMutator<T, ?> createMutator(String name, Field field, Class<T> baseClass, Genson genson) {
        return new PropertyMutator.FieldMutator(name, field, baseClass, genson.provideConverter(field.getGenericType()));
    }

    protected <T> void provideMethodMutators(Class<?> ofClass, Map<String, LinkedList<PropertyMutator<T, ?>>> mutatorsMap, Class<?> baseClass, Genson genson) {
        Method[] methods;
        for (Method method : methods = ofClass.getDeclaredMethods()) {
            if (Trilean.TRUE != this.mutatorAccessorResolver.isMutator(method, baseClass)) continue;
            String name = this.nameResolver.resolve(method);
            if (name == null) {
                throw new IllegalStateException("Method '" + method.getName() + "' from class " + ofClass.getName() + " has been discovered as mutator but its name couldn't be resolved!");
            }
            PropertyMutator<T, ?> mutator = this.createMutator(name, method, baseClass, genson);
            this.update(mutator, mutatorsMap);
        }
    }

    protected <T> PropertyMutator<T, ?> createMutator(String name, Method method, Class<?> baseClass, Genson genson) {
        return new PropertyMutator.MethodMutator(name, method, baseClass, genson.provideConverter(method.getGenericParameterTypes()[0]));
    }

    protected <T extends BeanProperty<?>> void update(T property, Map<String, LinkedList<T>> map) {
        LinkedList<Object> accessors = map.get(property.name);
        if (accessors == null) {
            accessors = new LinkedList();
            map.put(property.name, accessors);
        }
        accessors.add(property);
    }

    @Override
    protected <T> BeanCreator<T> checkAndMerge(Class<?> ofClass, List<BeanCreator<T>> creators) {
        if (creators == null || creators.isEmpty()) {
            return null;
        }
        if (this.favorEmptyCreators) {
            Collections.sort(creators, _beanCreatorsComparator);
        }
        boolean hasCreatorAnnotation = false;
        BeanCreator<T> creator = null;
        for (int i = 0; i < creators.size(); ++i) {
            BeanCreator<T> ctr = creators.get(i);
            if (!ctr.isAnnotationPresent(Creator.class)) continue;
            if (!hasCreatorAnnotation) {
                hasCreatorAnnotation = true;
                continue;
            }
            this._throwCouldCreateBeanDescriptor(ofClass, " only one @Creator annotation per class is allowed.");
        }
        if (hasCreatorAnnotation) {
            for (BeanCreator<T> ctr : creators) {
                if (!ctr.isAnnotationPresent(Creator.class)) continue;
                return ctr;
            }
        } else {
            creator = creators.get(0);
        }
        return creator;
    }

    protected void _throwCouldCreateBeanDescriptor(Class<?> ofClass, String reason) {
        throw new IllegalStateException("Could not create BeanDescriptor for type " + ofClass.getName() + "," + reason);
    }

    @Override
    protected <T> PropertyAccessor<T, ?> checkAndMergeAccessors(String name, LinkedList<PropertyAccessor<T, ?>> accessors) {
        PropertyAccessor<T, ?> accessor = this._mostSpecificPropertyDeclaringClass(name, accessors);
        return accessor;
    }

    @Override
    protected <T> PropertyMutator<T, ?> checkAndMergeMutators(String name, LinkedList<PropertyMutator<T, ?>> mutators) {
        PropertyMutator<T, ?> mutator = this._mostSpecificPropertyDeclaringClass(name, mutators);
        return mutator;
    }

    protected <T extends BeanProperty<?>> T _mostSpecificPropertyDeclaringClass(String name, LinkedList<T> properties) {
        Iterator it = properties.iterator();
        BeanProperty property = (BeanProperty)it.next();
        while (it.hasNext()) {
            BeanProperty next = (BeanProperty)it.next();
            if (property.declaringClass.equals(next.declaringClass) && property.priority() < next.priority()) {
                property = next;
                continue;
            }
            if (property.declaringClass.isAssignableFrom(next.declaringClass)) {
                property = next;
                continue;
            }
            if (next.declaringClass.isAssignableFrom(property.declaringClass)) continue;
            throw new IllegalStateException("Property named '" + name + "' has two properties with different types : " + property.signature() + " and " + next.signature());
        }
        return (T)property;
    }

    @Override
    protected <T> void mergeMutatorsWithCreatorProperties(Class<?> tClass, Map<String, PropertyMutator<T, ?>> mutators, List<BeanCreator<T>> creators) {
        for (BeanCreator<T> creator : creators) {
            for (Map.Entry entry : creator.parameters.entrySet()) {
                PropertyMutator<T, ?> muta = mutators.get(entry.getKey());
                if (muta != null) continue;
                BeanCreator.BeanCreatorProperty ctrProperty = entry.getValue();
                mutators.put(entry.getKey(), ctrProperty);
            }
        }
    }
}

