/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson;

import com.owlike.genson.BeanView;
import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Deserializer;
import com.owlike.genson.Factory;
import com.owlike.genson.GenericType;
import com.owlike.genson.Serializer;
import com.owlike.genson.TransformationException;
import com.owlike.genson.TransformationRuntimeException;
import com.owlike.genson.convert.BasicConvertersFactory;
import com.owlike.genson.convert.BeanViewConverter;
import com.owlike.genson.convert.ChainedFactory;
import com.owlike.genson.convert.CircularClassReferenceConverterFactory;
import com.owlike.genson.convert.ClassMetadataConverter;
import com.owlike.genson.convert.DefaultConverters;
import com.owlike.genson.convert.NullConverter;
import com.owlike.genson.convert.RuntimeTypeConverter;
import com.owlike.genson.reflect.ASMCreatorParameterNameResolver;
import com.owlike.genson.reflect.BaseBeanDescriptorProvider;
import com.owlike.genson.reflect.BeanDescriptorProvider;
import com.owlike.genson.reflect.BeanMutatorAccessorResolver;
import com.owlike.genson.reflect.BeanViewDescriptorProvider;
import com.owlike.genson.reflect.PropertyNameResolver;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.reflect.VisibilityFilter;
import com.owlike.genson.stream.JsonReader;
import com.owlike.genson.stream.JsonWriter;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Genson {
    private static final Genson _default = new Builder().create();
    private final ConcurrentHashMap<Type, Converter<?>> converterCache = new ConcurrentHashMap();
    private final Factory<Converter<?>> converterFactory;
    private final BeanDescriptorProvider beanDescriptorFactory;
    private final Converter<Object> nullConverter;
    private final Map<Class<?>, String> classAliasMap;
    private final Map<String, Class<?>> aliasClassMap;
    private final boolean skipNull;
    private final boolean htmlSafe;
    private final boolean withClassMetadata;

    public Genson() {
        this(Genson._default.converterFactory, Genson._default.beanDescriptorFactory, Genson._default.nullConverter, Genson._default.skipNull, Genson._default.htmlSafe, Genson._default.aliasClassMap, Genson._default.withClassMetadata);
    }

    public Genson(Factory<Converter<?>> converterFactory, BeanDescriptorProvider beanDescProvider, Converter<Object> nullConverter, boolean skipNull, boolean htmlSafe, Map<String, Class<?>> classAliases, boolean withClassMetadata) {
        this.converterFactory = converterFactory;
        this.beanDescriptorFactory = beanDescProvider;
        this.nullConverter = nullConverter;
        this.skipNull = skipNull;
        this.htmlSafe = htmlSafe;
        this.aliasClassMap = classAliases;
        this.withClassMetadata = withClassMetadata;
        this.classAliasMap = new HashMap(classAliases.size());
        for (Map.Entry<String, Class<?>> entry : classAliases.entrySet()) {
            this.classAliasMap.put(entry.getValue(), entry.getKey());
        }
    }

    public <T> Converter<T> provideConverter(Type forType) {
        Converter<?> converter = this.converterCache.get(forType);
        if (converter == null) {
            converter = this.converterFactory.create(forType, this);
            if (converter == null) {
                throw new TransformationRuntimeException("No converter found for type " + forType);
            }
            this.converterCache.put(forType, converter);
        }
        return converter;
    }

    public <T> String serialize(T o) throws TransformationException, IOException {
        JsonWriter writer = new JsonWriter(new StringWriter(), this.skipNull, this.htmlSafe);
        if (o == null) {
            this.nullConverter.serialize(null, writer, null);
        } else {
            this.serialize(o, o.getClass(), writer, new Context(this));
        }
        writer.flush();
        return writer.unwrap().toString();
    }

    public <T> String serialize(T o, GenericType<T> type) throws TransformationException, IOException {
        JsonWriter writer = new JsonWriter(new StringWriter(), this.skipNull, this.htmlSafe);
        if (o == null) {
            this.nullConverter.serialize(null, writer, null);
        } else {
            this.serialize(o, type.getType(), writer, new Context(this));
        }
        writer.flush();
        return writer.unwrap().toString();
    }

    public <T> String serialize(T o, Class<? extends BeanView<?>> ... withViews) throws TransformationException, IOException {
        JsonWriter writer = new JsonWriter(new StringWriter(), this.skipNull, this.htmlSafe);
        if (o == null) {
            this.nullConverter.serialize(null, writer, null);
        } else {
            this.serialize(o, o.getClass(), writer, new Context(this, Arrays.asList(withViews)));
        }
        writer.flush();
        return writer.unwrap().toString();
    }

    public <T> void serialize(T o, ObjectWriter writer, Class<? extends BeanView<?>> ... withViews) throws TransformationException, IOException {
        if (o == null) {
            this.nullConverter.serialize(null, writer, null);
        } else {
            this.serialize(o, o.getClass(), writer, new Context(this, Arrays.asList(withViews)));
        }
        writer.flush();
    }

    public <T> void serialize(T obj, Type type, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
        Converter<T> ser = this.provideConverter(type);
        ser.serialize(obj, writer, ctx);
    }

    public <T> T deserialize(String fromSource, Class<T> toClass) throws TransformationException, IOException {
        return this.deserialize(toClass, new JsonReader(new StringReader(fromSource)), new Context(this));
    }

    public <T> T deserialize(String fromSource, GenericType<T> toType) throws TransformationException, IOException {
        return this.deserialize(toType.getType(), new JsonReader(new StringReader(fromSource)), new Context(this));
    }

    public <T> T deserialize(Reader reader, Type toType) throws TransformationException, IOException {
        return this.deserialize(toType, new JsonReader(reader), new Context(this));
    }

    public <T> T deserialize(String fromSource, Type toType) throws TransformationException, IOException {
        StringReader reader = new StringReader(fromSource);
        return this.deserialize(toType, new JsonReader(reader), new Context(this, null));
    }

    public <T> T deserialize(String fromSource, Type toType, Class<? extends BeanView<?>> ... withViews) throws TransformationException, IOException {
        StringReader reader = new StringReader(fromSource);
        return this.deserialize(toType, new JsonReader(reader), new Context(this, Arrays.asList(withViews)));
    }

    public <T> T deserialize(Type type, Reader reader, Class<? extends BeanView<?>> ... withViews) throws TransformationException, IOException {
        return this.deserialize(type, new JsonReader(reader), new Context(this, Arrays.asList(withViews)));
    }

    public <T> T deserialize(Type type, ObjectReader reader, Context ctx) throws TransformationException, IOException {
        Converter<T> deser = this.provideConverter(type);
        return deser.deserialize(reader, ctx);
    }

    public <T> String aliasFor(Class<T> clazz) {
        String alias = this.classAliasMap.get(clazz);
        if (alias == null) {
            alias = clazz.getName();
            this.classAliasMap.put(clazz, alias);
        }
        return alias;
    }

    public Class<?> classFor(String alias) throws ClassNotFoundException {
        Class<?> clazz = this.aliasClassMap.get(alias);
        if (clazz == null) {
            clazz = Class.forName(alias);
            this.aliasClassMap.put(alias, clazz);
        }
        return clazz;
    }

    public ObjectWriter createWriter(OutputStream os) {
        return new JsonWriter(new OutputStreamWriter(os), this.skipNull, this.htmlSafe);
    }

    public ObjectReader createReader(InputStream is) {
        return new JsonReader(new InputStreamReader(is));
    }

    public ObjectWriter createWriter(Writer writer) {
        return new JsonWriter(writer, this.skipNull, this.htmlSafe);
    }

    public ObjectReader createReader(Reader reader) {
        return new JsonReader(reader);
    }

    public boolean isSkipNull() {
        return this.skipNull;
    }

    public boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public boolean isWithClassMetadata() {
        return this.withClassMetadata;
    }

    public BeanDescriptorProvider getBeanDescriptorFactory() {
        return this.beanDescriptorFactory;
    }

    public Converter<Object> getNullConverter() {
        return this.nullConverter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final Map<Type, Serializer<?>> serializersMap = new HashMap();
        private final Map<Type, Deserializer<?>> deserializersMap = new HashMap();
        private final List<Factory<?>> converterFactories = new ArrayList();
        private boolean skipNull = false;
        private boolean htmlSafe = false;
        private boolean withClassMetadata = false;
        private DateFormat dateFormat = null;
        private boolean throwExcOnNoDebugInfo = false;
        private boolean useGettersAndSetters = true;
        private boolean useFields = true;
        private boolean withBeanViewConverter = false;
        private boolean useRuntimeTypeForSerialization = false;
        private boolean withDebugInfoPropertyNameResolver = false;
        private PropertyNameResolver propertyNameResolver;
        private BeanMutatorAccessorResolver mutatorAccessorResolver;
        private VisibilityFilter propertyFilter;
        private VisibilityFilter methodFilter;
        private VisibilityFilter constructorFilter;
        private BeanDescriptorProvider beanDescriptorProvider;
        private Converter<Object> nullConverter;
        private BeanViewDescriptorProvider beanViewDescriptorProvider;
        private final Map<String, Class<?>> withClassAliases = new HashMap();

        public Builder addAlias(String alias, Class<?> forClass) {
            this.withClassMetadata = true;
            this.withClassAliases.put(alias, forClass);
            return this;
        }

        public Builder withConverters(Converter<?> ... converter) {
            for (Converter<?> c : converter) {
                Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Converter.class, c.getClass()));
                typeOfConverter = TypeUtil.expandType(typeOfConverter, c.getClass());
                this.registerConverter(c, typeOfConverter);
            }
            return this;
        }

        public <T> Builder withConverter(Converter<T> converter, Class<? extends T> type) {
            this.registerConverter(converter, type);
            return this;
        }

        public <T> Builder withConverter(Converter<T> converter, GenericType<? extends T> type) {
            this.registerConverter(converter, type.getType());
            return this;
        }

        private <T> void registerConverter(Converter<T> converter, Type type) {
            if (this.serializersMap.containsKey(type)) {
                throw new IllegalStateException("Can not register converter " + converter.getClass() + ". A custom serializer is already registered for type " + type);
            }
            if (this.deserializersMap.containsKey(type)) {
                throw new IllegalStateException("Can not register converter " + converter.getClass() + ". A custom deserializer is already registered for type " + type);
            }
            this.serializersMap.put(type, converter);
            this.deserializersMap.put(type, converter);
        }

        public Builder withSerializers(Serializer<?> ... serializer) {
            for (Serializer<?> s : serializer) {
                Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Serializer.class, s.getClass()));
                typeOfConverter = TypeUtil.expandType(typeOfConverter, s.getClass());
                this.registerSerializer(s, typeOfConverter);
            }
            return this;
        }

        public <T> Builder withSerializer(Serializer<T> serializer, Class<? extends T> type) {
            this.registerSerializer(serializer, type);
            return this;
        }

        public <T> Builder withSerializer(Serializer<T> serializer, GenericType<? extends T> type) {
            this.registerSerializer(serializer, type.getType());
            return this;
        }

        private <T> void registerSerializer(Serializer<T> serializer, Type type) {
            if (this.serializersMap.containsKey(type)) {
                throw new IllegalStateException("Can not register serializer " + serializer.getClass() + ". A custom serializer is already registered for type " + type);
            }
            this.serializersMap.put(type, serializer);
        }

        public Builder withDeserializers(Deserializer<?> ... deserializer) {
            for (Deserializer<?> d : deserializer) {
                Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Deserializer.class, d.getClass()));
                typeOfConverter = TypeUtil.expandType(typeOfConverter, d.getClass());
                this.registerDeserializer(d, typeOfConverter);
            }
            return this;
        }

        public <T> Builder withDeserializer(Deserializer<T> deserializer, Class<? extends T> type) {
            this.registerDeserializer(deserializer, type);
            return this;
        }

        public <T> Builder withDeserializer(Deserializer<T> deserializer, GenericType<? extends T> type) {
            this.registerDeserializer(deserializer, type.getType());
            return this;
        }

        private <T> void registerDeserializer(Deserializer<T> deserializer, Type type) {
            if (this.deserializersMap.containsKey(type)) {
                throw new IllegalStateException("Can not register deserializer " + deserializer.getClass() + ". A custom deserializer is already registered for type " + type);
            }
            this.deserializersMap.put(type, deserializer);
        }

        public Builder withConverterFactory(Factory<? extends Converter<?>> factory) {
            this.converterFactories.add(factory);
            return this;
        }

        public Builder withSerializerFactory(Factory<? extends Serializer<?>> factory) {
            this.converterFactories.add(factory);
            return this;
        }

        public Builder withDeserializerFactory(Factory<? extends Deserializer<?>> factory) {
            this.converterFactories.add(factory);
            return this;
        }

        public Builder setSkipNull(boolean skipNull) {
            this.skipNull = skipNull;
            return this;
        }

        public boolean isSkipNull() {
            return this.skipNull;
        }

        public Builder setHtmlSafe(boolean htmlSafe) {
            this.htmlSafe = htmlSafe;
            return this;
        }

        public boolean isHtmlSafe() {
            return this.htmlSafe;
        }

        public Builder set(BeanMutatorAccessorResolver resolver) {
            this.mutatorAccessorResolver = resolver;
            return this;
        }

        public Builder set(PropertyNameResolver resolver) {
            this.propertyNameResolver = resolver;
            return this;
        }

        public Builder with(PropertyNameResolver ... resolvers) {
            if (this.propertyNameResolver == null) {
                this.propertyNameResolver = this.createPropertyNameResolver();
            }
            if (!(this.propertyNameResolver instanceof PropertyNameResolver.CompositePropertyNameResolver)) {
                throw new IllegalStateException("You can not add multiple resolvers if the base resolver is not of type " + PropertyNameResolver.CompositePropertyNameResolver.class.getName());
            }
            ((PropertyNameResolver.CompositePropertyNameResolver)this.propertyNameResolver).add(resolvers);
            return this;
        }

        public boolean isWithClassMetadata() {
            return this.withClassMetadata;
        }

        public Builder setWithClassMetadata(boolean withClassMetadata) {
            this.withClassMetadata = withClassMetadata;
            return this;
        }

        public DateFormat getDateFormat() {
            return this.dateFormat;
        }

        public Builder setDateFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public boolean isThrowExceptionOnNoDebugInfo() {
            return this.throwExcOnNoDebugInfo;
        }

        public Builder setThrowExceptionIfNoDebugInfo(boolean throwExcOnNoDebugInfo) {
            this.throwExcOnNoDebugInfo = throwExcOnNoDebugInfo;
            return this;
        }

        public boolean isUseGettersAndSetters() {
            return this.useGettersAndSetters;
        }

        public Builder setUseGettersAndSetters(boolean useGettersAndSetters) {
            this.useGettersAndSetters = useGettersAndSetters;
            return this;
        }

        public boolean isUseFields() {
            return this.useFields;
        }

        public Builder setUseFields(boolean useFields) {
            this.useFields = useFields;
            return this;
        }

        public boolean isWithBeanViewConverter() {
            return this.withBeanViewConverter;
        }

        public Builder setWithBeanViewConverter(boolean withBeanViewConverter) {
            this.withBeanViewConverter = withBeanViewConverter;
            return this;
        }

        public boolean isUseRuntimeTypeForSerialization() {
            return this.useRuntimeTypeForSerialization;
        }

        public Builder setUseRuntimeTypeForSerialization(boolean useRuntimeTypeForSerialization) {
            this.useRuntimeTypeForSerialization = useRuntimeTypeForSerialization;
            return this;
        }

        public boolean isWithDebugInfoPropertyNameResolver() {
            return this.withDebugInfoPropertyNameResolver;
        }

        public Builder setWithDebugInfoPropertyNameResolver(boolean withDebugInfoPropertyNameResolver) {
            this.withDebugInfoPropertyNameResolver = withDebugInfoPropertyNameResolver;
            return this;
        }

        public Converter<Object> getNullConverter() {
            return this.nullConverter;
        }

        public Builder setNullConverter(Converter<Object> nullConverter) {
            this.nullConverter = nullConverter;
            return this;
        }

        public VisibilityFilter getFieldFilter() {
            return this.propertyFilter;
        }

        public Builder setFieldFilter(VisibilityFilter propertyFilter) {
            this.propertyFilter = propertyFilter;
            return this;
        }

        public VisibilityFilter getMethodFilter() {
            return this.methodFilter;
        }

        public Builder setMethodFilter(VisibilityFilter methodFilter) {
            this.methodFilter = methodFilter;
            return this;
        }

        public VisibilityFilter getConstructorFilter() {
            return this.constructorFilter;
        }

        public Builder setConstructorFilter(VisibilityFilter constructorFilter) {
            this.constructorFilter = constructorFilter;
            return this;
        }

        public Map<Type, Serializer<?>> getSerializersMap() {
            return Collections.unmodifiableMap(this.serializersMap);
        }

        public Map<Type, Deserializer<?>> getDeserializersMap() {
            return Collections.unmodifiableMap(this.deserializersMap);
        }

        public Genson create() {
            if (this.nullConverter == null) {
                this.nullConverter = new NullConverter();
            }
            if (this.propertyNameResolver == null) {
                this.propertyNameResolver = this.createPropertyNameResolver();
            }
            if (this.mutatorAccessorResolver == null) {
                this.mutatorAccessorResolver = this.createBeanMutatorAccessorResolver();
            }
            this.beanDescriptorProvider = this.createBeanDescriptorProvider();
            if (this.withBeanViewConverter) {
                this.beanViewDescriptorProvider = new BeanViewDescriptorProvider(new BeanViewDescriptorProvider.BeanViewMutatorAccessorResolver(), this.getPropertyNameResolver());
            }
            List<Converter<?>> converters = this.getDefaultConverters();
            this.addDefaultSerializers(converters);
            this.addDefaultDeserializers(converters);
            this.addDefaultSerializers(this.getDefaultSerializers());
            this.addDefaultDeserializers(this.getDefaultDeserializers());
            ArrayList convFactories = new ArrayList();
            this.addDefaultConverterFactories(convFactories);
            this.converterFactories.addAll(convFactories);
            ArrayList serializerFactories = new ArrayList();
            this.addDefaultSerializerFactories(serializerFactories);
            this.converterFactories.addAll(serializerFactories);
            ArrayList deserializerFactories = new ArrayList();
            this.addDefaultDeserializerFactories(deserializerFactories);
            this.converterFactories.addAll(deserializerFactories);
            return this.create(this.createConverterFactory(), this.withClassAliases);
        }

        private void addDefaultSerializers(List<? extends Serializer<?>> serializers) {
            if (serializers != null) {
                for (Serializer<?> serializer : serializers) {
                    Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Serializer.class, serializer.getClass()));
                    if (this.serializersMap.containsKey(typeOfConverter = TypeUtil.expandType(typeOfConverter, serializer.getClass()))) continue;
                    this.serializersMap.put(typeOfConverter, serializer);
                }
            }
        }

        private void addDefaultDeserializers(List<? extends Deserializer<?>> deserializers) {
            if (deserializers != null) {
                for (Deserializer<?> deserializer : deserializers) {
                    Type typeOfConverter = TypeUtil.typeOf(0, TypeUtil.lookupGenericType(Deserializer.class, deserializer.getClass()));
                    if (this.deserializersMap.containsKey(typeOfConverter = TypeUtil.expandType(typeOfConverter, deserializer.getClass()))) continue;
                    this.deserializersMap.put(typeOfConverter, deserializer);
                }
            }
        }

        protected Genson create(Factory<Converter<?>> converterFactory, Map<String, Class<?>> classAliases) {
            return new Genson(converterFactory, this.getBeanDescriptorProvider(), this.getNullConverter(), this.isSkipNull(), this.isHtmlSafe(), classAliases, this.isWithClassMetadata());
        }

        protected Factory<Converter<?>> createConverterFactory() {
            CircularClassReferenceConverterFactory chainHead = new CircularClassReferenceConverterFactory();
            ChainedFactory chainTail = chainHead;
            chainTail = chainTail.withNext(new NullConverter.NullConverterFactory()).withNext(new ClassMetadataConverter.ClassMetadataConverterFactory());
            if (this.isUseRuntimeTypeForSerialization()) {
                chainTail = chainTail.withNext(RuntimeTypeConverter.runtimeTypeConverterFactory);
            }
            if (this.isWithBeanViewConverter()) {
                chainTail = chainTail.withNext(new BeanViewConverter.BeanViewConverterFactory(this.getBeanViewDescriptorProvider()));
            }
            chainTail.withNext(new BasicConvertersFactory(this.getSerializersMap(), this.getDeserializersMap(), this.getFactories(), this.getBeanDescriptorProvider()));
            return chainHead;
        }

        protected BeanMutatorAccessorResolver createBeanMutatorAccessorResolver() {
            VisibilityFilter ctrFilter;
            VisibilityFilter methodFilter;
            VisibilityFilter propFilter = this.getFieldFilter();
            if (propFilter == null) {
                propFilter = VisibilityFilter.PACKAGE_PUBLIC;
            }
            if ((methodFilter = this.getFieldFilter()) == null) {
                methodFilter = VisibilityFilter.PACKAGE_PUBLIC;
            }
            if ((ctrFilter = this.getFieldFilter()) == null) {
                ctrFilter = VisibilityFilter.PACKAGE_PUBLIC;
            }
            return new BeanMutatorAccessorResolver.StandardMutaAccessorResolver(propFilter, methodFilter, ctrFilter);
        }

        protected PropertyNameResolver createPropertyNameResolver() {
            ArrayList<PropertyNameResolver> resolvers = new ArrayList<PropertyNameResolver>();
            resolvers.add(new PropertyNameResolver.AnnotationPropertyNameResolver());
            resolvers.add(new PropertyNameResolver.ConventionalBeanPropertyNameResolver());
            if (this.isWithDebugInfoPropertyNameResolver()) {
                resolvers.add(new ASMCreatorParameterNameResolver(this.isThrowExceptionOnNoDebugInfo()));
            }
            return new PropertyNameResolver.CompositePropertyNameResolver(resolvers);
        }

        protected List<Converter<?>> getDefaultConverters() {
            ArrayList converters = new ArrayList();
            converters.add(DefaultConverters.StringConverter.instance);
            converters.add(DefaultConverters.BooleanConverter.instance);
            converters.add(DefaultConverters.IntegerConverter.instance);
            converters.add(DefaultConverters.DoubleConverter.instance);
            converters.add(DefaultConverters.LongConverter.instance);
            converters.add(DefaultConverters.NumberConverter.instance);
            converters.add(new DefaultConverters.DateConverter(this.getDateFormat()));
            converters.add(DefaultConverters.URLConverter.instance);
            return converters;
        }

        protected void addDefaultConverterFactories(List<Factory<? extends Converter<?>>> factories) {
            factories.add(DefaultConverters.ArrayConverterFactory.instance);
            factories.add(DefaultConverters.CollectionConverterFactory.instance);
            factories.add(DefaultConverters.MapConverterFactory.instance);
            factories.add(DefaultConverters.EnumConverterFactory.instance);
            factories.add(DefaultConverters.PrimitiveConverterFactory.instance);
            factories.add(DefaultConverters.UntypedConverterFactory.instance);
        }

        protected List<Serializer<?>> getDefaultSerializers() {
            return null;
        }

        protected void addDefaultSerializerFactories(List<Factory<? extends Serializer<?>>> serializerFactories) {
        }

        protected List<Deserializer<?>> getDefaultDeserializers() {
            return null;
        }

        protected void addDefaultDeserializerFactories(List<Factory<? extends Deserializer<?>>> deserializerFactories) {
        }

        protected BeanDescriptorProvider createBeanDescriptorProvider() {
            return new BaseBeanDescriptorProvider(this.getMutatorAccessorResolver(), this.getPropertyNameResolver(), this.isUseGettersAndSetters(), this.isUseFields(), true);
        }

        protected final PropertyNameResolver getPropertyNameResolver() {
            return this.propertyNameResolver;
        }

        protected final BeanMutatorAccessorResolver getMutatorAccessorResolver() {
            return this.mutatorAccessorResolver;
        }

        protected final BeanDescriptorProvider getBeanDescriptorProvider() {
            return this.beanDescriptorProvider;
        }

        protected final BeanViewDescriptorProvider getBeanViewDescriptorProvider() {
            return this.beanViewDescriptorProvider;
        }

        public final List<Factory<?>> getFactories() {
            return this.converterFactories;
        }
    }
}

