/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.convert;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Deserializer;
import com.owlike.genson.Factory;
import com.owlike.genson.Genson;
import com.owlike.genson.Operations;
import com.owlike.genson.Serializer;
import com.owlike.genson.TransformationException;
import com.owlike.genson.Wrapper;
import com.owlike.genson.reflect.BeanDescriptorProvider;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicConvertersFactory
implements Factory<Converter<?>> {
    private final Map<Type, Serializer<?>> serializersMap;
    private final Map<Type, Deserializer<?>> deserializersMap;
    private final List<Factory<?>> factories;
    private final BeanDescriptorProvider beanDescriptorProvider;

    public BasicConvertersFactory(Map<Type, Serializer<?>> serializersMap, Map<Type, Deserializer<?>> deserializersMap, List<Factory<?>> factories, BeanDescriptorProvider beanDescriptorProvider) {
        this.serializersMap = serializersMap;
        this.deserializersMap = deserializersMap;
        this.factories = factories;
        this.beanDescriptorProvider = beanDescriptorProvider;
    }

    @Override
    public Converter<?> create(Type type, Genson genson) {
        DelegatedConverter converter = null;
        Serializer<?> serializer = this.provide(Serializer.class, type, this.serializersMap, genson);
        Deserializer<?> deserializer = this.provide(Deserializer.class, type, this.deserializersMap, genson);
        converter = serializer instanceof Converter && deserializer instanceof Converter ? (DelegatedConverter)deserializer : new DelegatedConverter(serializer, deserializer);
        return converter;
    }

    protected <T> T provide(Class<T> forClass, Type withParameterType, Map<Type, ? extends T> fromTypeMap, Genson genson) {
        if (fromTypeMap.containsKey(withParameterType)) {
            return fromTypeMap.get(withParameterType);
        }
        Class<?> wrappedParameterType = withParameterType;
        if (withParameterType instanceof Class && ((Class)withParameterType).isPrimitive()) {
            wrappedParameterType = TypeUtil.wrap(withParameterType);
        }
        for (Factory<?> factory : this.factories) {
            Object object = null;
            Type factoryType = TypeUtil.lookupGenericType(Factory.class, factory.getClass());
            factoryType = TypeUtil.expandType(factoryType, factory.getClass());
            factoryType = TypeUtil.typeOf(0, factoryType);
            Type factoryParameter = TypeUtil.typeOf(0, factoryType);
            if (!forClass.isAssignableFrom(TypeUtil.getRawClass(factoryType)) || !TypeUtil.match(wrappedParameterType, factoryParameter, false)) continue;
            Object obj = factory.create(withParameterType, genson);
            object = obj;
            if (obj == null) continue;
            return forClass.cast(object);
        }
        return (T)this.beanDescriptorProvider.provide(TypeUtil.getRawClass(withParameterType), genson);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DelegatedConverter<T>
    extends Wrapper<Converter<T>>
    implements Converter<T> {
        private final Serializer<T> serializer;
        private final Deserializer<T> deserializer;

        public DelegatedConverter(Serializer<T> serializer, Deserializer<T> deserializer) {
            this.serializer = serializer;
            this.deserializer = deserializer;
        }

        @Override
        public void serialize(T obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
            this.serializer.serialize(obj, writer, ctx);
        }

        @Override
        public T deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
            return this.deserializer.deserialize(reader, ctx);
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<A> aClass) {
            A a = null;
            if (this.serializer != null) {
                a = DelegatedConverter.toAnnotatedElement(this.serializer).getAnnotation(aClass);
            }
            if (this.deserializer != null && a == null) {
                a = DelegatedConverter.toAnnotatedElement(this.deserializer).getAnnotation(aClass);
            }
            return a;
        }

        @Override
        public Annotation[] getAnnotations() {
            if (this.serializer != null && this.deserializer != null) {
                return Operations.union(Annotation[].class, DelegatedConverter.toAnnotatedElement(this.serializer).getAnnotations(), DelegatedConverter.toAnnotatedElement(this.deserializer).getAnnotations());
            }
            if (this.serializer != null) {
                return DelegatedConverter.toAnnotatedElement(this.serializer).getAnnotations();
            }
            if (this.deserializer != null) {
                return DelegatedConverter.toAnnotatedElement(this.deserializer).getAnnotations();
            }
            return new Annotation[0];
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            if (this.serializer != null && this.deserializer != null) {
                return Operations.union(Annotation[].class, DelegatedConverter.toAnnotatedElement(this.serializer).getDeclaredAnnotations(), DelegatedConverter.toAnnotatedElement(this.deserializer).getDeclaredAnnotations());
            }
            if (this.serializer != null) {
                return DelegatedConverter.toAnnotatedElement(this.serializer).getDeclaredAnnotations();
            }
            if (this.deserializer != null) {
                return DelegatedConverter.toAnnotatedElement(this.deserializer).getDeclaredAnnotations();
            }
            return new Annotation[0];
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            if (this.serializer != null) {
                return DelegatedConverter.toAnnotatedElement(this.serializer).isAnnotationPresent(annotationClass);
            }
            if (this.deserializer != null) {
                return DelegatedConverter.toAnnotatedElement(this.deserializer).isAnnotationPresent(annotationClass);
            }
            return false;
        }
    }
}

