/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.TransformationRuntimeException;
import com.owlike.genson.Trilean;
import com.owlike.genson.annotation.Creator;
import com.owlike.genson.annotation.JsonIgnore;
import com.owlike.genson.annotation.JsonProperty;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.reflect.VisibilityFilter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface BeanMutatorAccessorResolver {
    public Trilean isCreator(Constructor<?> var1, Class<?> var2);

    public Trilean isCreator(Method var1, Class<?> var2);

    public Trilean isAccessor(Field var1, Class<?> var2);

    public Trilean isAccessor(Method var1, Class<?> var2);

    public Trilean isMutator(Field var1, Class<?> var2);

    public Trilean isMutator(Method var1, Class<?> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StandardMutaAccessorResolver
    implements BeanMutatorAccessorResolver {
        private final VisibilityFilter filedVisibilityFilter;
        private final VisibilityFilter methodVisibilityFilter;
        private final VisibilityFilter creatorVisibilityFilter;

        public StandardMutaAccessorResolver() {
            this(VisibilityFilter.PACKAGE_PUBLIC, VisibilityFilter.PACKAGE_PUBLIC, VisibilityFilter.PACKAGE_PUBLIC);
        }

        public StandardMutaAccessorResolver(VisibilityFilter filedVisibilityFilter, VisibilityFilter methodVisibilityFilter, VisibilityFilter creatorVisibilityFilter) {
            this.filedVisibilityFilter = filedVisibilityFilter;
            this.methodVisibilityFilter = methodVisibilityFilter;
            this.creatorVisibilityFilter = creatorVisibilityFilter;
        }

        @Override
        public Trilean isAccessor(Field field, Class<?> fromClass) {
            if (this.mustIgnore(field, true) || field.getName().startsWith("this$")) {
                return Trilean.FALSE;
            }
            if (this.mustInclude(field, true)) {
                return Trilean.TRUE;
            }
            return Trilean.valueOf(this.filedVisibilityFilter.isVisible(field));
        }

        @Override
        public Trilean isAccessor(Method method, Class<?> fromClass) {
            if (this.mustIgnore(method, true)) {
                return Trilean.FALSE;
            }
            if (this.mustInclude(method, true)) {
                return Trilean.TRUE;
            }
            String name = method.getName();
            int len = name.length();
            if (this.methodVisibilityFilter.isVisible(method) && (len > 3 && name.startsWith("get") || len > 2 && name.startsWith("is") && (TypeUtil.match(TypeUtil.expandType(method.getGenericReturnType(), fromClass), Boolean.class, false) || TypeUtil.match(method.getGenericReturnType(), Boolean.TYPE, false))) && method.getParameterTypes().length == 0) {
                return Trilean.TRUE;
            }
            return Trilean.FALSE;
        }

        @Override
        public Trilean isCreator(Constructor<?> constructor, Class<?> fromClass) {
            if (this.mustIgnore(constructor, false)) {
                return Trilean.FALSE;
            }
            return Trilean.valueOf(this.creatorVisibilityFilter.isVisible(constructor));
        }

        @Override
        public Trilean isCreator(Method method, Class<?> fromClass) {
            if (method.getAnnotation(Creator.class) != null) {
                if (Modifier.isPublic(method.getModifiers()) && Modifier.isStatic(method.getModifiers())) {
                    return Trilean.TRUE;
                }
                throw new TransformationRuntimeException("Method " + method.toGenericString() + " annotated with @Creator must be static!");
            }
            return Trilean.FALSE;
        }

        @Override
        public Trilean isMutator(Field field, Class<?> fromClass) {
            if (this.mustIgnore(field, false) || field.getName().startsWith("this$")) {
                return Trilean.FALSE;
            }
            if (this.mustInclude(field, false)) {
                return Trilean.TRUE;
            }
            int modifier = field.getModifiers();
            return Trilean.valueOf(!Modifier.isTransient(modifier) && !Modifier.isStatic(modifier));
        }

        @Override
        public Trilean isMutator(Method method, Class<?> fromClass) {
            if (this.mustIgnore(method, false)) {
                return Trilean.FALSE;
            }
            if (this.mustInclude(method, false)) {
                return Trilean.TRUE;
            }
            if (this.methodVisibilityFilter.isVisible(method) && method.getName().length() > 3 && method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE) {
                return Trilean.TRUE;
            }
            return Trilean.FALSE;
        }

        protected boolean mustIgnore(AccessibleObject property, boolean forSerialization) {
            JsonIgnore ignore = property.getAnnotation(JsonIgnore.class);
            if (ignore != null) {
                if (forSerialization) {
                    return !ignore.serialize();
                }
                return !ignore.deserialize();
            }
            return false;
        }

        protected boolean mustInclude(AccessibleObject property, boolean forSerialization) {
            JsonProperty prop = property.getAnnotation(JsonProperty.class);
            if (prop != null) {
                if (forSerialization) {
                    return prop.serialize();
                }
                return prop.deserialize();
            }
            return false;
        }
    }
}

