/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.convert;

import com.owlike.genson.BeanView;
import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Genson;
import com.owlike.genson.TransformationException;
import com.owlike.genson.Wrapper;
import com.owlike.genson.annotation.WithoutBeanView;
import com.owlike.genson.convert.ChainedFactory;
import com.owlike.genson.reflect.BeanDescriptor;
import com.owlike.genson.reflect.BeanViewDescriptorProvider;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;

public class BeanViewConverter<T>
extends Wrapper<Converter<T>>
implements Converter<T> {
    private final BeanViewDescriptorProvider provider;
    private final Type type;

    public BeanViewConverter(Type type, BeanViewDescriptorProvider provider, Converter<T> next) {
        super(next);
        this.provider = provider;
        this.type = type;
    }

    protected Class<? extends BeanView<T>> findViewFor(Type type, List<Class<? extends BeanView<?>>> views) {
        for (Class<BeanView<?>> clazz : views) {
            if (TypeUtil.lookupWithGenerics(BeanView.class, type, clazz, false) == null) continue;
            return clazz;
        }
        return null;
    }

    @Override
    public void serialize(T obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
        Class<BeanView<T>> viewClass;
        boolean handled = false;
        List<Class<BeanView<?>>> views = ctx.views();
        if (views != null && views.size() > 0 && (viewClass = this.findViewFor(this.type, views)) != null) {
            BeanDescriptor<T> descriptor = this.provider.provideBeanDescriptor(viewClass, ctx.genson);
            descriptor.serialize(obj, writer, ctx);
            handled = true;
        }
        if (!handled) {
            ((Converter)this.wrapped).serialize(obj, writer, ctx);
        }
    }

    @Override
    public T deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
        Class<BeanView<T>> viewClass;
        if (ctx.hasViews() && (viewClass = this.findViewFor(this.type, ctx.views())) != null) {
            BeanDescriptor descriptor = this.provider.provideBeanDescriptor(viewClass, ctx.genson);
            return descriptor.deserialize(reader, ctx);
        }
        return ((Converter)this.wrapped).deserialize(reader, ctx);
    }

    public static class BeanViewConverterFactory
    extends ChainedFactory {
        private final BeanViewDescriptorProvider provider;

        public BeanViewConverterFactory(BeanViewDescriptorProvider provider) {
            this.provider = provider;
        }

        @Override
        protected Converter<?> create(Type type, Genson genson, Converter<?> nextConverter) {
            if (!Wrapper.toAnnotatedElement(nextConverter).isAnnotationPresent(WithoutBeanView.class)) {
                return new BeanViewConverter(type, this.provider, nextConverter);
            }
            return nextConverter;
        }
    }
}

