/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.convert;

import com.owlike.genson.Context;
import com.owlike.genson.Converter;
import com.owlike.genson.Genson;
import com.owlike.genson.TransformationException;
import com.owlike.genson.Wrapper;
import com.owlike.genson.convert.ChainedFactory;
import com.owlike.genson.reflect.TypeUtil;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ObjectWriter;
import java.io.IOException;
import java.lang.reflect.Type;

public class RuntimeTypeConverter<T>
extends Wrapper<Converter<T>>
implements Converter<T> {
    private final Class<T> tClass;

    public RuntimeTypeConverter(Class<T> tClass, Converter<T> next) {
        super(next);
        this.tClass = tClass;
    }

    @Override
    public void serialize(T obj, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
        if (!this.tClass.equals(obj.getClass())) {
            ctx.genson.serialize(obj, obj.getClass(), writer, ctx);
        } else {
            ((Converter)this.wrapped).serialize(obj, writer, ctx);
        }
    }

    @Override
    public T deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
        return ((Converter)this.wrapped).deserialize(reader, ctx);
    }

    public static class RuntimeTypeConverterFactory
    extends ChainedFactory {
        @Override
        protected Converter<?> create(Type type, Genson genson, Converter<?> nextConverter) {
            if (nextConverter == null) {
                throw new IllegalArgumentException("RuntimeTypeConverter can not be last Converter in the chain.");
            }
            return new RuntimeTypeConverter(TypeUtil.getRawClass(type), nextConverter);
        }
    }
}

