/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.Genson;
import com.owlike.genson.reflect.BeanCreator;
import com.owlike.genson.reflect.BeanDescriptor;
import com.owlike.genson.reflect.BeanDescriptorProvider;
import com.owlike.genson.reflect.PropertyAccessor;
import com.owlike.genson.reflect.PropertyMutator;
import com.owlike.genson.reflect.TypeUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractBeanDescriptorProvider
implements BeanDescriptorProvider {
    protected AbstractBeanDescriptorProvider() {
    }

    @Override
    public BeanDescriptor<?> provide(Type type, Genson genson) {
        Class<?> rawType = TypeUtil.getRawClass(type);
        return this.provideBeanDescriptor(rawType, genson);
    }

    @Override
    public <T> BeanDescriptor<T> provideBeanDescriptor(Class<?> ofClass, Genson genson) {
        LinkedHashMap mutatorsMap = new LinkedHashMap();
        LinkedHashMap accessorsMap = new LinkedHashMap();
        List<BeanCreator<T>> creators = this.provideBeanCreators(ofClass, genson);
        this.provideBeanPropertyAccessors(ofClass, accessorsMap, genson);
        this.provideBeanPropertyMutators(ofClass, mutatorsMap, genson);
        ArrayList accessors = new ArrayList(accessorsMap.size());
        for (Map.Entry entry : accessorsMap.entrySet()) {
            PropertyAccessor<T, ?> accessor = this.checkAndMergeAccessors((String)entry.getKey(), (LinkedList)entry.getValue());
            if (accessor == null) continue;
            accessors.add(accessor);
        }
        HashMap mutators = new HashMap(mutatorsMap.size());
        for (Map.Entry entry : mutatorsMap.entrySet()) {
            PropertyMutator<T, ?> mutator = this.checkAndMergeMutators((String)entry.getKey(), (LinkedList)entry.getValue());
            if (mutator == null) continue;
            mutators.put(mutator.name, mutator);
        }
        this.mergeMutatorsWithCreatorProperties(ofClass, mutators, creators);
        BeanCreator<T> ctr = this.checkAndMerge(ofClass, creators);
        return this.create(ofClass, ctr, accessors, mutators);
    }

    protected <T> BeanDescriptor<T> create(Class<?> ofClass, BeanCreator<T> creator, List<PropertyAccessor<T, ?>> accessors, Map<String, PropertyMutator<T, ?>> mutators) {
        return new BeanDescriptor(ofClass, accessors, mutators, creator);
    }

    protected abstract <T> List<BeanCreator<T>> provideBeanCreators(Class<?> var1, Genson var2);

    protected abstract <T> void provideBeanPropertyMutators(Class<?> var1, Map<String, LinkedList<PropertyMutator<T, ?>>> var2, Genson var3);

    protected abstract <T> void provideBeanPropertyAccessors(Class<?> var1, Map<String, LinkedList<PropertyAccessor<T, ?>>> var2, Genson var3);

    protected abstract <T> BeanCreator<T> checkAndMerge(Class<?> var1, List<BeanCreator<T>> var2);

    protected abstract <T> PropertyMutator<T, ?> checkAndMergeMutators(String var1, LinkedList<PropertyMutator<T, ?>> var2);

    protected abstract <T> void mergeMutatorsWithCreatorProperties(Class<?> var1, Map<String, PropertyMutator<T, ?>> var2, List<BeanCreator<T>> var3);

    protected abstract <T> PropertyAccessor<T, ?> checkAndMergeAccessors(String var1, LinkedList<PropertyAccessor<T, ?>> var2);
}

