/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.Deserializer;
import com.owlike.genson.TransformationException;
import com.owlike.genson.Wrapper;
import com.owlike.genson.reflect.PropertyMutator;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BeanCreator<T>
extends Wrapper<AnnotatedElement>
implements Comparable<BeanCreator<T>> {
    protected final Class<T> ofClass;
    protected final Map<String, BeanCreatorProperty<T, ?>> parameters;

    public BeanCreator(Class<T> ofClass, String[] parameterNames, Type[] types, Annotation[][] anns, Deserializer<?>[] propertiesDeserializers) {
        this.ofClass = ofClass;
        this.parameters = new HashMap(parameterNames.length);
        for (int i = 0; i < parameterNames.length; ++i) {
            this.parameters.put(parameterNames[i], new BeanCreatorProperty(parameterNames[i], types[i], i, anns[i], ofClass, this, propertiesDeserializers[i]));
        }
    }

    public int contains(List<String> properties) {
        int cnt = 0;
        for (String prop : properties) {
            if (!this.parameters.containsKey(prop)) continue;
            ++cnt;
        }
        return cnt;
    }

    @Override
    public int compareTo(BeanCreator<T> o) {
        int comp = o.priority() - this.priority();
        return comp != 0 ? comp : this.parameters.size() - o.parameters.size();
    }

    public abstract T create(Object ... var1) throws TransformationException;

    protected abstract String signature();

    public abstract int priority();

    protected TransformationException couldNotCreate(Exception e) {
        return new TransformationException("Could not create bean of type " + this.ofClass.getName() + " using creator " + this.signature(), e);
    }

    public static class BeanCreatorProperty<T, P>
    extends PropertyMutator<T, P> {
        protected final int index;
        protected final Annotation[] annotations;
        protected final BeanCreator<T> creator;
        protected final boolean doThrowMutateException;

        protected BeanCreatorProperty(String name, Type type, int index, Annotation[] annotations, Class<T> declaringClass, BeanCreator<T> creator, Deserializer<P> propertyDeserializer) {
            this(name, type, index, annotations, declaringClass, creator, propertyDeserializer, false);
        }

        protected BeanCreatorProperty(String name, Type type, int index, Annotation[] annotations, Class<T> declaringClass, BeanCreator<T> creator, Deserializer<P> propertyDeserializer, boolean doThrowMutateException) {
            super(name, type, declaringClass, propertyDeserializer);
            this.index = index;
            this.annotations = annotations;
            this.creator = creator;
            this.doThrowMutateException = doThrowMutateException;
        }

        public int getIndex() {
            return this.index;
        }

        public Annotation[] getAnnotations() {
            return this.annotations;
        }

        @Override
        public int priority() {
            return -1000;
        }

        @Override
        public String signature() {
            return this.type.toString() + ' ' + this.name + " from " + this.creator.signature();
        }

        @Override
        public void mutate(T target, P value) {
            if (this.doThrowMutateException) {
                throw new IllegalStateException("Method mutate should not be called on a mutator of type " + this.getClass().getName() + ", this property exists only as constructor parameter!");
            }
        }
    }

    public static class MethodBeanCreator<T>
    extends BeanCreator<T> {
        protected final Method _creator;

        public MethodBeanCreator(Method method, String[] parameterNames, Deserializer<?>[] propertiesDeserializers) {
            super(method.getReturnType(), parameterNames, method.getGenericParameterTypes(), method.getParameterAnnotations(), propertiesDeserializers);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalStateException("Only static methods can be used as creators!");
            }
            this._creator = method;
            if (!this._creator.isAccessible()) {
                this._creator.setAccessible(true);
            }
            this.decorate(this._creator);
        }

        @Override
        public T create(Object ... args) throws TransformationException {
            try {
                return this.ofClass.cast(this._creator.invoke(null, args));
            }
            catch (IllegalArgumentException e) {
                throw this.couldNotCreate(e);
            }
            catch (IllegalAccessException e) {
                throw this.couldNotCreate(e);
            }
            catch (InvocationTargetException e) {
                throw this.couldNotCreate(e);
            }
        }

        @Override
        protected String signature() {
            return this._creator.toGenericString();
        }

        @Override
        public int priority() {
            return 100;
        }
    }

    public static class ConstructorBeanCreator<T>
    extends BeanCreator<T> {
        protected final Constructor<T> constructor;

        public ConstructorBeanCreator(Class<T> ofClass, Constructor<T> constructor, String[] parameterNames, Deserializer<?>[] propertiesDeserializers) {
            super(ofClass, parameterNames, constructor.getGenericParameterTypes(), constructor.getParameterAnnotations(), propertiesDeserializers);
            this.constructor = constructor;
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            this.decorate(constructor);
        }

        @Override
        public T create(Object ... args) throws TransformationException {
            try {
                return this.constructor.newInstance(args);
            }
            catch (IllegalArgumentException e) {
                throw this.couldNotCreate(e);
            }
            catch (InstantiationException e) {
                throw this.couldNotCreate(e);
            }
            catch (IllegalAccessException e) {
                throw this.couldNotCreate(e);
            }
            catch (InvocationTargetException e) {
                throw this.couldNotCreate(e);
            }
        }

        @Override
        protected String signature() {
            return this.constructor.toGenericString();
        }

        @Override
        public int priority() {
            return 50;
        }
    }
}

