/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.Operations;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TypeUtil {
    private static final Map<Class<?>, Class<?>> _wrappedPrimitives = new HashMap();
    private static final Map<TypeAndRootClassKey, Type> _cache;

    public static final Class<?> wrap(Class<?> clazz) {
        Class<?> wrappedClass = _wrappedPrimitives.get(clazz);
        return wrappedClass == null ? clazz : wrappedClass;
    }

    public static final Type expandType(Type type, Class<?> rootClass) {
        if (type instanceof ExpandedType || type instanceof Class) {
            return type;
        }
        TypeAndRootClassKey key = new TypeAndRootClassKey(type, rootClass);
        Type expandedType = _cache.get(key);
        if (expandedType == null) {
            if (type instanceof ParameterizedType) {
                ParameterizedType pType = (ParameterizedType)type;
                Type[] args = pType.getActualTypeArguments();
                int len = args.length;
                Type[] expandedArgs = new Type[len];
                for (int i = 0; i < len; ++i) {
                    expandedArgs[i] = TypeUtil.expandType(args[i], rootClass);
                }
                expandedType = new ExpandedParameterizedType(pType, rootClass, expandedArgs);
            } else if (type instanceof TypeVariable) {
                TypeVariable tvType = (TypeVariable)type;
                expandedType = TypeUtil.resolveTypeVariable(tvType, rootClass);
                if (type == expandedType) {
                    expandedType = TypeUtil.expandType(tvType.getBounds()[0], rootClass);
                }
            } else if (type instanceof GenericArrayType) {
                GenericArrayType genArrType = (GenericArrayType)type;
                Object cType = TypeUtil.expandType(genArrType.getGenericComponentType(), rootClass);
                if (genArrType.getGenericComponentType() == cType) {
                    cType = Object.class;
                }
                expandedType = new ExpandedGenericArrayType(genArrType, (Type)cType, rootClass);
            } else if (type instanceof WildcardType) {
                WildcardType wType = (WildcardType)type;
                Type[] lowerBounds = new Type[wType.getLowerBounds().length];
                Type[] upperBounds = new Type[wType.getUpperBounds().length];
                int i = 0;
                for (Type bound : wType.getLowerBounds()) {
                    lowerBounds[i++] = TypeUtil.expandType(bound, rootClass);
                }
                i = 0;
                for (Type bound : wType.getUpperBounds()) {
                    upperBounds[i++] = TypeUtil.expandType(bound, rootClass);
                }
                expandedType = new ExpandedWildcardType(wType, rootClass, lowerBounds, upperBounds);
            } else {
                throw new IllegalArgumentException("Type " + type + " not supported for expansion!");
            }
            _cache.put(key, expandedType);
        }
        return expandedType;
    }

    public static final Type lookupGenericType(Class<?> ofClass, Class<?> inClass) {
        Class<?> superClass;
        if (ofClass == null || inClass == null || !ofClass.isAssignableFrom(inClass)) {
            return null;
        }
        if (ofClass.equals(inClass)) {
            return inClass;
        }
        if (ofClass.isInterface()) {
            Class<?>[] interfaces = inClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (ofClass.equals(interfaces[i])) {
                    return inClass.getGenericInterfaces()[i];
                }
                Type superType = TypeUtil.lookupGenericType(ofClass, interfaces[i]);
                if (superType == null) continue;
                return superType;
            }
        }
        if (ofClass.equals(superClass = inClass.getSuperclass())) {
            return inClass.getGenericSuperclass();
        }
        return TypeUtil.lookupGenericType(ofClass, inClass.getSuperclass());
    }

    public static final Class<?> getRawClass(Type type) {
        return TypeUtil.getRawClass(type, null);
    }

    public static final Class<?> getRawClass(Type type, Class<?> inClass) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return (Class)pType.getRawType();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Class<?> c = TypeUtil.getRawClass(TypeUtil.expand(genericArrayType.getGenericComponentType(), inClass));
            return Array.newInstance(c, 0).getClass();
        }
        return TypeUtil.getRawClass(TypeUtil.expand(type, inClass), inClass);
    }

    public static final Type getCollectionType(Type type) {
        return TypeUtil.getCollectionType(type, null);
    }

    public static final Type getCollectionType(Type type, Class<?> inClass) {
        if (type instanceof GenericArrayType) {
            return TypeUtil.expand(((GenericArrayType)type).getGenericComponentType(), inClass);
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return clazz.getComponentType();
            }
            TypeVariable<Class<T>>[] tvs = clazz.getTypeParameters();
            if (tvs.length > 0) {
                return TypeUtil.expand(tvs[0], inClass);
            }
            Type collectionType = TypeUtil.lookupGenericType(Collection.class, (Class)type);
            if (collectionType != null) {
                return TypeUtil.typeOf(0, collectionType);
            }
        } else {
            return TypeUtil.expand(TypeUtil.typeOf(0, type), inClass);
        }
        throw new IllegalArgumentException("Could not extract parametrized type, are you sure it is a Collection or an Array?");
    }

    /*
     * Unable to fully structure code
     */
    public static final Type expand(Type type, Class<?> inClass) {
        expandedType = null;
        if (type instanceof TypeVariable) {
            try {
                tvType = (TypeVariable)type;
                if (inClass == null) {
                    inClass = (Class)tvType.getGenericDeclaration();
                }
                if (!type.equals(expandedType = TypeUtil.resolveTypeVariable(tvType, inClass))) ** GOTO lbl17
                expandedType = tvType.getBounds()[0];
            }
            catch (ClassCastException cce) {
                throw new UnsupportedOperationException();
            }
        } else if (type instanceof WildcardType) {
            wType = (WildcardType)type;
            expandedType = wType.getUpperBounds().length > 0 ? TypeUtil.expand(wType.getUpperBounds()[0], inClass) : Object.class;
        } else {
            return type;
        }
lbl17:
        // 3 sources

        return expandedType == null || type.equals(expandedType) != false ? Object.class : expandedType;
    }

    public static final Type resolveTypeVariable(TypeVariable<? extends Class<?>> type, Class<?> inClass) {
        return TypeUtil.resolveTypeVariable(type, type.getGenericDeclaration(), inClass);
    }

    private static final Type resolveTypeVariable(TypeVariable<?> type, Class<?> declaringClass, Class<?> inClass) {
        if (inClass == null) {
            return null;
        }
        Class<?> superClass = null;
        Type resolvedType = null;
        Type genericSuperClass = null;
        if (!declaringClass.equals(inClass)) {
            if (declaringClass.isInterface()) {
                Class<?>[] interfaces = inClass.getInterfaces();
                for (int i = 0; i < interfaces.length && resolvedType == null; ++i) {
                    superClass = interfaces[i];
                    resolvedType = TypeUtil.resolveTypeVariable(type, declaringClass, superClass);
                    genericSuperClass = inClass.getGenericInterfaces()[i];
                }
            }
            if (resolvedType == null) {
                superClass = inClass.getSuperclass();
                resolvedType = TypeUtil.resolveTypeVariable(type, declaringClass, superClass);
                genericSuperClass = inClass.getGenericSuperclass();
            }
        } else {
            resolvedType = type;
            genericSuperClass = superClass = inClass;
        }
        if (resolvedType != null && resolvedType instanceof TypeVariable) {
            int positionInClass;
            type = resolvedType;
            TypeVariable<Class<?>>[] parameters = superClass.getTypeParameters();
            for (positionInClass = 0; positionInClass < parameters.length && !type.equals(parameters[positionInClass]); ++positionInClass) {
            }
            if (positionInClass < parameters.length && genericSuperClass instanceof ParameterizedType) {
                ParameterizedType pGenericType = (ParameterizedType)genericSuperClass;
                Type[] args = pGenericType.getActualTypeArguments();
                return positionInClass < args.length ? args[positionInClass] : null;
            }
        }
        return resolvedType;
    }

    public static final Type lookupWithGenerics(Class<?> clazz, Type parameter, Class<?> oClazz, boolean strictMatch) {
        if (oClazz == null) {
            return null;
        }
        Type type = TypeUtil.lookupGenericType(clazz, oClazz);
        if (type != null && (type = TypeUtil.expandType(type, oClazz)) instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return TypeUtil.match(parameter, pType.getActualTypeArguments()[0], strictMatch) ? type : null;
        }
        return null;
    }

    public static final boolean match(Type type, Type oType, boolean strictMatch) {
        Class typeCtx = type instanceof Class ? (Class)type : null;
        Class OTypeCtx = oType instanceof Class ? (Class)oType : null;
        return TypeUtil.match(type, typeCtx, oType, OTypeCtx, strictMatch);
    }

    public static final boolean match(Type type, Class<?> typeCtx, Type oType, Class<?> oTypeCtx, boolean strictMatch) {
        boolean match;
        if (type == null || oType == null) {
            return type == null && oType == null;
        }
        Class<?> clazz = TypeUtil.getRawClass(type, typeCtx);
        Class<?> oClazz = TypeUtil.getRawClass(oType, oTypeCtx);
        boolean bl = match = strictMatch ? oClazz.equals(clazz) : oClazz.isAssignableFrom(clazz);
        if (clazz.isArray() && !oClazz.isArray()) {
            return match;
        }
        Type[] types = TypeUtil.getTypes(TypeUtil.expand(type, typeCtx));
        Type[] oTypes = TypeUtil.getTypes(TypeUtil.expand(oType, oTypeCtx));
        match = match && (types.length == oTypes.length || types.length == 0);
        for (int i = 0; i < types.length && match; ++i) {
            match = TypeUtil.match(types[i], typeCtx, oTypes[i], oTypeCtx, strictMatch);
        }
        return match;
    }

    private static final Type[] getTypes(Type type) {
        if (type instanceof Class) {
            Class tClass = (Class)type;
            if (tClass.isArray()) {
                return new Type[]{tClass.getComponentType()};
            }
            return ((Class)type).getTypeParameters();
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        if (type instanceof GenericArrayType) {
            return new Type[]{((GenericArrayType)type).getGenericComponentType()};
        }
        if (type instanceof WildcardType) {
            return Operations.union(Type[].class, ((WildcardType)type).getUpperBounds(), ((WildcardType)type).getLowerBounds());
        }
        if (type instanceof TypeVariable) {
            Type[] typeArray;
            TypeVariable tvType = (TypeVariable)type;
            Type resolvedType = TypeUtil.resolveTypeVariable(tvType, (Class)tvType.getGenericDeclaration());
            if (tvType.equals(resolvedType)) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = resolvedType;
            } else {
                typeArray = tvType.getBounds();
            }
            return typeArray;
        }
        return new Type[0];
    }

    public static final Type typeOf(int parameterIdx, Type fromType) {
        if (fromType instanceof Class) {
            Class tClass = (Class)fromType;
            TypeVariable<Class<T>>[] tvs = tClass.getTypeParameters();
            if (tvs.length > parameterIdx) {
                return tvs[parameterIdx];
            }
        } else if (fromType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)fromType;
            Type[] ts = pType.getActualTypeArguments();
            if (ts.length > parameterIdx) {
                return ts[parameterIdx];
            }
        } else {
            throw new IllegalArgumentException("Type " + fromType + " not supported!");
        }
        return null;
    }

    public static ParameterizedType createParameterizedType(Type ofRawType, Type inOwnerType, Type ... withActualTypeArguments) {
        return new ParameterizedTypeImpl(withActualTypeArguments, inOwnerType, ofRawType);
    }

    static {
        _wrappedPrimitives.put(Integer.TYPE, Integer.class);
        _wrappedPrimitives.put(Double.TYPE, Double.class);
        _wrappedPrimitives.put(Long.TYPE, Long.class);
        _wrappedPrimitives.put(Float.TYPE, Float.class);
        _wrappedPrimitives.put(Short.TYPE, Short.class);
        _wrappedPrimitives.put(Boolean.TYPE, Boolean.class);
        _wrappedPrimitives.put(Character.TYPE, Character.class);
        _wrappedPrimitives.put(Byte.TYPE, Byte.class);
        _wrappedPrimitives.put(Void.TYPE, Void.class);
        _cache = new ConcurrentHashMap<TypeAndRootClassKey, Type>(32);
    }

    static class 1 {
    }

    private static final class TypeAndRootClassKey {
        private final Type type;
        private final Class<?> rootClass;
        private int _hash;

        public TypeAndRootClassKey(Type type, Class<?> rootClass) {
            if (type == null || rootClass == null) {
                throw new IllegalArgumentException("type and rootClass must be not null!");
            }
            this.type = type;
            this.rootClass = rootClass;
            this._hash = 31 + rootClass.hashCode();
            this._hash = 31 * this._hash + type.hashCode();
        }

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TypeAndRootClassKey)) {
                return false;
            }
            TypeAndRootClassKey other = (TypeAndRootClassKey)obj;
            return this.rootClass.equals(other.rootClass) && this.type.equals(other.type);
        }
    }

    private static final class ExpandedWildcardType
    extends ExpandedType<WildcardType>
    implements WildcardType {
        private final Type[] lowerBounds;
        private final Type[] upperBounds;

        public ExpandedWildcardType(WildcardType originalType, Class<?> rootClass, Type[] lowerBounds, Type[] upperBounds) {
            super(originalType, rootClass, null);
            if (lowerBounds == null || upperBounds == null) {
                throw new IllegalArgumentException("Null arg not allowed!");
            }
            this.lowerBounds = lowerBounds;
            this.upperBounds = upperBounds;
        }

        @Override
        public Type[] getLowerBounds() {
            return this.lowerBounds;
        }

        @Override
        public Type[] getUpperBounds() {
            return this.upperBounds;
        }
    }

    private static final class ExpandedParameterizedType
    extends ExpandedType<ParameterizedType>
    implements ParameterizedType {
        private final Type[] typeArgs;

        public ExpandedParameterizedType(ParameterizedType originalType, Class<?> rootClass, Type[] typeArgs) {
            super(originalType, rootClass, null);
            if (typeArgs == null) {
                throw new IllegalArgumentException("Null arg not allowed!");
            }
            this.typeArgs = typeArgs;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArgs;
        }

        @Override
        public Type getOwnerType() {
            return ((ParameterizedType)this.originalType).getOwnerType();
        }

        @Override
        public Type getRawType() {
            return ((ParameterizedType)this.originalType).getRawType();
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type[] actualTypeArguments;
        private final Type ownerType;
        private final Type rawType;
        private int hash;

        public ParameterizedTypeImpl(Type[] actualTypeArguments, Type ownerType, Type rawType) {
            if (actualTypeArguments == null || actualTypeArguments.length == 0 || rawType == null) {
                throw new IllegalArgumentException();
            }
            this.actualTypeArguments = actualTypeArguments;
            this.ownerType = ownerType;
            this.rawType = rawType;
            this.hash = 31 + (ownerType != null ? ownerType.hashCode() : 0);
            this.hash = 31 * this.hash + rawType.hashCode();
            this.hash = 31 * this.hash + Arrays.hashCode(actualTypeArguments);
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        @Override
        public Type getOwnerType() {
            return this.ownerType;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType other = (ParameterizedType)obj;
            if (!Arrays.equals(this.actualTypeArguments, other.getActualTypeArguments())) {
                return false;
            }
            if (this.ownerType == null ? other.getOwnerType() != null : !this.ownerType.equals(other.getOwnerType())) {
                return false;
            }
            return !(this.rawType == null ? other.getRawType() != null : !this.rawType.equals(other.getRawType()));
        }
    }

    private static final class ExpandedGenericArrayType
    extends ExpandedType<GenericArrayType>
    implements GenericArrayType {
        private final Type componentType;

        public ExpandedGenericArrayType(GenericArrayType originalType, Type componentType, Class<?> rootClass) {
            super(originalType, rootClass, null);
            if (componentType == null) {
                throw new IllegalArgumentException("Null arg not allowed!");
            }
            this.componentType = componentType;
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }
    }

    private static abstract class ExpandedType<T extends Type> {
        protected final T originalType;
        protected final Class<?> rootClass;
        private int hash;

        private ExpandedType(T originalType, Class<?> rootClass) {
            if (originalType == null || rootClass == null) {
                throw new IllegalArgumentException("Null arg not allowed!");
            }
            this.originalType = originalType;
            this.rootClass = rootClass;
            this.hash = 31 + rootClass.hashCode();
            this.hash = 31 * this.hash + originalType.hashCode();
        }

        public T getOriginalType() {
            return this.originalType;
        }

        public Class<?> getRootClass() {
            return this.rootClass;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ExpandedType)) {
                return false;
            }
            ExpandedType other = (ExpandedType)obj;
            return this.originalType.equals(other.originalType) && this.rootClass.equals(other.rootClass);
        }

        /* synthetic */ ExpandedType(Type x0, Class x1, 1 x2) {
            this(x0, x1);
        }
    }
}

