/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.stream;

import com.owlike.genson.TransformationRuntimeException;
import com.owlike.genson.stream.JsonType;
import com.owlike.genson.stream.ObjectReader;
import com.owlike.genson.stream.ValueType;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;

public class JsonReader
implements ObjectReader {
    protected static final String NULL_VALUE = "null";
    protected static final int[] SKIPPED_TOKENS;
    private static final int[] sHexValues;
    private static final int[] _CHAR_TO_INT;
    private final Reader reader;
    private final char[] _buffer;
    private int _position;
    private int _cursor;
    private int _buflen;
    private char[] _stringBuffer;
    private int _stringBufferTail;
    private int _stringBufferLength;
    private String currentName;
    private String _stringValue;
    private long _intValue;
    private double _doubleValue;
    private int _numberLen;
    private Boolean _booleanValue;
    private ValueType valueType;
    private boolean _checkedNext;
    private boolean _hasNext;
    private boolean _first;
    private boolean _metadata_readen;
    private Map<String, String> _metadata;
    private final Deque<JsonType> _ctx;

    public JsonReader(String source) {
        this(new StringReader(source));
    }

    public JsonReader(Reader reader) {
        block10: {
            this._buffer = new char[2048];
            this._stringBuffer = new char[16];
            this._stringBufferTail = 0;
            this._stringBufferLength = this._stringBuffer.length;
            this._numberLen = 0;
            this._checkedNext = false;
            this._hasNext = false;
            this._first = false;
            this._metadata_readen = false;
            this._metadata = new HashMap<String, String>(5);
            this._ctx = new ArrayDeque<JsonType>();
            this._ctx.push(JsonType.EMPTY);
            this.reader = reader;
            try {
                char token = (char)this.readNextToken(false);
                if ('[' == token) {
                    this.setValueType(ValueType.ARRAY);
                    break block10;
                }
                if ('{' == token) {
                    this.setValueType(ValueType.OBJECT);
                    break block10;
                }
                if (this._buflen > 0) {
                    try {
                        this.consumeValue();
                    }
                    catch (IllegalStateException ise) {
                        try {
                            this._cursor = -1;
                            this._position = -1;
                            this.consumeString('\"');
                            this._stringValue = new String(this._stringBuffer, 0, this._stringBufferTail);
                            this.valueType = ValueType.STRING;
                        }
                        catch (RuntimeException re) {
                            throw ise;
                        }
                    }
                    if (ValueType.valueOf(this.valueType.name()) == null) {
                        throw new TransformationRuntimeException("Failed to instanciate reader, first character was " + token + " when possible character are [ and {");
                    }
                    break block10;
                }
                this.setValueType(ValueType.NULL);
            }
            catch (IOException ioe) {
                throw new TransformationRuntimeException("Failed to instanciate reader!", ioe);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public ObjectReader beginArray() throws IOException {
        this.begin(91, JsonType.ARRAY);
        this.valueType = ValueType.ARRAY;
        if (this._metadata_readen) {
            this._metadata.clear();
        }
        return this;
    }

    @Override
    public ObjectReader beginObject() throws IOException {
        if (!this._metadata_readen) {
            this.begin(123, JsonType.OBJECT);
            this.valueType = ValueType.OBJECT;
            this._metadata.clear();
            this.readMetadata();
        }
        return this;
    }

    @Override
    public ObjectReader nextObjectMetadata() throws IOException {
        return this.beginObject();
    }

    @Override
    public ObjectReader endArray() throws IOException {
        this.end(93, JsonType.ARRAY);
        return this;
    }

    @Override
    public ObjectReader endObject() throws IOException {
        this.end(125, JsonType.OBJECT);
        this._metadata.clear();
        this._metadata_readen = false;
        return this;
    }

    @Override
    public String name() {
        return this.currentName;
    }

    @Override
    public String valueAsString() {
        if (ValueType.STRING.equals((Object)this.valueType)) {
            return this._stringValue;
        }
        if (ValueType.NULL.equals((Object)this.valueType)) {
            return NULL_VALUE;
        }
        if (ValueType.INTEGER.equals((Object)this.valueType)) {
            return String.valueOf(this._intValue);
        }
        if (ValueType.DOUBLE.equals((Object)this.valueType)) {
            return String.valueOf(this._doubleValue);
        }
        if (ValueType.BOOLEAN.equals((Object)this.valueType)) {
            return this._booleanValue.toString();
        }
        throw new IllegalStateException("Readen value can not be converted to String");
    }

    @Override
    public int valueAsInt() throws IOException {
        if (ValueType.INTEGER.equals((Object)this.valueType)) {
            if (this._intValue < Integer.MIN_VALUE || this._intValue > Integer.MAX_VALUE) {
                throw new TransformationRuntimeException("The numeric value " + this._intValue + " is out of int range.");
            }
            return (int)this._intValue;
        }
        if (ValueType.DOUBLE.equals((Object)this.valueType)) {
            if (this._doubleValue < -2.147483648E9 || this._doubleValue > 2.147483647E9) {
                throw new TransformationRuntimeException("The numeric value " + this._doubleValue + " is out of int range.");
            }
            return (int)this._doubleValue;
        }
        if (ValueType.NULL.equals((Object)this.valueType)) {
            return 0;
        }
        if (ValueType.STRING.equals((Object)this.valueType)) {
            return "".equals(this._stringValue) ? null : Integer.valueOf(this._stringValue);
        }
        throw new IllegalStateException("Readen value is not of type int");
    }

    @Override
    public long valueAsLong() throws IOException {
        if (ValueType.INTEGER.equals((Object)this.valueType)) {
            return this._intValue;
        }
        if (ValueType.DOUBLE.equals((Object)this.valueType)) {
            return (long)this._doubleValue;
        }
        if (ValueType.NULL.equals((Object)this.valueType)) {
            return 0L;
        }
        if (ValueType.STRING.equals((Object)this.valueType)) {
            return "".equals(this._stringValue) ? null : Long.valueOf(this._stringValue);
        }
        throw new IllegalStateException("Readen value is not of type long");
    }

    @Override
    public double valueAsDouble() throws IOException {
        if (ValueType.DOUBLE.equals((Object)this.valueType)) {
            return this._doubleValue;
        }
        if (ValueType.INTEGER.equals((Object)this.valueType)) {
            return this._intValue;
        }
        if (ValueType.NULL.equals((Object)this.valueType)) {
            return 0.0;
        }
        if (ValueType.STRING.equals((Object)this.valueType)) {
            return "".equals(this._stringValue) ? null : Double.valueOf(this._stringValue);
        }
        throw new IllegalStateException("Readen value is not of type double");
    }

    @Override
    public short valueAsShort() throws IOException {
        if (ValueType.INTEGER.equals((Object)this.valueType)) {
            if (this._intValue < -32768L || this._intValue > 32767L) {
                throw new TransformationRuntimeException("The numeric value " + this._intValue + " is out of short range.");
            }
            return (short)this._intValue;
        }
        if (ValueType.DOUBLE.equals((Object)this.valueType)) {
            if (this._doubleValue < -32768.0 || this._doubleValue > 32767.0) {
                throw new TransformationRuntimeException("The numeric value " + this._doubleValue + " is out of short range.");
            }
            return (short)this._doubleValue;
        }
        if (ValueType.NULL.equals((Object)this.valueType)) {
            return 0;
        }
        if (ValueType.STRING.equals((Object)this.valueType)) {
            return "".equals(this._stringValue) ? null : Short.valueOf(this._stringValue);
        }
        throw new IllegalStateException("Readen value is not of type short");
    }

    @Override
    public float valueAsFloat() throws IOException {
        if (ValueType.DOUBLE.equals((Object)this.valueType)) {
            if (this._doubleValue < (double)1.4E-45f || this._doubleValue > 3.4028234663852886E38) {
                throw new TransformationRuntimeException("The numeric value " + this._doubleValue + " is out of float range.");
            }
            return (float)this._doubleValue;
        }
        if (ValueType.INTEGER.equals((Object)this.valueType)) {
            if ((float)this._intValue < Float.MIN_VALUE || (float)this._intValue > Float.MAX_VALUE) {
                throw new TransformationRuntimeException("The numeric value " + this._intValue + " is out of float range.");
            }
            return this._intValue;
        }
        if (ValueType.NULL.equals((Object)this.valueType)) {
            return 0.0f;
        }
        if (ValueType.STRING.equals((Object)this.valueType)) {
            return ("".equals(this._stringValue) ? null : Float.valueOf(this._stringValue)).floatValue();
        }
        throw new IllegalStateException("Readen value is not of type float");
    }

    @Override
    public boolean valueAsBoolean() throws IOException {
        if (ValueType.BOOLEAN.equals((Object)this.valueType)) {
            return this._booleanValue;
        }
        if (ValueType.STRING.equals((Object)this.valueType)) {
            return "".equals(this._stringValue) ? null : Boolean.valueOf(this._stringValue);
        }
        if (ValueType.NULL.equals((Object)this.valueType)) {
            return false;
        }
        throw new IllegalStateException("Readen value is not of type boolean");
    }

    @Override
    public String metadata(String name) throws IOException {
        if (!this._metadata_readen) {
            this.nextObjectMetadata();
        }
        return this._metadata.get(name);
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public ObjectReader skipValue() throws IOException {
        if (ValueType.ARRAY == this.valueType || ValueType.OBJECT == this.valueType) {
            int balance = 0;
            do {
                if (ValueType.ARRAY == this.valueType) {
                    this.beginArray();
                    ++balance;
                } else if (ValueType.OBJECT == this.valueType) {
                    this.beginObject();
                    ++balance;
                }
                if (this.hasNext()) {
                    this.next();
                    continue;
                }
                JsonType type = this._ctx.peek();
                if (JsonType.ARRAY == type) {
                    this.endArray();
                    --balance;
                    continue;
                }
                if (JsonType.OBJECT != type) continue;
                this.endObject();
                --balance;
            } while (balance > 0);
        }
        return this;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this._checkedNext) {
            return this._hasNext;
        }
        int token = this.readNextToken(false);
        char ctoken = (char)token;
        this.checkIllegalEnd(token);
        this._hasNext = token < 128 && (ctoken == ',' && !this._first || this._first && ('\"' == ctoken || ctoken == '{' || ctoken == '[' || token > 47 && token < 58 || ctoken == '-' || ctoken == 'n' || ctoken == 't' || ctoken == 'f'));
        this._checkedNext = true;
        if (this._hasNext && !this._first) {
            ++this._cursor;
        }
        return this._hasNext;
    }

    @Override
    public ValueType next() throws IOException {
        this._metadata_readen = false;
        this._checkedNext = false;
        this._hasNext = false;
        this._first = false;
        this.resetNameAndValue();
        char ctoken = (char)this.readNextToken(false);
        if (ctoken == ',') {
            ++this._cursor;
            ctoken = (char)this.readNextToken(false);
        } else if (JsonType.ARRAY == this._ctx.peek()) {
            if (ctoken == '[') {
                return this.setValueType(ValueType.ARRAY);
            }
            if (ctoken == '{') {
                return this.setValueType(ValueType.OBJECT);
            }
        }
        if (JsonType.OBJECT == this._ctx.peek()) {
            this.consumeName(ctoken);
            this.currentName = new String(this._stringBuffer, 0, this._stringBufferTail);
            this._stringBufferTail = 0;
            if (this.readNextToken(true) != 58) {
                this.newWrongTokenException(":", this._cursor - 1);
            }
        }
        return this.consumeValue();
    }

    protected final ValueType consumeValue() throws IOException {
        char ctoken = (char)this.readNextToken(false);
        ValueType valueType = null;
        if (ctoken == '\"') {
            this.consumeString(ctoken);
            this._stringValue = new String(this._stringBuffer, 0, this._stringBufferTail);
            this._stringBufferTail = 0;
            valueType = ValueType.STRING;
        } else {
            if (ctoken == '[') {
                return this.setValueType(ValueType.ARRAY);
            }
            if (ctoken == '{') {
                return this.setValueType(ValueType.OBJECT);
            }
            valueType = this.consumeLiteral();
        }
        return this.setValueType(valueType);
    }

    protected final void readMetadata() throws IOException {
        this._metadata_readen = true;
        while (true) {
            char ctoken;
            if ('\"' != (ctoken = (char)this.readNextToken(false))) {
                return;
            }
            this.ensureBufferHas(2, true);
            if ('@' != this._buffer[this._cursor + 1]) break;
            ++this._cursor;
            this.consumeString(ctoken);
            String key = new String(this._stringBuffer, 0, this._stringBufferTail);
            this._stringBufferTail = 0;
            if (this.readNextToken(true) != 58) {
                this.newWrongTokenException(":", this._cursor - 1);
            }
            this.consumeString((char)this.readNextToken(false));
            this._metadata.put(key, new String(this._stringBuffer, 0, this._stringBufferTail));
            this._stringBufferTail = 0;
            if (this.readNextToken(false) != 44) continue;
            ++this._cursor;
        }
    }

    protected final void begin(int character, JsonType type) throws IOException {
        int token = this.readNextToken(true);
        this.checkIllegalEnd(token);
        if (character == token) {
            this._ctx.push(type);
        } else {
            this.newWrongTokenException("" + (char)character, this._cursor - 1);
        }
        this._first = true;
        this._checkedNext = false;
        this._hasNext = false;
    }

    protected final void end(int character, JsonType type) throws IOException {
        int token = this.readNextToken(true);
        this.checkIllegalEnd(token);
        if (character == token && type == this._ctx.peek()) {
            this._ctx.pop();
        } else {
            this.newWrongTokenException("" + (char)character, this._cursor - 1);
        }
        this._first = false;
        this._checkedNext = false;
        this._hasNext = false;
    }

    protected final ValueType setValueType(ValueType tokenType) {
        this.valueType = tokenType;
        return tokenType;
    }

    protected final void consumeName(char token) throws IOException {
        if (token != '\"') {
            this.newMisplacedTokenException(this._cursor);
        }
        ++this._cursor;
        while (this._buflen > -1) {
            int i;
            this.fillBuffer(true);
            for (i = this._cursor; i < this._buflen && this._buffer[i] != '\"'; ++i) {
            }
            this.writeToStringBuffer(this._buffer, this._cursor, i - this._cursor);
            this._cursor = i + 1;
            if (i >= this._buflen || this._buffer[i] != '\"') continue;
            return;
        }
    }

    protected final void consumeString(char token) throws IOException {
        if (token != '\"') {
            this.newMisplacedTokenException(this._cursor);
        }
        ++this._cursor;
        while (this._buflen > -1) {
            this.fillBuffer(true);
            int i = this._cursor;
            while (i < this._buflen) {
                if (this._buffer[i] == '\\') {
                    this.writeToStringBuffer(this._buffer, this._cursor, i - this._cursor);
                    this._cursor = i + 1;
                    if (this._stringBufferLength <= this._stringBufferTail + 1) {
                        this.expandStringBuffer(16);
                    }
                    this._stringBuffer[this._stringBufferTail++] = this.readEscaped();
                    i = this._cursor;
                    continue;
                }
                if (this._buffer[i] == '\"') break;
                ++i;
            }
            this.writeToStringBuffer(this._buffer, this._cursor, i - this._cursor);
            this._cursor = i + 1;
            if (i >= this._buflen || this._buffer[i] != '\"') continue;
            return;
        }
    }

    protected final ValueType consumeLiteral() throws IOException {
        this.fillBuffer(true);
        char token = this._buffer[this._cursor];
        if (token > '/' && token < ':' || token == '-') {
            ValueType valueType = null;
            int sign = 1;
            if (token == '-') {
                ++this._cursor;
                sign = -1;
            }
            this._intValue = this.consumeInt();
            if (this.isEOF()) {
                return ValueType.INTEGER;
            }
            if (this._buffer[this._cursor] == '.') {
                ++this._cursor;
                this._doubleValue = this.consumeInt();
                this._doubleValue = (double)sign * ((double)this._intValue + this._doubleValue / Math.pow(10.0, this._numberLen));
                valueType = ValueType.DOUBLE;
            } else {
                this._intValue *= (long)sign;
                valueType = ValueType.INTEGER;
            }
            if (this.isEOF() || this.ensureBufferHas(2, false) < 0) {
                return valueType;
            }
            char ctoken = this._buffer[this._cursor];
            if (ctoken == 'e' || ctoken == 'E') {
                ++this._cursor;
                ctoken = this._buffer[this._cursor];
                if (ctoken == '-' || ctoken == '+' || ctoken > '/' && ctoken < ':') {
                    if (ctoken == '-' || ctoken == '+') {
                        ++this._cursor;
                    }
                    double val = this.consumeInt();
                    double exp = 0.0;
                    boolean limit = false;
                    if (ctoken == '-') {
                        exp = 1.0 / Math.pow(10.0, val);
                        if (exp == 0.0) {
                            exp = Math.pow(10.0, -val + 1.0);
                            limit = true;
                        }
                    } else {
                        exp = Math.pow(10.0, val);
                    }
                    if (ValueType.INTEGER.equals((Object)valueType)) {
                        this._intValue = (long)((double)this._intValue * exp);
                    } else {
                        this._doubleValue *= exp;
                        if (limit) {
                            this._doubleValue /= 10.0;
                        }
                    }
                } else {
                    this.newWrongTokenException("'-' or '+' or '' (same as +)");
                }
            }
            return valueType;
        }
        this.ensureBufferHas(4, true);
        if (!(this._buffer[this._cursor] != 'N' && this._buffer[this._cursor] != 'n' || this._buffer[this._cursor + 1] != 'U' && this._buffer[this._cursor + 1] != 'u' || this._buffer[this._cursor + 2] != 'L' && this._buffer[this._cursor + 2] != 'l' || this._buffer[this._cursor + 3] != 'L' && this._buffer[this._cursor + 3] != 'l')) {
            this._cursor += 4;
            return ValueType.NULL;
        }
        if (!(this._buffer[this._cursor] != 'T' && this._buffer[this._cursor] != 't' || this._buffer[this._cursor + 1] != 'R' && this._buffer[this._cursor + 1] != 'r' || this._buffer[this._cursor + 2] != 'U' && this._buffer[this._cursor + 2] != 'u' || this._buffer[this._cursor + 3] != 'E' && this._buffer[this._cursor + 3] != 'e')) {
            this._booleanValue = true;
            this._cursor += 4;
            return ValueType.BOOLEAN;
        }
        this.ensureBufferHas(5, true);
        if (!(this._buffer[this._cursor] != 'F' && this._buffer[this._cursor] != 'f' || this._buffer[this._cursor + 1] != 'A' && this._buffer[this._cursor + 1] != 'a' || this._buffer[this._cursor + 2] != 'L' && this._buffer[this._cursor + 2] != 'l' || this._buffer[this._cursor + 3] != 'S' && this._buffer[this._cursor + 3] != 's' || this._buffer[this._cursor + 4] != 'E' && this._buffer[this._cursor + 4] != 'e')) {
            this._booleanValue = false;
            this._cursor += 5;
            return ValueType.BOOLEAN;
        }
        throw new IllegalStateException("Illegal character around position " + (this._position - this.valueAsString().length() - this._buflen + this._cursor) + " awaited for literal (number, boolean or null) but read '" + this._buffer[this._cursor] + "'!");
    }

    private final long consumeInt() throws IOException {
        boolean stop = false;
        long value = 0L;
        this._numberLen = 0;
        while (this._buflen > -1) {
            int i;
            this.fillBuffer(true);
            for (i = this._cursor; i < this._buflen; ++i) {
                if (this._buffer[i] < '0' || this._buffer[i] > '9') {
                    stop = true;
                    break;
                }
                ++this._numberLen;
                value = 10L * value + (long)_CHAR_TO_INT[this._buffer[i]];
            }
            this._cursor = i;
            if (!stop) continue;
            if (this._numberLen == 0) {
                this.newWrongTokenException("numeric value");
            }
            return value;
        }
        return value;
    }

    protected final int readNextToken(boolean consume) throws IOException {
        boolean stop = false;
        while (this._buflen > -1) {
            this.fillBuffer(true);
            while (this._cursor < this._buflen) {
                if (this._buffer[this._cursor] < '\u0080' && SKIPPED_TOKENS[this._buffer[this._cursor]] == 0) {
                    stop = true;
                    break;
                }
                ++this._cursor;
            }
            if (!stop) continue;
            if (consume) {
                return this._buffer[this._cursor++];
            }
            return this._buffer[this._cursor];
        }
        return -1;
    }

    protected final char readEscaped() throws IOException {
        this.fillBuffer(true);
        char token = this._buffer[this._cursor++];
        switch (token) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': 
            case '/': 
            case '\\': {
                return token;
            }
            case 'u': {
                break;
            }
            default: {
                this.newMisplacedTokenException(this._cursor - 1);
            }
        }
        int value = 0;
        if (this.ensureBufferHas(4, false) < 0) {
            throw new IllegalStateException("Expected 4 hex-digit for character escape sequence!");
        }
        for (int i = 0; i < 4; ++i) {
            char ch;
            int digit;
            int n = digit = (ch = this._buffer[this._cursor++]) > '\u007f' ? -1 : sHexValues[ch];
            if (digit < 0) {
                throw new IllegalStateException("Wrong character '" + ch + "' expected a hex-digit for character escape sequence!");
            }
            value = value << 4 | digit;
        }
        return (char)value;
    }

    private final void writeToStringBuffer(char[] data, int offset, int length) throws IOException {
        if (this._stringBufferLength <= this._stringBufferTail + length) {
            this.expandStringBuffer(length);
        }
        System.arraycopy(data, offset, this._stringBuffer, this._stringBufferTail, length);
        this._stringBufferTail += length;
    }

    private final void expandStringBuffer(int length) {
        char[] extendedStringBuffer = new char[this._stringBufferLength * 2 + length];
        System.arraycopy(this._stringBuffer, 0, extendedStringBuffer, 0, this._stringBufferTail);
        this._stringBuffer = extendedStringBuffer;
        this._stringBufferLength = extendedStringBuffer.length;
    }

    private final int fillBuffer(boolean doThrow) throws IOException {
        if (this._cursor < this._buflen) {
            return this._buflen;
        }
        this._buflen = this.reader.read(this._buffer);
        this.checkIllegalEnd(this._buflen);
        this._cursor = 0;
        this._position += this._buflen;
        return this._buflen;
    }

    private final int ensureBufferHas(int minLength, boolean doThrow) throws IOException {
        int actualLen = this._buflen - this._cursor;
        if (actualLen >= minLength) {
            return actualLen;
        }
        System.arraycopy(this._buffer, this._cursor, this._buffer, 0, actualLen);
        while (actualLen < minLength) {
            int len = this.reader.read(this._buffer, actualLen, this._buffer.length - actualLen);
            if (len < 0) {
                if (doThrow) {
                    throw new IllegalStateException("Encountered end of stream, incomplete json!");
                }
                return len;
            }
            actualLen += len;
        }
        this._buflen = actualLen;
        this._position += actualLen;
        this._cursor = 0;
        return actualLen;
    }

    protected final boolean isEOF() throws IOException {
        return this._buflen < 0 || this.fillBuffer(false) < 0;
    }

    private final void resetNameAndValue() {
        this._doubleValue = 0.0;
        this._intValue = 0L;
        this._booleanValue = null;
        this.currentName = null;
        this._stringValue = null;
    }

    private final void newWrongTokenException(String awaited) {
        this.newWrongTokenException(awaited, this._cursor);
    }

    private final void newWrongTokenException(String awaited, int cursor) {
        int pos;
        if (cursor < 0) {
            cursor = 0;
        }
        if ((pos = this._position - this.valueAsString().length() - this._buflen + cursor) < 0) {
            pos = 0;
        }
        if (this._buflen < 0) {
            throw new IllegalStateException("Incomplete data or malformed json : encoutered end of stream but expected " + awaited);
        }
        throw new IllegalStateException("Illegal character at position " + pos + " expected " + awaited + " but read '" + this._buffer[cursor] + "' !");
    }

    private final void newMisplacedTokenException(int cursor) {
        int pos;
        if (this._buflen < 0) {
            throw new IllegalStateException("Incomplete data or malformed json : encoutered end of stream.");
        }
        if (cursor < 0) {
            cursor = 0;
        }
        if ((pos = this._position - this.valueAsString().length() - this._buflen + cursor) < 0) {
            pos = 0;
        }
        throw new IllegalStateException("Encountred misplaced character '" + this._buffer[cursor] + "' around position " + pos);
    }

    private final void checkIllegalEnd(int token) throws IOException {
        if (token == -1 && JsonType.EMPTY != this._ctx.peek()) {
            throw new IOException("Incomplete data or malformed json : encoutered end of stream!");
        }
    }

    static {
        int i;
        SKIPPED_TOKENS = new int[128];
        JsonReader.SKIPPED_TOKENS[9] = 1;
        JsonReader.SKIPPED_TOKENS[8] = 1;
        JsonReader.SKIPPED_TOKENS[10] = 1;
        JsonReader.SKIPPED_TOKENS[13] = 1;
        JsonReader.SKIPPED_TOKENS[12] = 1;
        JsonReader.SKIPPED_TOKENS[32] = 1;
        sHexValues = new int[128];
        Arrays.fill(sHexValues, -1);
        for (i = 0; i < 10; ++i) {
            JsonReader.sHexValues[48 + i] = i;
        }
        for (i = 0; i < 6; ++i) {
            JsonReader.sHexValues[97 + i] = 10 + i;
            JsonReader.sHexValues[65 + i] = 10 + i;
        }
        _CHAR_TO_INT = new int[58];
        for (i = 48; i < 58; ++i) {
            JsonReader._CHAR_TO_INT[i] = i - 48;
        }
    }
}

