/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson;

import com.owlike.genson.reflect.TypeUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class GenericType<T> {
    private final Type type;
    private final Class<T> rawClass;
    private static final Map<Type, GenericType<?>> _genericTypesCache = new ConcurrentHashMap();

    protected GenericType() {
        Type superType = this.getClass().getGenericSuperclass();
        if (superType instanceof Class) {
            throw new IllegalArgumentException("You must specify the parametrized type!");
        }
        this.type = ((ParameterizedType)superType).getActualTypeArguments()[0];
        this.rawClass = TypeUtil.getRawClass(this.type);
    }

    private GenericType(Class<T> rawClass, Type type) {
        this.type = type;
        this.rawClass = rawClass;
    }

    public static <T> GenericType<T> genericTypeFor(Class<T> rawClass, Type type) {
        Class<?> typeRawClass = TypeUtil.getRawClass(type);
        if (!rawClass.equals(typeRawClass)) {
            throw new IllegalArgumentException("Argument rawClass " + rawClass + " does not match raw class " + typeRawClass + " of argument type " + type);
        }
        GenericType genericType = _genericTypesCache.get(type);
        if (genericType == null) {
            genericType = new GenericType<T>((Class)rawClass, type){};
            _genericTypesCache.put(type, genericType);
        }
        return genericType;
    }

    public Type getType() {
        return this.type;
    }

    public Class<T> getRawClass() {
        return this.rawClass;
    }
}

