/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.Context;
import com.owlike.genson.Serializer;
import com.owlike.genson.TransformationException;
import com.owlike.genson.TransformationRuntimeException;
import com.owlike.genson.reflect.BeanProperty;
import com.owlike.genson.stream.ObjectWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public abstract class PropertyAccessor<T, P>
extends BeanProperty<T>
implements Comparable<PropertyAccessor<T, ?>> {
    final Serializer<P> propertySerializer;

    protected PropertyAccessor(String name, Type type, Class<T> declaringClass, Serializer<P> propertySerializer) {
        super(name, type, declaringClass);
        this.propertySerializer = propertySerializer;
    }

    public void serialize(T propertySource, ObjectWriter writer, Context ctx) throws TransformationException, IOException {
        P propertyValue = this.access(propertySource);
        writer.writeName(this.name);
        this.propertySerializer.serialize(propertyValue, writer, ctx);
    }

    public abstract P access(T var1);

    @Override
    public int compareTo(PropertyAccessor<T, ?> o) {
        return o.priority() - this.priority();
    }

    protected TransformationRuntimeException couldNotAccess(Exception e) {
        return new TransformationRuntimeException("Could not access value of property named '" + this.name + "' using accessor " + this.signature() + " from class " + this.declaringClass.getName(), e);
    }

    public static class FieldAccessor<T, P>
    extends PropertyAccessor<T, P> {
        protected final Field _field;

        public FieldAccessor(String name, Field field, Type type, Class<T> declaringClass, Serializer<P> propertySerializer) {
            super(name, type, declaringClass, propertySerializer);
            this._field = field;
            if (!this._field.isAccessible()) {
                this._field.setAccessible(true);
            }
        }

        @Override
        public P access(T target) {
            try {
                return (P)this._field.get(target);
            }
            catch (IllegalArgumentException e) {
                throw this.couldNotAccess(e);
            }
            catch (IllegalAccessException e) {
                throw this.couldNotAccess(e);
            }
        }

        @Override
        public String signature() {
            return this._field.toGenericString();
        }

        @Override
        public int priority() {
            return 50;
        }
    }

    public static class MethodAccessor<T, P>
    extends PropertyAccessor<T, P> {
        protected final Method _getter;

        public MethodAccessor(String name, Method getter, Type type, Class<T> declaringClass, Serializer<P> propertySerializer) {
            super(name, type, declaringClass, propertySerializer);
            this._getter = getter;
            if (!this._getter.isAccessible()) {
                this._getter.setAccessible(true);
            }
        }

        @Override
        public P access(T target) {
            try {
                return (P)this._getter.invoke(target, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw this.couldNotAccess(e);
            }
            catch (IllegalAccessException e) {
                throw this.couldNotAccess(e);
            }
            catch (InvocationTargetException e) {
                throw this.couldNotAccess(e);
            }
        }

        @Override
        public String signature() {
            return this._getter.toGenericString();
        }

        @Override
        public int priority() {
            return 100;
        }
    }
}

