/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.reflect;

import com.owlike.genson.Context;
import com.owlike.genson.Deserializer;
import com.owlike.genson.TransformationException;
import com.owlike.genson.TransformationRuntimeException;
import com.owlike.genson.reflect.BeanProperty;
import com.owlike.genson.stream.ObjectReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public abstract class PropertyMutator<T, P>
extends BeanProperty<T>
implements Comparable<PropertyMutator<T, ?>> {
    final Deserializer<P> propertyDeserializer;

    protected PropertyMutator(String name, Type type, Class<T> declaringClass, Deserializer<P> propertyDeserializer) {
        super(name, type, declaringClass);
        this.propertyDeserializer = propertyDeserializer;
    }

    public P deserialize(ObjectReader reader, Context ctx) throws TransformationException, IOException {
        return this.propertyDeserializer.deserialize(reader, ctx);
    }

    public abstract void deserialize(T var1, ObjectReader var2, Context var3) throws TransformationException, IOException;

    public abstract void mutate(T var1, P var2);

    @Override
    public int compareTo(PropertyMutator<T, ?> o) {
        return o.priority() - this.priority();
    }

    protected TransformationRuntimeException couldNotMutate(Exception e) {
        return new TransformationRuntimeException("Could not mutate value of property named '" + this.name + "' using mutator " + this.signature(), e);
    }

    public static class FieldMutator<T, P>
    extends PropertyMutator<T, P> {
        protected final Field _field;

        public FieldMutator(String name, Field field, Type type, Class<T> declaringClass, Deserializer<P> propertyDeserializer) {
            super(name, type, declaringClass, propertyDeserializer);
            this._field = field;
            if (!this._field.isAccessible()) {
                this._field.setAccessible(true);
            }
        }

        @Override
        public void deserialize(T into, ObjectReader reader, Context ctx) throws TransformationException, IOException {
            Object propValue = this.propertyDeserializer.deserialize(reader, ctx);
            try {
                this._field.set(into, propValue);
            }
            catch (IllegalArgumentException e) {
                throw this.couldNotMutate(e);
            }
            catch (IllegalAccessException e) {
                throw this.couldNotMutate(e);
            }
        }

        @Override
        public void mutate(T target, P value) {
            try {
                this._field.set(target, value);
            }
            catch (IllegalArgumentException e) {
                throw this.couldNotMutate(e);
            }
            catch (IllegalAccessException e) {
                throw this.couldNotMutate(e);
            }
        }

        @Override
        public String signature() {
            return this._field.toGenericString();
        }

        @Override
        public int priority() {
            return 0;
        }
    }

    public static class MethodMutator<T, P>
    extends PropertyMutator<T, P> {
        protected final Method _setter;

        public MethodMutator(String name, Method setter, Type type, Class<T> declaringClass, Deserializer<P> propertyDeserializer) {
            super(name, type, declaringClass, propertyDeserializer);
            this._setter = setter;
            if (!this._setter.isAccessible()) {
                this._setter.setAccessible(true);
            }
        }

        @Override
        public void deserialize(T into, ObjectReader reader, Context ctx) throws TransformationException, IOException {
            Object propValue = this.propertyDeserializer.deserialize(reader, ctx);
            try {
                this._setter.invoke(into, propValue);
            }
            catch (IllegalArgumentException e) {
                throw this.couldNotMutate(e);
            }
            catch (IllegalAccessException e) {
                throw this.couldNotMutate(e);
            }
            catch (InvocationTargetException e) {
                throw this.couldNotMutate(e);
            }
        }

        @Override
        public void mutate(T target, P value) {
            try {
                this._setter.invoke(target, value);
            }
            catch (IllegalArgumentException e) {
                throw this.couldNotMutate(e);
            }
            catch (IllegalAccessException e) {
                throw this.couldNotMutate(e);
            }
            catch (InvocationTargetException e) {
                throw this.couldNotMutate(e);
            }
        }

        @Override
        public String signature() {
            return this._setter.toGenericString();
        }

        @Override
        public int priority() {
            return 100;
        }
    }
}

