/*
 * Decompiled with CFR 0.152.
 */
package com.owlike.genson.stream;

import com.owlike.genson.stream.JsonType;
import com.owlike.genson.stream.ObjectWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;

public class JsonWriter
implements ObjectWriter {
    private static final String[] REPLACEMENT_CHARS;
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private static final char[] _INT_TO_CHARARRAY;
    private static final char[] NULL_VALUE;
    private static final char[] TRUE_VALUE;
    private static final char[] FALSE_VALUE;
    private static final int _LIMIT_WRITE_TO_BUFFER = 64;
    private final boolean htmlSafe;
    private final boolean skipNull;
    private final Writer writer;
    private final Deque<JsonType> _ctx = new ArrayDeque<JsonType>();
    private boolean _hasPrevious;
    private String _name;
    private final char[] _buffer = new char[1024];
    private final int _bufferSize = this._buffer.length;
    private int _len = 0;

    public JsonWriter(Writer writer) {
        this(writer, false, false);
    }

    public JsonWriter(Writer writer, boolean skipNull, boolean htmlSafe) {
        this.writer = writer;
        this.skipNull = skipNull;
        this.htmlSafe = htmlSafe;
        this._ctx.push(JsonType.EMPTY);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.writer.close();
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.writer.flush();
    }

    @Override
    public JsonWriter beginArray() throws IOException {
        return this.begin(JsonType.ARRAY, '[');
    }

    @Override
    public JsonWriter beginObject() throws IOException {
        if (this._ctx.peek() == JsonType.METADATA) {
            this._ctx.pop();
            return this;
        }
        return this.begin(JsonType.OBJECT, '{');
    }

    protected final JsonWriter begin(JsonType jsonType, char token) throws IOException {
        this.beforeValue();
        this._ctx.push(jsonType);
        if (this._len + 1 >= this._bufferSize) {
            this.flushBuffer();
        }
        this._buffer[this._len++] = token;
        this._hasPrevious = false;
        return this;
    }

    @Override
    public JsonWriter endArray() throws IOException {
        return this.end(JsonType.ARRAY, ']');
    }

    @Override
    public JsonWriter endObject() throws IOException {
        return this.end(JsonType.OBJECT, '}');
    }

    private final JsonWriter end(JsonType jsonType, char token) throws IOException {
        JsonType jt = this._ctx.pop();
        if (jt != jsonType) {
            throw new IllegalStateException("Expect type " + jsonType.name() + " but was written " + jt.name() + ", you must call the adequate beginXXX method before endXXX.");
        }
        if (this._len + 1 >= this._bufferSize) {
            this.flushBuffer();
        }
        this._buffer[this._len++] = token;
        this._hasPrevious = true;
        return this;
    }

    private final JsonWriter beforeValue() throws IOException {
        if (this._ctx.peek() == JsonType.ARRAY && this._hasPrevious) {
            if (this._len + 1 >= this._bufferSize) {
                this.flushBuffer();
            }
            this._buffer[this._len++] = 44;
        }
        if (this._name != null && this._ctx.peek() != JsonType.ARRAY) {
            int l = this._name.length();
            if (this._len + 4 + l >= this._bufferSize) {
                this.flushBuffer();
            }
            if (this._hasPrevious) {
                this._buffer[this._len++] = 44;
            }
            this._buffer[this._len++] = 34;
            this.writeToBuffer(this._name, 0, l);
            this._buffer[this._len++] = 34;
            this._buffer[this._len++] = 58;
            this._name = null;
        }
        return this;
    }

    @Override
    public JsonWriter writeName(String name) throws IOException {
        this._name = name;
        return this;
    }

    @Override
    public JsonWriter writeValue(int value) throws IOException {
        this.beforeValue();
        if (this._len + 11 >= this._bufferSize) {
            this.flushBuffer();
        }
        if (value < 0) {
            this._buffer[this._len++] = 45;
            value *= -1;
        }
        this.writeInt(value);
        this._hasPrevious = true;
        return this;
    }

    @Override
    public JsonWriter writeValue(double value) throws IOException {
        this.beforeValue();
        this.writeToBuffer(Double.toString(value), 0);
        this._hasPrevious = true;
        return this;
    }

    @Override
    public JsonWriter writeValue(long value) throws IOException {
        this.beforeValue();
        if (this._len + 21 >= this._bufferSize) {
            this.flushBuffer();
        }
        if (value < 0L) {
            this._buffer[this._len++] = 45;
            value *= -1L;
        }
        this.writeInt(value);
        this._hasPrevious = true;
        return this;
    }

    @Override
    public ObjectWriter writeValue(short value) throws IOException {
        this.beforeValue();
        if (this._len + 5 >= this._bufferSize) {
            this.flushBuffer();
        }
        if (value < 0) {
            this._buffer[this._len++] = 45;
            value = (short)(value * -1);
        }
        this.writeInt(value);
        this._hasPrevious = true;
        return this;
    }

    @Override
    public ObjectWriter writeValue(float value) throws IOException {
        this.beforeValue();
        this.writeToBuffer(Float.toString(value), 0);
        this._hasPrevious = true;
        return this;
    }

    @Override
    public JsonWriter writeValue(boolean value) throws IOException {
        this.beforeValue();
        if (value) {
            this.writeToBuffer(TRUE_VALUE, 0, 4);
        } else {
            this.writeToBuffer(FALSE_VALUE, 0, 5);
        }
        this._hasPrevious = true;
        return this;
    }

    protected final int writeInt(long value) throws IOException {
        int len = (int)Math.log10(value) + 1;
        if (value == 0L) {
            this._buffer[this._len++] = 48;
            return 1;
        }
        int pos = this._len + len - 1;
        while (value > 0L) {
            long intPart = value / 10L;
            this._buffer[pos--] = _INT_TO_CHARARRAY[(int)(value - intPart * 10L)];
            value = intPart;
        }
        this._len += len;
        return len;
    }

    @Override
    public JsonWriter writeValue(Number value) throws IOException {
        this.beforeValue();
        this.writeToBuffer(value.toString(), 0);
        this._hasPrevious = true;
        return this;
    }

    @Override
    public JsonWriter writeUnsafeValue(String value) throws IOException {
        this.beforeValue();
        if (this._len + 1 >= this._bufferSize) {
            this.flushBuffer();
        }
        this._buffer[this._len++] = 34;
        this.writeToBuffer(value.toCharArray(), 0, value.length());
        if (this._len + 1 >= this._bufferSize) {
            this.flushBuffer();
        }
        this._buffer[this._len++] = 34;
        this._hasPrevious = true;
        return this;
    }

    @Override
    public JsonWriter writeValue(String value) throws IOException {
        String[] replacements;
        this.beforeValue();
        String[] stringArray = replacements = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        if (this._len + 1 >= this._bufferSize) {
            this.flushBuffer();
        }
        this._buffer[this._len++] = 34;
        int last = 0;
        int length = value.length();
        char[] carray = value.toCharArray();
        for (int i = 0; i < length; ++i) {
            String replacement;
            char c = carray[i];
            if (c < '\u0080') {
                replacement = replacements[c];
                if (replacement == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                replacement = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                replacement = "\\u2029";
            }
            if (last < i) {
                this.writeToBuffer(carray, last, i - last);
            }
            this.writeToBuffer(replacement, 0, replacement.length());
            last = i + 1;
        }
        if (last < length) {
            this.writeToBuffer(carray, last, length - last);
        }
        if (this._len + 1 >= this._bufferSize) {
            this.flushBuffer();
        }
        this._buffer[this._len++] = 34;
        this._hasPrevious = true;
        return this;
    }

    @Override
    public ObjectWriter writeNull() throws IOException {
        if (this.skipNull) {
            this._name = null;
        } else {
            this.beforeValue();
            this.writeToBuffer(NULL_VALUE, 0, 4);
            this._hasPrevious = true;
        }
        return this;
    }

    @Override
    public ObjectWriter beginNextObjectMetadata() throws IOException {
        if (this._ctx.peek() != JsonType.METADATA) {
            this.beginObject();
            this._ctx.push(JsonType.METADATA);
        }
        return this;
    }

    @Override
    public ObjectWriter writeMetadata(String name, String value) throws IOException {
        this.writeName('@' + name);
        this.writeValue(value);
        return this;
    }

    private final void writeToBuffer(char[] data, int offset, int length) throws IOException {
        if (length < 64 && length < this._bufferSize - this._len) {
            System.arraycopy(data, offset, this._buffer, this._len, length);
            this._len += length;
        } else {
            this.flushBuffer();
            this.writer.write(data, offset, length);
        }
    }

    private final void writeToBuffer(String data, int offset) throws IOException {
        this.writeToBuffer(data, offset, data.length());
    }

    private final void writeToBuffer(String data, int offset, int length) throws IOException {
        if (length < 64 && length < this._bufferSize - this._len) {
            data.getChars(offset, length, this._buffer, this._len);
            this._len += length;
        } else {
            this.flushBuffer();
            this.writer.write(data, offset, length);
        }
    }

    private final void flushBuffer() throws IOException {
        if (this._len > 0) {
            this.writer.write(this._buffer, 0, this._len);
            this._len = 0;
        }
    }

    public Writer unwrap() {
        return this.writer;
    }

    static {
        int i;
        REPLACEMENT_CHARS = new String[128];
        for (i = 0; i <= 31; ++i) {
            JsonWriter.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        JsonWriter.REPLACEMENT_CHARS[34] = "\\\"";
        JsonWriter.REPLACEMENT_CHARS[92] = "\\\\";
        JsonWriter.REPLACEMENT_CHARS[9] = "\\t";
        JsonWriter.REPLACEMENT_CHARS[8] = "\\b";
        JsonWriter.REPLACEMENT_CHARS[10] = "\\n";
        JsonWriter.REPLACEMENT_CHARS[13] = "\\r";
        JsonWriter.REPLACEMENT_CHARS[12] = "\\f";
        HTML_SAFE_REPLACEMENT_CHARS = (String[])REPLACEMENT_CHARS.clone();
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[39] = "\\u0027";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[60] = "\\u003c";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[62] = "\\u003e";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[38] = "\\u0026";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[61] = "\\u003d";
        _INT_TO_CHARARRAY = new char[10];
        for (i = 0; i < 10; ++i) {
            JsonWriter._INT_TO_CHARARRAY[i] = (char)(i + 48);
        }
        NULL_VALUE = new char[]{'n', 'u', 'l', 'l'};
        TRUE_VALUE = new char[]{'t', 'r', 'u', 'e'};
        FALSE_VALUE = new char[]{'f', 'a', 'l', 's', 'e'};
    }
}

